// TaskHelp.cpp: implementation of the CTaskHelp class.
//////////////////////////////////////////////////////////////////////

#include "Task.h"
#include <iostream.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


void CTaskHelp::Action()
{
	cout << "\nUsage: gcomp.exe <Argument>\n\n" << "Arguments: \n";
	cout << "  -h - Show this help\n";
	cout << "  -d - Decompile 1cv7.md into SRC folder\n";
	cout << "  -c - Compile SRC folder into 1cv7.md\n";
	cout << "\n";/*------------------------*/
	cout << "You may use this optional parameters\n";
	cout << "  -q - Quiet mode. No messages in stdout at all.\n";
	cout << "  -v - Verbose gcomp job.\n";
	cout << "  -vv - Much more verbose gcomp job.\n";
	cout << "  -F <FileName>\n";
	cout << "  -D <Directory>\n";
	cout << "  -DD <Directory>\n";
	cout << "  --external-report - tell to gcomp, that the file is external report (.ert style)\n";
	cout << "  --meta-data - tell to gcomp, that the file is metadata (1cv7.md style)\n";
	cout << "  --no-profiles - gcomp will skip files (streams), named Container.Profile\n";
	cout << "  --truncate-mms - when compiling external reports gcomp will repalce original 'Main MetaData Stream' with empty copy\n";
	cout << "\n";/*------------------------*/
	cout << "By default external reports treated in some special way.\n";
	cout << "When they extracted/compiled the destination/source directory formed as\n";
	cout << "<StartDirectory>\\<FileNameWithoutExtension>\n";
	cout << "But if you specify -DD parameter, directory name will be\n";
	cout << "leaved unchanged.\n";
	cout << "\n";/*------------------------*/
	cout << "For example:\n";
	cout << " > gcomp -d\n";
	cout << "will extract contents of 1cv7.md into directory SRC\n";
	cout << " > gcomp -d -F TestReport.ert -D Reports\n";
	cout << "will extract contents of TestReport.ert into directory Reports\\TestReport\n";
	cout << " > gcomp -d -F TestReport.ert\n";
	cout << "will extract contents of TestReport.ert into directory SRC\\TestReport\n";
	cout << " > gcomp -d --external-report\n";
	cout << "will extract contents of 1cv7.md into directory SRC\\1cv7\n";
	cout << " > gcomp -c -F TestReport.ert\n";
	cout << "will compile file TestReport.ert from directory TestReport\n";
	cout << " > gcomp -c -F TestReport.ert -D TestReportRource\n";
	cout << "will compile file TestReport.ert from directory TestReportRource\n";
	cout << "\n";/*------------------------*/
	cout << "Use \"gcomp -h | more\", for paging help message, or\n";
	cout << "\"gcomp -h > gcomp_hlp.txt\" for create help file";
}
