
#ifndef Lexer_h
#define Lexer_h

#include "Declarations.h"

class CLexer
{
private:
	CString FileName;
	FILE* File;
	int nLine;
	char* LineBuff;
	char* ptr;

public:
	CLexer(CString& FileName);
	~CLexer();

	bool IsValid() { return File != NULL; };

	void SkipSpaces(const char* spaces = " \t\r\n");
	bool GetToken(CString& Token, const char* delimiters = ": \t\r\n", bool ProceedOnNextLine = true);
	void GetRest(CString& String);

	CString& FilePosInfo();
};


#endif