
#include "Declarations.h"
#include "CommonFunctions.h"
#include "Storage.h"
#include "MMS.h"
#include "NameTable.h"


DWORD ReadBMPSize(IStream* pStream)
{
	//save stream position
	LARGE_INTEGER seek_offset = {0, 0};
	ULARGE_INTEGER pos;
	pStream->Seek(seek_offset, STREAM_SEEK_CUR, &pos);

	DWORD image_start, image_size;

	seek_offset.LowPart = 10; //10    
	pStream->Seek(seek_offset, STREAM_SEEK_CUR, NULL);
	pStream->Read(&image_start, 4, NULL);
	seek_offset.LowPart = 20; //34    
	pStream->Seek(seek_offset, STREAM_SEEK_CUR, NULL);
	pStream->Read(&image_size, 4, NULL);

	//restore stream position
	seek_offset.QuadPart = pos.QuadPart;
	pStream->Seek(seek_offset, STREAM_SEEK_SET, NULL);

	return image_start + image_size;
}

bool CStorage::ExtractPictureGallery(CString& FileName)
{
	const int HdrSize = 28;
	int TailSize;
	int BMP_size;

	CString HdrName, TailName;
	char drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];
	LARGE_INTEGER seek_offset = {0, 0};

	_splitpath(FileName, drive, dir, fname, ext);
	HdrName.Format("%s%s%s%s.head", drive, dir, fname, ext);
	TailName.Format("%s%s%s%s.tail", drive, dir, fname, ext);
	FileName += ".bmp";

	Rewind();

	//Gallery Header
	if( Compare(HdrName, HdrSize) != 0 )
	{
		FILE* HdrFile = fopen(HdrName, "wb");
		CopyToFile(HdrFile, HdrSize);
		fclose(HdrFile);
		Msg(1, "UPD: '%s' -> '%s'\n", StreamName, HdrName);
	}
	AddToExtractedList(HdrName);

	//Gallery bitmap
	seek_offset.LowPart = HdrSize;
	pStream->Seek(seek_offset, STREAM_SEEK_SET, NULL);
	BMP_size = ReadBMPSize(pStream);
	TailSize = StreamInfo.FullSize - HdrSize - BMP_size;
	
	if( Compare(FileName, BMP_size) != 0 )
	{
		FILE* BMPFile = fopen(FileName, "wb");
		CopyToFile(BMPFile, BMP_size);
		fclose(BMPFile);
		Msg(1, "UPD: '%s' -> '%s'\n", StreamName, FileName);
	}
	AddToExtractedList(FileName);

	//Gallery tail
	seek_offset.LowPart = HdrSize + BMP_size;
	pStream->Seek(seek_offset, STREAM_SEEK_SET, NULL);
	if( Compare(TailName, TailSize) != 0 )
	{
		FILE* TailFile = fopen(TailName, "wb");
		CopyToFile(TailFile, TailSize);
		fclose(TailFile);
		Msg(1, "UPD: '%s' -> '%s'\n", StreamName, TailName);
	}
	AddToExtractedList(TailName);

	return true;
}

bool CStorage::ImportPictureGallery(CString& StreamName, CString& FileName)
{
	if( GalleryImported ) return true;

	CString FileNameNoExt = FileName;
	CString HdrName, TailName;
	char dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];

	// 
	int i = FileNameNoExt.ReverseFind('.');
	FileNameNoExt.SetAt(i, '\0');
	i = StreamName.ReverseFind('.');
	StreamName.SetAt(i, '\0');

	_splitpath(FileNameNoExt, NULL, dir, fname, ext);

	HdrName.Format("%s%s%s.head", dir, fname, ext);
	TailName.Format("%s%s%s.tail", dir, fname, ext);

	if( !CreateStream(StreamName) ) return false;
	FromFile(HdrName);
	AppendFile(pStream, FileName);
	AppendFile(pStream, TailName);

	Msg(2, "CPY: '%s'  >> '%s'\n", FileName, StreamName);
	Msg(2, "CPY: '%s' >> '%s'\n", TailName, StreamName);

	GalleryImported = true;
	return true;
}
