
#ifndef Strings_H
#define Strings_H

#include "Declarations.h"

char* trim(char* str);
void str_repeate(CString& dest, CString src, int count);

//      "\n",   "\" -> "\\"
//     -        , 
// inplace   .
void quote_linefeeds(CString& str);
// 
void unquote_linefeeds(CString& str);


/*////////////////////////////////////////////////////////////////////////////////
   ""    . ,   
   
 <>: []
////////////////////////////////////////////////////////////////////////////////*/
void add_offset(CString& dest, int level);
void add_parameter(CString& dest, int level, 
				   const char* id, const char* value, 
				   const char* default_value, bool force = false);
void add_parameter(CString& dest, int level, 
				   const char* id, int value, int default_value);
void add_parameter(CString& dest, int level, 
				   const char* id, unsigned int value, unsigned int default_value);
void add_parameter(CString& dest, int level, 
				   const char* id, bool value, bool default_value);

/*/////////////////////////////////////////////////////////////////////
	    ,  ,    1
	    ;   
/////////////////////////////////////////////////////////////////////*/
void add_quoted(CString& dest, const char* value, bool add_comma = true);
void add_quoted(CString& dest, int value, bool add_comma = true);
void add_quoted(CString& dest, unsigned int value, bool add_comma = true);
void add_quoted(CString& dest, bool value, bool add_comma = true);

#endif