//////////////////////////////////////////////////////////////////////
// TaskCompile.cpp: implementation of the CTaskCompile class.
//////////////////////////////////////////////////////////////////////

#include "Declarations.h"
#include "Task.h"
#include "CommonFunctions.h"
#include "MMS.h"
#include "Storage.h"
#include "NameTable.h"
#include "Ordering.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
void AddFile(FILE* DestFile, CString& FName, bool AddComma = true)
{
	char buff[BUFFER_SIZE];
	long BytesRead;

	FILE *SrcFile = fopen((LPCSTR)FName, "rb");

	if( SrcFile == NULL )
	{
		Msg(0, "ERR: Can't read file '%s' - %s\n", (LPCSTR)FName, strerror(errno));
		exit(1);
	}

	if( ftell(DestFile) > 0 && AddComma )
	{
		fputs(",\r\n", DestFile);
	}

	do
	{
		BytesRead = fread(buff, 1, sizeof(buff), SrcFile);
		if( BytesRead > 0 ) fwrite(buff, 1, BytesRead, DestFile);
	} while( BytesRead == sizeof(buff) );

	fclose(SrcFile);
}

void AddDir(FILE* DestFile, CString& DirName, LPCSTR sID)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_MetadataPart);
	CString FName = nt_rec->PrepareFileName(DirName);

	fputs(",\r\n{\"", DestFile);
	fputs(sID, DestFile);
	fputs("\"\r\n", DestFile);
	if( FileExist(FName) ) AddFile(DestFile, FName);

	struct _finddata_t find_data;
	long hFind;

	hFind = _findfirst(DirName+"\\*", &find_data);
	if( hFind != -1 )
	{
		do
		{
			if( (find_data.attrib & _A_SUBDIR) == 0 ) continue;
			if( IsIgnoredFile(find_data.name) ) continue;

			FName.Format("%s\\%s\\%s.%s", DirName, find_data.name, nt_rec->FileName, nt_rec->Ext);
			if( !FileExist(FName) ) continue;

			AddFile(DestFile, FName);
		} while( _findnext(hFind, &find_data) == 0 );
		_findclose(hFind);
	}

	fputs("\r\n}", DestFile);
}

void AddObject(FILE* mmsFile, CString& Dir, MMSObjectType Type, bool AddComma)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);

	if( nt_rec->FileName.GetLength() != 0 )
		AddFile(mmsFile, nt_rec->PrepareFileName(Dir), AddComma);
	else
		AddDir(mmsFile, nt_rec->PrepareDirName(Dir), nt_rec->sID);
}

void AddPlan(FILE* mmsFile, CString& PlanDir)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_MetadataPart);
	CString PlanMDP = nt_rec->PrepareFileName(PlanDir);

	fprintf(mmsFile, ",\r\n{");
	AddFile(mmsFile, PlanMDP, false);
	fprintf(mmsFile, ",\r\n{\"Accounts\"");

	CObjectOrdering Order(3);
	if( Order.OpenFile(PlanDir) )
	{
		CString AccFName;
		while( Order.ReadString() )
		{
			AccFName.Format("%s\\%s", PlanDir, Order.GetValue(2));
			AddFile(mmsFile, AccFName, true);
		}
	}

	fprintf(mmsFile, "\r\n}}");
}

void AddPlans(FILE* mmsFile, CString& BuhDir)
{
	CNameTableRecord* nt_rec = NameTable.Find(MMS_Plans);
	CString PlansDir = nt_rec->PrepareDirName(BuhDir);

	fprintf(mmsFile, ",\r\n{\"Plans\"");

	CObjectOrdering Order(3);
	if( Order.OpenFile(PlansDir) )
	{
		CString PlanDir;
		while( Order.ReadString() )
		{
			PlanDir.Format("%s\\%s", PlansDir, Order.GetValue(2));
			AddPlan(mmsFile, PlanDir);
		}
	}
	fprintf(mmsFile, "\r\n}");
}

void AddBuh(FILE* mmsFile)
{
	CNameTableRecord* nt_rec = NameTable.Find(MMS_Buh);
	CString BuhDir = nt_rec->PrepareDirName(TaskParameters.DirectoryName);

	fputs(",\r\n{\"Buh\",{", mmsFile);
	AddObject(mmsFile, TaskParameters.DirectoryName, MMS_Buh, false);
	AddObject(mmsFile, BuhDir, MMS_AccParams, true);
	AddPlans(mmsFile, BuhDir);
	AddObject(mmsFile, BuhDir, MMS_ProvParams, true);
	AddObject(mmsFile, BuhDir, MMS_OperParams, true);
	AddObject(mmsFile, BuhDir, NT_AccListForm, true);
	AddObject(mmsFile, BuhDir, NT_UnknownListForm, true);
	AddObject(mmsFile, BuhDir, NT_ProvListForm, true);
	AddObject(mmsFile, BuhDir, MMS_SbKind, true);
	AddObject(mmsFile, BuhDir, MMS_TypOpersDef, true);
	AddObject(mmsFile, BuhDir, MMS_CorrProvsDef, true);
	AddObject(mmsFile, BuhDir, MMS_ProvHardFldDef, true);
	AddObject(mmsFile, BuhDir, MMS_OperJournal, true);
	fputs("\r\n}}", mmsFile);
}

FILE* AssembleMMS()
{
	FILE *mmsFile;

	mmsFile = tmpfile();
	if( mmsFile == NULL )
	{
		Msg(0, "ERR: Can't create temporary file\n");
		exit(1);
	}

	if( TaskParameters.CompoundType == CTaskParameters::external_report )
	{
		AddObject(mmsFile, TaskParameters.DirectoryName, NT_MainMetadataStream, false);
	}
	else
	{
		fputs("{\r\n", mmsFile);

		AddObject(mmsFile, TaskParameters.DirectoryName, MMS_MainDataContDef, false);
		AddObject(mmsFile, TaskParameters.DirectoryName, MMS_TaskItem, true);
		AddObject(mmsFile, TaskParameters.DirectoryName, MMS_GenJrnlFldDef, true);
		AddObject(mmsFile, TaskParameters.DirectoryName, MMS_DocSelRefObj, true);
		AddObject(mmsFile, TaskParameters.DirectoryName, MMS_DocNumDef, true);
		AddObject(mmsFile, TaskParameters.DirectoryName, MMS_Consts, true);
		AddObject(mmsFile, TaskParameters.DirectoryName, MMS_SbCnts, true);
		AddObject(mmsFile, TaskParameters.DirectoryName, MMS_Registers, true);
		AddObject(mmsFile, TaskParameters.DirectoryName, MMS_Documents, true);
		AddObject(mmsFile, TaskParameters.DirectoryName, MMS_Journalisters, true);
		AddObject(mmsFile, TaskParameters.DirectoryName, MMS_EnumList, true);
		AddObject(mmsFile, TaskParameters.DirectoryName, MMS_ReportList, true);
		AddObject(mmsFile, TaskParameters.DirectoryName, MMS_CalcJournals, true);
		AddObject(mmsFile, TaskParameters.DirectoryName, MMS_Calendars, true);
		AddObject(mmsFile, TaskParameters.DirectoryName, MMS_CalcAlgorithms, true);
		AddObject(mmsFile, TaskParameters.DirectoryName, MMS_RecalcRules, true);
		AddObject(mmsFile, TaskParameters.DirectoryName, MMS_CalcVars, true);
		AddObject(mmsFile, TaskParameters.DirectoryName, MMS_Groups, true);
		AddObject(mmsFile, TaskParameters.DirectoryName, MMS_DocumentStreams, true);

		AddBuh(mmsFile);

		fputs("\r\n}", mmsFile);
	}

	return mmsFile;
}


extern int MMS_debug;

void CTaskCompile::Action()
{
	CTime Time = CTime::GetCurrentTime();
	if( TaskParameters.Verbose > 1) Msg(0, "\nExtraction started: %s\n", Time.Format("%Y.%m.%d %H:%M:%S"));

	if( !DirectoryExist(TaskParameters.DirectoryName) )
	{
		Msg(0, "ERR: Source directory '%s' not exist\n", TaskParameters.DirectoryName);
		return;
	}

	FILE *mmsFile = AssembleMMS();
	CMMSObject* MMSObject;
	rewind(mmsFile);
	MMS_InitParser(TaskParameters.DirectoryName+"\\MainMetadataStream");
	if( TaskParameters.Verbose >= 3) MMS_debug = 1;
	int RetCode = MMS_parse(mmsFile, &MMSObject);

	CStorage Storage(TaskParameters.CompoundFileName);
	if( Storage.GetStorage() != NULL )
	{
		CoInitialize(NULL);

		CStorage TypedTextStorage(Storage);
		if( TaskParameters.CompoundType != CTaskParameters::external_report )
			TypedTextStorage.Create(CString("TypedText"));
		MMSObject->Compile(Storage, TypedTextStorage, TaskParameters.DirectoryName);

		CoUninitialize();
	}
	fclose(mmsFile);

	delete MMSObject;

	CTimeSpan CompilationTime = CTime::GetCurrentTime() - Time;
	CString FileName(TaskParameters.CompoundFileName);
	CString DirName(TaskParameters.DirectoryName);
	FileName.AnsiToOem();
	DirName.AnsiToOem();

	Msg(0, "Dir '%s' compiled into '%s' in %s\n", 
		TaskParameters.DirectoryName, TaskParameters.CompoundFileName, 
		CompilationTime.Format("%H:%M:%S"));
}
