
#ifndef UserInterfaces_H
#define UserInterfaces_H 1

#include "Declarations.h"
#include "Lexer.h"

class CUICommand
{
public:
	DWORD ID;
	CString Param1;
	CString Hint;
	BYTE HotKeyModifier; //Alt - 0x11, Ctrl - 0x09, Shift - 0x05   OR 
	WORD HotKey; //ScanCode 
	CString Command;
	CString CmdParameter;

public:
	CString AsString(bool IsChild);
};

class CUICommands
{
public:
	DWORD ID;
	CString StorageName;
	CString InterfaceName;
	CString ParentInterface;
	CString Description;
	DWORD NoOperMenuPresent;
	DWORD IsDefault;
	DWORD NCommands;
	CArray<CUICommand, CUICommand&> Commands;
	bool IsChild;

public:
	CUICommands();

	//   
	DWORD Read(CStorage& Storage, CString& UIName);
	bool ReadFromFile(CString& FileName);
	bool Write(CStorage& Storage, CString& SrcDir);
	CString AsString();
};

class CUIMenu
{
	typedef enum {MainMenu, MenuGroup, MenuItem, MenuDividor} TMenuType;
public:
	TMenuType Type;
	CUIMenu* Parent;
	DWORD Level;
	DWORD NItems;
	CString Caption;
	DWORD ID;
	CArray<CUIMenu, CUIMenu&> Items;

public:
	CUIMenu();

	CUIMenu* AddItem();

public:
	//   
	DWORD Read(CStorage& Storage, CUIMenu* Parent);
	bool ReadFromFile(CString& FileName);
	bool ReadFromFile(CLexer& Lexer, CUIMenu* Parent, int level);
	bool Write(CStorage& Storage, CString& SrcDir);
	CString AsString();
};

class CUIPanel
{
public:
	CString Caption;
	DWORD NButtons;
	DWORD Placement;
	DWORD IsVisible;
	DWORD OnNewLine;

public:
	CUIPanel()
	{
		NButtons = 0;
		Placement = 0xE81B;
		IsVisible = 1;
		OnNewLine = 0;
	};

public:
	//   
	DWORD Read(CStorage& Storage);
	bool Write(CStorage& Storage);
	CString AsString();
};

class CButton
{
public:
	DWORD ID;
	CString Caption;

public:
	CButton() {ID = 0;};

	CString AsString(bool WithCaption);
};

class CUIPanels
{
private:
	DWORD BMP_offset;

public:
	DWORD ID;
	DWORD NPanels;
	CArray<CUIPanel, CUIPanel&> Panels;
	DWORD NButtons;
	CArray<CButton, CButton&> AllButtons;
	DWORD NTextButtons;
	CArray<CButton, CButton&> TextButtons;
	DWORD NPictureButtons;
	CArray<CButton, CButton&> PictureButtons;

public:
	CUIPanels();

	CUIPanel* AddPanel();
	CButton* AddButton();
	CButton* AddTextButton();
	CButton* AddPictureButton();

public:
	bool Read(CStorage& Storage);
	bool ReadFromFile(CString& FileName);
	bool Write(CStorage& Storage, CString& SrcDir);
	CString AsString();
	void ExtractBMP(CString& Dir, CStorage& Storage);
};


class CUserInterface;
typedef CUserInterface* PCUserInterface;
class CUserInterfaces;

class CUserInterfaces : public CArray<PCUserInterface, PCUserInterface&>
{
public:
	~CUserInterfaces();

public:
	void AddInterface(CUserInterface* Interface);
	CUserInterface* FindInterface(CString& Name);
	void Extract(CString& Dir, CStorage& Storage);

	void ReadFromDir(CString& SrcDir, CUserInterface* Parent = NULL);
};

class CUserInterface
{
public:
	CString StorageName;
	CString DirName;

public:
	CString Name;
	CUserInterface* Parent;
	CUICommands Commands;
	CUIMenu Menu;
	CUIPanels Panels;

	CUserInterfaces Children;

public:
	CUserInterface() {Parent = NULL;};

public:
	void Read(CString& Dir, CStorage& Storage, CMMSObject* Container);
	bool ReadFromDir(CString& SrcDir, CUserInterface* Parent);
	void Extract(CString& Dir, CStorage& Storage);
	bool Write(CStorage& Storage);
	void MakeContainerContents(CString& CC);
};


bool DecompileUI(CString& DestDir, CStorage& Storage);
bool CompileUI(CStorage& Storage, CString& SrcDir);

#endif
