// TaskDecompile.cpp: implementation of the CTaskDecompile class.
//////////////////////////////////////////////////////////////////////

#include <io.h>
#include "Task.h"
#include "CommonFunctions.h"
#include "Storage.h"
#include "NameTable.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern CTaskParameters TaskParameters;
extern CNameTable NameTable;

void CTaskDecompile::FindDeletedStreams(CString& Path)
{
	struct _finddata_t find_data;
	long hFind;
	CString Pattern(Path);
	CString FileName;

	Pattern += "\\*.*";
	
	hFind = _findfirst(Pattern, &find_data);
	if( hFind != -1 )
	{
		do
		{
			if (0 == strcmp(find_data.name, ".")) continue;
			if (0 == strcmp(find_data.name, "..")) continue;
			if (0 == stricmp(find_data.name, "CVS")) continue;

			FileName.Format("%s\\%s", Path, find_data.name);

			if( (find_data.attrib & _A_SUBDIR) != 0 )
			{
				FindDeletedStreams(FileName);
			}
			else
			{
				CheckPrune(FileName);
			}
		} while( _findnext(hFind, &find_data) == 0 );
		_findclose(hFind);
	}
}


void CTaskDecompile::Action()
{
	CTime Time = CTime::GetCurrentTime();
	Msg(0, "\nExtraction started: %s\n", Time.Format("%Y.%m.%d %H:%M:%S"));

	CStorage Storage;
	Storage.Open(TaskParameters.CompoundFileName);

	CreateDirectory(TaskParameters.DirectoryName);

	CoInitialize(NULL);
	
	CNameTableRecord* nt_rec = NameTable.Find(NT_MainMetadataStream);
	if( TaskParameters.CompoundType == CTaskParameters::external_report )
	{
		MMS = (CMMS*)Storage.ParseStream(nt_rec->StorageName);
	}
	else
	{
		Storage.Open(CString("Metadata"));
		MMS = (CMMS*)Storage.ParseStream(nt_rec->StorageName);
		Storage.Close();
	}

	if( MMS != NULL )
	{
		MMS->Decompile(TaskParameters.DirectoryName, Storage);
		delete MMS;
		FindDeletedStreams(TaskParameters.DirectoryName);
	}

	CoUninitialize();

	CTimeSpan ExtractionTime = CTime::GetCurrentTime() - Time;
	Msg(0, "'%s' extracted into '%s'\n", TaskParameters.CompoundFileName, TaskParameters.DirectoryName);
	Msg(0, "Extraction takes: %s\n", ExtractionTime.Format("%H:%M:%S"));
}
