// Task.h: interface for the CTask class tree.
//
//////////////////////////////////////////////////////////////////////

#ifndef TASK_H
#define TASK_H

#include <afx.h>

#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>
#include "StreamInfo.h"
#include "MMS.h"


class CTaskParameters
{
public:
	enum TaskTypes {
		compile = 1,
		decompile = 2,
		help = 3
	};

	enum CompoundTypes {
		by_extension = 0,
		external_report = 1,
		meta_data = 2
	};

	TaskTypes TaskType;
	CompoundTypes CompoundType;
	
	// -1 - supress all messagess (quiet mode)
	// 0 - errors only
	// 1 - real deeds, if any
	// 2 - all together, checks included.
	// (maybe enum?)
	int Verbose;


	CString CompoundFileName;
	CString DirectoryName;

	bool NoProfiles;
	bool TruncateMMS;
	bool English;
	bool ShowVersion;

public:
	inline CTaskParameters() 
	{
		TaskType = help;
		CompoundType = by_extension;
		Verbose = 0;
		NoProfiles = false;
		TruncateMMS = false;
		English = false;
		ShowVersion = false;
	};

	~CTaskParameters();

	void ParseCommandLine(int argc, TCHAR* argv[]);
};


//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
class CTask  
{
public:
	virtual void Action();

public:
	CTask(int argc, TCHAR* argv[]);
	CTask();
	virtual ~CTask();

private:
	CTask* thisTask;

protected:
	//returns string containing minimal MainMetadataStream - needed for external reports
	char* MinimalMDS();
};

//////////////////////////////////////
class CTaskHelp : public CTask  
{
public:
	void Action();
	CTaskHelp() {};
};

//////////////////////////////////////
class CTaskCompile : public CTask  
{
public:
	void Action();
	CTaskCompile() {};
};

//////////////////////////////////////
class CTaskDecompile : public CTask  
{
private:
	CMMS* MMS;

public:
	void Action();
	CTaskDecompile() { MMS = NULL; };

private:
	void CTaskDecompile::ReadMMS(IStorage* pStorage);
	void FindDeletedStreams(CString& Path);
};


#endif
