#include "MMS.h"
#include "NameTable.h"
#include "Storage.h"
#include "CommonFunctions.h"

extern CNameTable NameTable;

///////////////////////////////////////////////////////////////////////
///////////  class CMMSObjectWithProps methods  ///////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSObjectWithProps::ExtractMetadata(CString& DestDir, MMSObjectType Type)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString Content = AsString();

	CopyStringToFile(Content, nt_rec->PrepareFileName(DestDir));
}

void CMMSObjectWithProps::ExtractMetadata(CString& DestDir)
{
	ExtractMetadata(DestDir, NT_MetadataPart);
}

//     '_'.     
void MangleFileName(CString str)
{
	char* ptr = (char*)(LPCSTR)str;
	while( *ptr != '\0' )
	{
		int c = (unsigned char)(*ptr); //unsigned -    
		if( !__iscsym(c) ) { *ptr = '_'; Msg(2, "Simbol replacement in filename\n"); };
		ptr++;
	}
}

void CMMSObjectWithProps::ExtractMoxelPages(CString& DestDir, CStorage& WBStorage)
{
	CNameTableRecord* nt_rec_mxl = NameTable.Find(NT_MoxelSheet);
	CMMSNodeList* WBContent = (CMMSNodeList*)WBStorage.ParseStream(CString("Container.Contents"));
	CString Order, OrdStr;

	//Analyze Container.Contents and extract moxel pages if any.
	CString std_tab_name("Moxel WorkPlace");
	CString ID_mxl("Moxcel.Worksheet");
	CString mxlFName;
	int order = 0;
	
	POSITION pos = WBContent->GetHeadPosition();
	while( pos != NULL )
	{
		CMMSObject* SubNode = WBContent->GetNext(pos);
		if( SubNode->sID == ID_mxl )
		{
			CMMSObject* pMXL = SubNode->GetPropByNum(1);
			CString tab_name = (LPCSTR)pMXL->sID;
			CString page_suffix = Suffix(SubNode->GetPropByNum(0)->sID);
			if( tab_name == std_tab_name )
				tab_name = "";
			else
				MangleFileName(tab_name);

			mxlFName.Format("%s\\%s.%s.%s", DestDir, tab_name, page_suffix, nt_rec_mxl->Ext);
			WBStorage.CopyToFile(SubNode->GetPropByNum(0)->sID, mxlFName);
			
			OrdStr.Format("%s.%s.%s\t%s\t%s\r\n", 
				tab_name, page_suffix, nt_rec_mxl->Ext, // 
				pMXL->sID,    // 
				page_suffix); //
			Order += OrdStr;

			order++;
		}
	}

	if( order > 0 ) 
	{
		CNameTableRecord* nt_rec_ord = NameTable.Find(NT_ObjectOrdering);
		CopyStringToFile(Order, nt_rec_ord->PrepareFileName(DestDir));
	}
	delete WBContent;
}

void CMMSObjectWithProps::ExtractWorkBook(CString& DestDir, CStorage& Storage)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_Workbook);
	if( Storage.Open(nt_rec->StorageName) )
	{
		// 
		ExtractStreamByType(Storage, NT_FormModule, DestDir);
		// 
		ExtractStreamByType(Storage, NT_DialogForm, DestDir);

		// 
		ExtractMoxelPages(DestDir, Storage);

		Storage.Close();
	}
}

void CMMSObjectWithProps::ExtractDescription(CString& DestDir, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_UserHelpStor);
	if( TypedTextStorage.Open(nt_rec->PrepareStorageName(ID)) )
	{
		ExtractStreamByType(TypedTextStorage, NT_UserHelp, DestDir);
		TypedTextStorage.Close();
	}
}

void CMMSObjectWithProps::ExtractListForms(CMMSObject* Forms, CString& Dir, 
										   CStorage& Storage, CString Prefix)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_ListForm);
	CString StorName;

	for( int i = 0; i < Forms->GetNProps(); i++ )
	{
		CMMSObject* Form = Forms->GetPropByNum(i);
		CString FormDir;
		FormDir.Format("%s\\%s.%s", Dir, Form->GetPropByNum(0)->sID, nt_rec->Ext);
		CreateDirectory((LPCSTR)FormDir);
		
		StorName.Format("%s%i", Prefix, Form->ID);
		if( Storage.Open(StorName) )
		{
			ExtractWorkBook(FormDir, Storage);
			Storage.Close();
		}
	}
}

void CMMSObjectWithProps::ExtractStreamByType(CStorage& Storage, MMSObjectType Type, CString& Dir)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage SubStorage(Storage);
	SubStorage.CopyToFile(nt_rec->PrepareStorageName(ID), nt_rec->PrepareFileName(Dir));
}

void CMMSObjectWithProps::ExtractOrdering(CString& DestDir)
{
	int nProps = GetNProps();
	if( nProps == 0 ) return;

	CString Order, OrdStr;
	for( int i = 0; i < nProps; i++ )
	{
		CMMSObject* obj = GetPropByNum(i);
		OrdStr.Format("%i\t%s\r\n", obj->ID, obj->sID);
		Order += OrdStr;
	}

	CNameTableRecord* nt_rec_ord = NameTable.Find(NT_ObjectOrdering);
	CopyStringToFile(Order, nt_rec_ord->PrepareFileName(DestDir));
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSBasicObject methods  ///////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSBasicObject::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMS methods  //////////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMS::ExtractStorage(CString& Dir, CStorage& Storage, MMSObjectType Type, bool WithContainerCOntents)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString DestDir = nt_rec->PrepareDirName(Dir);
	CStorage SrcStorage(Storage);

	if( SrcStorage.Open(nt_rec->PrepareStorageName(ID)) )
	{
		CreateDirectory((LPCSTR)DestDir);
		SrcStorage.Extract(DestDir, WithContainerCOntents);
	}
}

void CMMS::ExtractCommonMXL(CString& Dir, CStorage& Storage)
{
	CNameTableRecord* nt_rec_gd = NameTable.Find(NT_GlobalData);
	CNameTableRecord* nt_rec = NameTable.Find(NT_CommonMXL);
	CString GDDir = nt_rec->PrepareDirName(Dir);
	
	CString StorName = nt_rec_gd->StorageName;
	StorName += "\\";
	StorName += nt_rec->StorageName;
	
	CreateDirectory(GDDir);
	CStorage GDStorage(Storage);
	if( GDStorage.Open(StorName) )
	{
		ExtractWorkBook(GDDir, GDStorage);
	}
}


CString PropertyPath(CMMSNodeList& PropPath)
{
	CString Path;
	bool add_dot = false;

	POSITION pos = PropPath.GetHeadPosition();
	while( pos != NULL )
	{
		CMMSObject* obj = PropPath.GetNext(pos);
		
		CString sID;
		if( obj->ID == 0 )
			sID = obj->sID; //    ,    
		else if( obj->ID == atoi(obj->sID) )
			if( obj->GetPropByNum(0) != NULL )
				sID = obj->GetPropByNum(0)->sID; // 
			else
				sID = obj->sID;
		else
			sID = obj->sID;

		//  .      sID .
		char* ptr = (char*)(LPCSTR)sID;
		while( *ptr != '\0' )
		{
			int c = (unsigned char)(*ptr); //unsigned -    
			if( isspace(c) )
				*ptr = '_';
			else if( !__iscsym(c) )
			{
				sID = obj->sID;
				break;
			}
			ptr++;
		}

		if( add_dot ) Path += ".";
		Path += sID;
		add_dot = true;
	}

	return Path;
}

void CMMS::ExtractDescriptions(CString& Dir, CStorage& Storage)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_UserHelpStor);
	CNameTableRecord* nt_rec_file = NameTable.Find(NT_UserHelp);
	int prefix_sz = nt_rec->StorageName.GetLength();
	CString StorName, FileName;
	CString DescrDir;

	DescrDir.Format("%s\\%s", Dir, nt_rec->Dir);
	CreateDirectory(DescrDir);

	Storage.Open("TypedText");
	IEnumSTATSTG *ppenum;
	STATSTG stat;
	unsigned long uCount;
	Storage.GetStorage()->EnumElements(0, NULL, 0, &ppenum);
	while ( S_OK == ppenum->Next(1, &stat, &uCount) )
	{
		if( (stat.type & STGTY_STORAGE ) != 0 )
		{
			StorName.Format("%S", stat.pwcsName);
			if( StorName.Left(prefix_sz) != nt_rec->StorageName ) continue;
			int ID = atoi(StorName.Mid(prefix_sz));

			CMMSNodeList PropPath;
			PropPath.DestroyObjects = false;
			CMMSObject* obj = GetProperty(ID, true, &PropPath);
			
			if( obj == NULL ) continue;
			if( obj->Type == MMS_SbCnt ) continue;
			if( obj->Type == MMS_Document ) continue;
			if( obj->Type == MMS_Report ) continue;
			if( obj->Type == MMS_CalcJournal ) continue;
			if( obj->Type == MMS_CalcAlgorithm ) continue;

			Storage.Open(StorName);
			FileName.Format("%s\\%i.%s.%s", DescrDir, obj->ID, PropertyPath(PropPath), nt_rec_file->Ext);
			Storage.CopyToFile(nt_rec_file->StorageName, FileName);
			Storage.Close();
		}
	}
	ppenum->Release();

	Storage.Close();
}

void CMMS::Decompile(CString& Dir, CStorage& Storage)
{
	int nProps = GetNProps();
	for( int i = 0; i < nProps; i++ )
	{
		GetPropByNum(i)->Decompile(Dir, Storage);
	}

	// 
	ExtractStreamByType(Storage, NT_GlobalModule, Dir);
	// 
	ExtractCommonMXL(Dir, Storage);
	//
	ExtractStorage(Dir, Storage, NT_PictureGallery, false);
	// 
	ExtractStorage(Dir, Storage, NT_UserInterface, true);
	// 
	ExtractStorage(Dir, Storage, NT_UserRights, true);

	// 
	ExtractStreamByType(Storage, NT_GUIDData, Dir);
	ExtractStreamByType(Storage, NT_TagStream, Dir);

	//
	ExtractDescriptions(Dir, Storage);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSMetadataPart methods  //////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSMetadataPart::Decompile(CString& Dir, CStorage& Storage)
{
	ExtractMetadata(Dir, Type);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSSubCnt methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSSbCnt::Decompile(CString& BaseDir, CStorage& Storage, CStorage& TypedTextStorage, CStorage& SubFolderStorage, CStorage& SubListStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage ScStorage(Storage);
	CString ScDir;
	CString StorName;

	ScDir.Format("%s\\%s", BaseDir, sID);
	CreateDirectory((LPCSTR)ScDir);

	//
	ExtractMetadata(ScDir);

	if( ScStorage.Open(nt_rec->PrepareStorageName(ID)) ) //    ,     
	{
		ExtractWorkBook(ScDir, ScStorage);
	}

	//
	ExtractDescription(ScDir, TypedTextStorage);

	// 
	nt_rec = NameTable.Find(NT_SubcontoFolder);
	CStorage GroupStorage(SubFolderStorage);
	if( GroupStorage.Open(nt_rec->PrepareStorageName(ID)) != NULL )
	{
		CString SubFldDir = nt_rec->PrepareDirName(ScDir);
		CreateDirectory((LPCSTR)SubFldDir);
		ExtractWorkBook(SubFldDir, GroupStorage);
	}

	// 
	nt_rec = NameTable.Find(NT_SubcontoListForm);
	CMMSObject* ListForms = GetProperty(CString("Form"));
	ExtractListForms(ListForms, ScDir, SubListStorage, nt_rec->StorageName);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSSbCnts methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSSbCnts::Decompile(CString& BaseDir, CStorage& Storage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage ScsStorage(Storage,       nt_rec->StorageName);
	CStorage TypedTextStorage(Storage, "TypedText");
	CStorage SubFolderStorage(Storage, "SubFolder");
	CStorage SubListStorage(Storage,   "SubList");
	CString  ScsDir = nt_rec->PrepareDirName(BaseDir);

	CreateDirectory((LPCSTR)ScsDir);

	for( int i = 0; i < nProps; i++ )
	{
		CMMSSbCnt* pSc = (CMMSSbCnt*)Properties[i];
		pSc->Decompile(ScsDir, ScsStorage, TypedTextStorage, SubFolderStorage, SubListStorage);
	}

	ExtractOrdering(ScsDir);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSGenJrnlFldDef methods  /////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSGenJrnlFldDef::Decompile(CString& Dir, CStorage& Storage)
{
	ExtractMetadata(Dir, Type);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSDocSelRefObj methods  //////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSDocSelRefObj::Decompile(CString& Dir, CStorage& Storage)
{
	ExtractMetadata(Dir, Type);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSDocNumDef methods  /////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSDocNumDef::Decompile(CString& Dir, CStorage& Storage)
{
	ExtractMetadata(Dir, Type);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSDocument methods  //////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSDocument::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage TransactStorage(TypedTextStorage);
	CString DocDir(Dir);

	DocDir += "\\";
	DocDir += sID;
	CreateDirectory((LPCSTR)DocDir);

	ExtractMetadata(DocDir);

	if( Storage.Open(nt_rec->PrepareStorageName(ID)) ) //    ,     
	{
		ExtractWorkBook(DocDir, Storage);
		Storage.Close();
	}

	// 
	nt_rec = NameTable.Find(NT_TransModuleStor);
	if( TransactStorage.Open(nt_rec->PrepareStorageName(ID)) )
	{
		nt_rec = NameTable.Find(NT_TransactModule);
		TransactStorage.CopyToFile(nt_rec->StorageName, nt_rec->PrepareFileName(DocDir));
	}

	ExtractDescription(DocDir, TypedTextStorage);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSDocuments methods  /////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSDocuments::Decompile(CString& Dir, CStorage& Storage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage TypedTextStorage(Storage, "TypedText");
	CString DocsDir = nt_rec->PrepareDirName(Dir);

	CreateDirectory((LPCSTR)DocsDir);

	Storage.Open(nt_rec->PrepareStorageName(ID));
	for( int i = 0; i < nProps; i++ )
	{
		CMMSDocument* pDoc = (CMMSDocument*)Properties[i];
		pDoc->Decompile(DocsDir, Storage, TypedTextStorage);
	}
	Storage.Close();

	ExtractOrdering(DocsDir);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSReport methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSReport::Decompile(CString& Dir, CStorage& Storage, CString& Prefix, CStorage& TypedTextStorage)
{
	CString RptDir(Dir);
	CString StorName;

	RptDir += "\\";
	RptDir += sID;
	CreateDirectory((LPCSTR)RptDir);

	ExtractMetadata(RptDir);
	
	StorName.Format("%s%i", Prefix, ID);
	if( Storage.Open(StorName) )
	{
		ExtractWorkBook(RptDir, Storage);
		Storage.Close();
	}

	ExtractDescription(RptDir, TypedTextStorage);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSReportList methods  /////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSReportList::Decompile(CString& Dir, CStorage& Storage)
{
	CNameTableRecord* nt_rec = NameTable.Find(sID);
	CStorage TypedTextStorage(Storage, "TypedText");
	CString ReportsDir = nt_rec->PrepareDirName(Dir);

	CreateDirectory((LPCSTR)ReportsDir);

	if( Storage.Open(nt_rec->StorageName) )
	{
		CString ReportStorName = nt_rec->StorageName + "_Number";
		for( int i = 0; i < nProps; i++ )
		{
			CMMSReport* rpt = (CMMSReport*)Properties[i];
			rpt->Decompile(ReportsDir, Storage, ReportStorName, TypedTextStorage);
		}
		Storage.Close();
	}

	ExtractOrdering(ReportsDir);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSJournalister methods  //////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSJournalister::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString JournalDir = Dir;
	CMMSObject* Forms = GetProperty(CString("Form"));

	JournalDir += "\\";
	JournalDir += sID;
	CreateDirectory((LPCSTR)JournalDir);

	ExtractMetadata(JournalDir);
	ExtractDescription(JournalDir, TypedTextStorage);

	ExtractListForms(Forms, JournalDir, Storage, nt_rec->StorageName);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSJournalisters methods  /////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSJournalisters::Decompile(CString& SrcDir, CStorage& Storage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage TypedTextStorage(Storage, "TypedText");
	CString JournalsDir = nt_rec->PrepareDirName(SrcDir);

	CreateDirectory((LPCSTR)JournalsDir);

	Storage.Open(nt_rec->StorageName);
	for( int i = 0; i < nProps; i++ )
	{
		CMMSJournalister* pJournal = (CMMSJournalister*)Properties[i];
		pJournal->Decompile(JournalsDir, Storage, TypedTextStorage);
	}
	Storage.Close();

	ExtractOrdering(JournalsDir);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSCalcJournal methods  ///////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCalcJournal::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString JournalDir(Dir);
	CMMSObject* Forms = GetProperty(CString("Form"));

	JournalDir += "\\";
	JournalDir += sID;
	CreateDirectory((LPCSTR)JournalDir);

	ExtractMetadata(JournalDir);
	ExtractDescription(JournalDir, TypedTextStorage);
	ExtractListForms(Forms, JournalDir, Storage, nt_rec->StorageName);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSCalcJournals methods  //////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCalcJournals::Decompile(CString& Dir, CStorage& Storage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString JournalsDir = nt_rec->PrepareDirName(Dir);
	CStorage TypedTextStorage(Storage, "TypedText");

	CreateDirectory((LPCSTR)JournalsDir);

	Storage.Open(nt_rec->StorageName);
	for( int i = 0; i < nProps; i++ )
	{
		CMMSCalcJournal* pJournal = (CMMSCalcJournal*)Properties[i];
		pJournal->Decompile(JournalsDir, Storage, TypedTextStorage);
	}
	Storage.Close();

	ExtractOrdering(JournalsDir);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSCaclAlgorithm methods  /////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCaclAlgorithm::Decompile(CString& Dir, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec_stor = NameTable.Find(Type);
	CString AlgDir(Dir);

	AlgDir += "\\";
	AlgDir += sID;
	CreateDirectory((LPCSTR)AlgDir);

	ExtractMetadata(AlgDir);

	if( TypedTextStorage.Open(nt_rec_stor->PrepareStorageName(ID)) )
	{
		CNameTableRecord* nt_rec = NameTable.Find(NT_CalcAlgorithm);
		TypedTextStorage.CopyToFile(nt_rec->StorageName, nt_rec->PrepareFileName(AlgDir));
		TypedTextStorage.Close();
	}

	ExtractDescription(AlgDir, TypedTextStorage);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSCaclAlgorithms methods  ////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCaclAlgorithms::Decompile(CString& Dir, CStorage& Storage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString AlgsDir = nt_rec->PrepareDirName(Dir);

	CreateDirectory((LPCSTR)AlgsDir);

	if( Storage.Open(nt_rec->StorageName) )
	{
		for( int i = 0; i < nProps; i++ )
		{
			CMMSCaclAlgorithm* pAlg = (CMMSCaclAlgorithm*)Properties[i];
			pAlg->Decompile(AlgsDir, Storage);
		}
		Storage.Close();
	}

	ExtractOrdering(AlgsDir);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSBuh methods  ///////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSBuh::ExtractForm(CString& Dir, CStorage& Storage, MMSObjectType Type)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString DestDir = nt_rec->PrepareDirName(Dir);
	CStorage FormStor(Storage, nt_rec->PrepareStorageName(BuhID));
	CreateDirectory((LPCSTR)DestDir);
	ExtractWorkBook(DestDir, FormStor);
}

void CMMSBuh::ExtractListForm(CString& Dir, CStorage& Storage, MMSObjectType Type, CMMSObject* ListForms)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString DestDir = nt_rec->PrepareDirName(Dir);
	CStorage ListStor(Storage, nt_rec->StorageName);
	CreateDirectory((LPCSTR)DestDir);
	ExtractListForms(ListForms, DestDir, ListStor, nt_rec->StorageName+"_Number");
}

void CMMSBuh::Decompile(CString& Dir, CStorage& Storage)
{
	// 
	ExtractForm(Dir, Storage, NT_AccForm);
	// 
	ExtractForm(Dir, Storage, NT_OperForm);

	//  
	ExtractListForm(Dir, Storage, NT_AccListForm, AccListForms);
	// 
	ExtractListForm(Dir, Storage, NT_ProvListForm, ProvListForms);
	// 
	ExtractListForm(Dir, Storage, NT_OperListForm, OperListForms);

	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CopyStringToFile(AsString(), nt_rec->PrepareFileName(Dir));
}
