
#include "NameTable.h"
#include "CommonFunctions.h"

CNameTable NameTable;


CNameTable::CNameTable()
{
	nRecords = 0;
	NameTable.SetSize(100);

	AddRecord(MMS_MainDataContDef, "MainDataContDef",  NULL, false, NULL, "", "mdp");
	AddRecord(MMS_TaskItem,        "TaskItem",         NULL, false, NULL, "", "mdp");
	AddRecord(MMS_GenJrnlFldDef,   "GenJrnlFldDef",    NULL, false, NULL, "", "mdp");
	AddRecord(MMS_DocSelRefObj,    "DocSelRefObj",     NULL, false, NULL, "", "mdp");
	AddRecord(MMS_DocNumDef,       "DocNumDef",        NULL, false, NULL, "", "mdp");
	AddRecord(MMS_Consts,          "Consts",           NULL, false, NULL, "", "mdp");
	AddRecord(MMS_Registers,       "Registers",        NULL, false, NULL, "", "mdp");
	AddRecord(MMS_EnumList,        "EnumList",         NULL, false, NULL, "", "mdp");
	AddRecord(MMS_Calendars,       "Calendars",        NULL, false, NULL, "", "mdp");
	AddRecord(MMS_RecalcRules,     "RecalcRules",      NULL, false, NULL, "", "mdp");
	AddRecord(MMS_Groups,          "Groups",           NULL, false, NULL, "", "mdp");
	AddRecord(MMS_DocumentStreams, "Document Streams", NULL, false, NULL, "", "mdp");
	AddRecord(MMS_Buh,             "Buh",              NULL, false, NULL, "", "mdp");

	AddRecord(MMS_SbCnts,          "SbCnts",           "Subconto", false, "");
	AddRecord(MMS_Documents,       "Documents",        "Document", false, "");
	AddRecord(MMS_Journalisters,   "Journalisters",    "Journal", false, "");
	AddRecord(MMS_ReportList,      "ReportList",       "Report", false, "");
	AddRecord(MMS_CalcJournals,    "CJ",               "CalcJournal", false, "");
	AddRecord(MMS_CalcAlgorithms,  "Algorithms",       "TypedText", false, "");
	AddRecord(MMS_CalcVars,        "CalcVars",         "CalcVar", false, "");

	AddRecord(MMS_SbCnt,           NULL,              "Subconto_Number",  true,  NULL);
	AddRecord(MMS_Document,        NULL,              "Document_Number",  true,  NULL);
	AddRecord(MMS_Report,          NULL,              "Report_Number",    true,  NULL);
	AddRecord(MMS_Journalister,    NULL,              "Journal_Number",   false, NULL);
	AddRecord(MMS_CalcJournal,     NULL,              "CalcJournal_Number", false, NULL);
	AddRecord(MMS_CalcAlgorithm,   NULL,              "CalcAlg_Number",   true,  NULL);

	AddRecord(NT_MetadataPart,     NULL,              NULL,               false, NULL, "", "mdp");
	AddRecord(NT_Workbook,         NULL,              "WorkBook",         false, NULL);
	AddRecord(NT_FormModule,       NULL,              "MD Programm text", false, NULL, "", "1s");
	AddRecord(NT_DialogForm,       NULL,              "Dialog Stream",    false, NULL, "", "frm");
	AddRecord(NT_MoxelSheet,       NULL,              "Page",             false, NULL, NULL, "mxl");
	AddRecord(NT_ListForm,         NULL,              NULL,               false,  NULL, NULL, "fls");
	AddRecord(NT_GlobalModuleStor, NULL,              "TypedText\\ModuleText_Number1", false, NULL);
	AddRecord(NT_GlobalModule,     NULL,              "TypedText\\ModuleText_Number1\\MD Programm text", false, NULL, "", "1s");
	AddRecord(NT_TransModuleStor,  NULL,              "Transact_Number",  true,  NULL);
	AddRecord(NT_TransactModule,   NULL,              "MD Programm text", false, NULL, "", "1s");
	AddRecord(NT_UserHelpStor,     NULL,              "UserHelp_Number",  true,  "");
	AddRecord(NT_UserHelp,         NULL,              "MD Programm text", false, NULL, "", "txt");
	AddRecord(NT_SubcontoFolder,   NULL,              "SubFolder_Number", true,  "");
	AddRecord(NT_SubcontoListForm, NULL,              "SubList_Number",   true,  NULL, NULL, "fls");
	AddRecord(NT_CalcAlgorithm,    NULL,              "MD Programm text", false, NULL, "", "1s");
	AddRecord(NT_AccForm,          NULL,              "AccountChart\\AccountChart_Number", true,  "");
	AddRecord(NT_OperForm,         NULL,              "Operation\\Operation_Number", true,  "");
	AddRecord(NT_AccListForm,      NULL,              "AccountChartList", false,  "");
	AddRecord(NT_OperListForm,     NULL,              "OperationList",    false,  "");
	AddRecord(NT_ProvListForm,     NULL,              "ProvList",         false,  "");
	AddRecord(NT_GlobalData,       NULL,              "GlobalData",       false,  NULL);
	AddRecord(NT_CommonMXL,        NULL,            "GlobalData_Number1", false,  "");
	AddRecord(NT_PictureGallery,   NULL,              "Picture",          false,  "PictureGallery");
	AddRecord(NT_GUIDData,         NULL,              "Metadata\\GUIDData",false,  NULL, "GUIDData");
	AddRecord(NT_TagStream,        NULL,              "Metadata\\TagStream",false,  NULL, "TagStream");
	AddRecord(NT_UserInterface,    NULL,              "UserDef\\Page.1",  false,  "");
	AddRecord(NT_UserRights,       NULL,              "UserDef\\Page.2",  false,  "");
	AddRecord(NT_ObjectOrdering,   NULL,              NULL,               false,  NULL, "", "ord");
}

void CNameTable::AddRecord(MMSObjectType Type, LPCSTR sID,
						   LPCSTR StorageName, bool HasSuffix, 
						   LPCSTR Dir, LPCSTR FileName, LPCSTR Ext)
{
	CNameTableRecord* rec = new CNameTableRecord;
	rec->Type = Type;
	if( sID != NULL ) rec->sID = sID;
	if( StorageName != NULL ) rec->StorageName = StorageName;
	rec->HasSuffix = HasSuffix;
	if( Dir != NULL ) rec->Dir = Dir;
	if( FileName != NULL ) rec->FileName = FileName;
	if( Ext != NULL ) rec->Ext = Ext;

	if( nRecords >= NameTable.GetSize() )
		NameTable.Add(rec);
	else
		NameTable.SetAt(nRecords, rec);
	nRecords++;
}

CNameTableRecord* CNameTable::Find(MMSObjectType Type)
{
	for( int i = 0; i < nRecords; i++ )
		if( NameTable[i]->Type == Type ) return NameTable[i];
	return NULL;
}

CNameTableRecord* CNameTable::Find(CString& sID)
{
	for( int i = 0; i < nRecords; i++ )
		if( NameTable[i]->sID == sID ) return NameTable[i];
	return NULL;
}

CString CNameTable::PrepareFileName(MMSObjectType Type, CString& Dir)
{
	CNameTableRecord* nt_rec = Find(Type);
	return nt_rec->PrepareFileName(Dir);
}


CString CNameTableRecord::PrepareFileName(CString& BaseDir)
{
	CString FullFName(BaseDir);
	
	if( Dir.GetLength() > 0 )
	{
		FullFName += "\\";
		FullFName += Dir;
	}
	FullFName += "\\";
	FullFName += FileName;
	if( Ext.GetLength() > 0 )
	{
		FullFName += ".";
		FullFName += Ext;
	}

	return FullFName;
}

CString CNameTableRecord::PrepareDirName(CString& BaseDir)
{
	CString FullDirName;
	
	if( Ext.GetLength() > 0 )
		FullDirName.Format("%s\\%s.%s", BaseDir, Dir, Ext);
	else
		FullDirName.Format("%s\\%s", BaseDir, Dir);

	return FullDirName;
}

CString CNameTableRecord::PrepareStorageName(int suffix)
{
	if( HasSuffix )
	{
		CString StorName;
		StorName.Format("%s%i", StorageName, suffix);
		return StorName;
	}
	else
		return StorageName;
}

