
#include <sys/stat.h>
#include <direct.h>

#include "CommonFunctions.h"
#include "Task.h"

extern CTaskParameters TaskParameters;


bool FileExist(LPCSTR FName)
{
	struct _stat stat;
	if( _stat(FName, &stat) == -1 ) return false;
	if( (stat.st_mode & _S_IFREG) != 0 ) return true;
	//FName - is directory. What we have to do?
	return false;
}

long GetFileSize(LPCSTR FileName)
{
	struct _stat stat;
	_stat(FileName, &stat);
	return stat.st_size;
}

bool DirectoryExist(LPCSTR DirName)
{
	struct _stat stat;
	if( _stat(DirName, &stat) == -1 ) return false;
	if( (stat.st_mode & _S_IFDIR) != 0 ) return true;
	//DirName - is ordinary file. What we have to do?
	return false;
}

bool CreateDirectory(LPCTSTR DirName)
{
	char dir[MAX_PATH];
	char *start_ptr, *end_ptr;

	strcpy(dir, DirName);
	start_ptr = end_ptr = dir;

	while( end_ptr != NULL )
	{
		end_ptr = strchr(start_ptr, '\\');
		if( end_ptr != NULL )
		{
			*end_ptr = '\0';
		}
		if( (strcmp(start_ptr, ".") != 0) && (strcmp(start_ptr, "..") != 0) )
		{
			if( !DirectoryExist(dir) )
			{
				if( _mkdir(dir) != 0 )
				{
					Msg(0, "Can not create directory '%s' - %s\n", dir, strerror(errno));
					exit(1);
				}
			}
		}
		if( end_ptr != NULL )
		{
			*end_ptr = '\\';
			end_ptr++;
			start_ptr = end_ptr;
		}
	}
	return true;
}

CStringArray* SplitPath(CString& Path)
{
	CStringArray *parts = new CStringArray;
	int pos = 0, prev_pos = 0;
	bool HasSubdirs = false;
	while( (pos = Path.Find("\\", pos)) != -1 )
	{
		HasSubdirs = true;
		CString mid = Path.Mid(prev_pos, pos-prev_pos);
		parts->Add(mid);
		pos++;
		prev_pos = pos;
	}

	if( !HasSubdirs )
		parts->Add(Path);
	else
		parts->Add(Path.Mid(prev_pos));

	return parts;
}


CString Suffix(CString& str)
{
	int pos = str.Find('.');
	if( pos < 0 ) return "";
	return str.Mid(pos+1);
}


void SystemErrorMessage()
{
	char *ErrMsg = NULL;
	FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM, 
		NULL, 
		GetLastError(), 
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), 
		ErrMsg, 
		0, NULL);
	printf(ErrMsg);
	fflush(stdout);
	LocalFree(ErrMsg);
}

void Msg(int MinimalVerbosityLevel, char *msg, ...)
{
	if( MinimalVerbosityLevel <= TaskParameters.Verbose )
	{
		CString ConvertedMsg;
		va_list ap;
		va_start(ap, msg);
		ConvertedMsg.FormatV(msg, ap);
		va_end(ap);

		ConvertedMsg.AnsiToOem();

		printf((LPCSTR)ConvertedMsg);
		fflush(stdout);
	}
}
