
#include <ctype.h>
#include "Container.h"

typedef struct
{
	LPCSTR FileName;
	CContainerInfo Info;
} CFileInfo;

static CFileInfo FileInfo[] = {
	{"Dialog Stream", {"DialogEditor", "Dialog Form"}},
	{"MD Programm text", {"TextDocument", "Module text"}},
	{"Page.", {"Moxcel.Worksheet", "Moxel WorkPlace"}},
	{"Gallery", {"PictureGalleryContainer", "Gallery"}},
	{"Main MetaData Stream", {"MetaDataStream", "Main MetaData Stream"}},
	{"GUIDData", {"GuidHistoryContainer", "GUIDData"}},
	{"TagStream", {"TagStream", "TagStream"}},
	{NULL, {NULL, NULL}}
};


static CMapStringToPtr DirNameMap;
static CMapStringToPtr FileNameMap;
static bool MapsInitialized = false;


CContainer::CContainer()
{
	Content = "{\"Container.Contents\"";

	if( MapsInitialized ) return;

	DirNameMap.SetAt("Metadata",         "MetaDataContainer");
	DirNameMap.SetAt("Subconto",         "SubcontoContainer");
	DirNameMap.SetAt("SubList",          "SublistContainer");
	DirNameMap.SetAt("SubFolder",        "SubcontoGroupFolder");
	DirNameMap.SetAt("Document",         "DocumentContainer");
	DirNameMap.SetAt("Journal",          "JournalContainer");
	DirNameMap.SetAt("Report",           "ReportContainer");
	DirNameMap.SetAt("TypedText",        "TypedTextContainer");
	DirNameMap.SetAt("UserDef",          "UserDefContainer");
	DirNameMap.SetAt("Picture",          "PictureContainer");
	DirNameMap.SetAt("CalcJournal",      "CalcJournalContainer");
	DirNameMap.SetAt("CalcVar",          "CalcVarContainer");
	DirNameMap.SetAt("AccountChart",     "AccountChartContainer");
	DirNameMap.SetAt("AccountChartList", "AccountChartListContainer");
	DirNameMap.SetAt("OperationList",    "OperationListContainer");
	DirNameMap.SetAt("Operation",        "OperationContainer");
	DirNameMap.SetAt("GlobalData",       "GlobalDataContainer");
	DirNameMap.SetAt("ProvList",         "ProvListContainer");
	DirNameMap.SetAt("WorkBook",         "WorkBookContainer");

	DirNameMap.SetAt("ModuleText_Number1", "ModuleContainer");
	DirNameMap.SetAt("Transact_Number",    "ModuleContainer");
	DirNameMap.SetAt("UserHelp_Number",    "ModuleContainer");

	int i;
	for( i = 0; FileInfo[i].FileName != NULL; i++ )
	{
		FileNameMap.SetAt(FileInfo[i].FileName, (CObject*) &(FileInfo[i].Info));
	}

	MapsInitialized = true;
}


LPSTR RemoveLastDigits(LPSTR Str)
{
	int len = strlen(Str);
	char* NewStr = new char[len+1];
	memcpy(NewStr, Str, len+1);

	LPSTR pos;
	pos = NewStr + len - 1;
	while( isdigit(*pos) ) *pos-- = '\0';
	return NewStr;
}


void CContainer::Add(LPCSTR Type, LPCSTR Name, LPCSTR Descr)
{
	Content += ",{\"";
	Content += Type;
	Content += "\",\"";
	Content += Name;
	Content += "\",\"";
	Content += Descr;
	Content += "\",\"\"}";
}

void CContainer::AddDir(LPSTR DirName)
{
	LPSTR CleanName = RemoveLastDigits(DirName);
	LPSTR Type;

	if( !DirNameMap.Lookup(CleanName, (void*&)Type) )
		Type = "TypedObjectContainer";

	Add(Type, DirName, DirName);

	delete[] CleanName;
}

void CContainer::AddDir(const wchar_t* wDirName)
{
	char* DirName = new char[wcslen(wDirName)+1];
	sprintf(DirName, "%S", wDirName);
	AddDir(DirName);
	delete[] DirName;
}

void CContainer::AddFile(LPSTR FileName)
{
	LPSTR CleanName = RemoveLastDigits(FileName);
	CContainerInfo *Info;

	if( !FileNameMap.Lookup(CleanName, (void*&)Info) ) return;

	Add(Info->Type, FileName, Info->Descr);

	delete[] CleanName;
}

void CContainer::AddFile(const wchar_t* wFileName)
{
	char* FileName = new char[wcslen(wFileName)+1];
	sprintf(FileName, "%S", wFileName);
	AddFile(FileName);
	delete[] FileName;
}

CString& CContainer::Create(LPCSTR DirName)
{
	WIN32_FIND_DATA Finder;
	HANDLE hFind;

	Content = "{\"Container.Contents\"";

	hFind = FindFirstFile(DirName, &Finder);
	do
	{
		if (0 == strcmp(Finder.cFileName, ".")   ) continue;
		if (0 == strcmp(Finder.cFileName, "..")  ) continue;
		if (0 == strcmp(Finder.cFileName, "CVS") ) continue;

		if( (Finder.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) != 0 )
		{
			AddDir(Finder.cFileName);
		}
		else
		{
			AddFile(Finder.cFileName);
		}
	} while( FindNextFile(hFind, &Finder) );
	FindClose(hFind);

	Content += "}";
	return Content;
}

CString& CContainer::Create(CStorage& Storage, bool Recursive)
{
	IEnumSTATSTG *ppenum;
	STATSTG stat;
	unsigned long uCount;

	Content = "{\"Container.Contents\"";

	Storage.GetStorage()->EnumElements(0, NULL, 0, &ppenum);
	while ( S_OK == ppenum->Next(1, &stat, &uCount) )
	{
		if( (stat.type & STGTY_STORAGE ) != 0 )
		{
			AddDir(stat.pwcsName);
			if( Recursive )
			{
				Storage.Open(stat.pwcsName);
				CContainer SubContainer;
				SubContainer.Create(Storage, Recursive);
				Storage.Close();
			}
		}
		else
		{
			AddFile(stat.pwcsName);
		}
	}
	ppenum->Release();

	Content += "}\n";

	if( !Storage.StreamExist(CString("Container.Contents")) )
	{
		Storage.StreamFromString("Container.Contents", Content);
	}

	return Content;
}


bool CCGenerationPossible(LPCSTR DirName)
{
	if( 0 == strcmp(DirName, "UserDef") ) return false;
	if( 0 == strcmp(DirName, "TypedText") ) return false;
	return true;
}