
#ifndef STORAGE_H
#define STORAGE_H

#include <afx.h>
#include <afxtempl.h>
#include <ole2.h>   //IStream, IStorage
#include <stdio.h>
#include "StreamInfo.h"
#include "MMS.h"


class CStorage
{
protected:
	CList<IStorage*, IStorage*&> Storages;
	bool ReleaseRootStorage;
public:
	IStream* pStream;
	CString StreamName;
	CStreamInfo StreamInfo;

public:
	CStorage();
	CStorage(CString& CompoundName);
	CStorage(IStorage* pStorage);
	CStorage(CStorage& Storage);
	//       ,   SubStorage
	//     -     
	CStorage(CStorage& Storage, CString SubStorage);
	~CStorage();

public:
	CString FullPath();

	bool Open(CStringArray* StorageName);
	bool Open(CString& StorageName);
	inline bool Open(LPCSTR StorageName) {return Open(CString(StorageName));};
	bool Open(const wchar_t* StorageName);
	bool Create(CStringArray* StorageName);
	bool Create(CString& StorageName);
	bool Delete(CString& StorageName);
	void Close();
	
	bool OpenStream(CString& StreamName);
	bool CreateStream(CString& StreamName);
	void CloseStream();

	bool StorageExist(CString& StorageName);
	bool StreamExist(CString& StreamName);
	long GetStreamSize(CString& StreamName);

	void Rewind();

	void GetCleanStream();
	bool CopyToFile(FILE* File);
	bool CopyToFile(CString& FileName, bool ForceCopy = false);
	bool CopyToFile(CString& StreamName, CString& FileName, bool ForceCopy = false);
	bool Extract(CString& DestDir, bool WithContainerContents = true);
	bool StreamFromFile(CString& StreamName, CString& FileName);
	void AddZeroByte();
	bool StreamFromString(CString StreamName, CString& String);
	bool FromFile(CString& FileName);
	bool FromFile(FILE* File, LPCSTR FileName = NULL);
	bool StorageFromDir(CString& StorageName, CString& SrcDir);
	bool operator== (FILE* File);
	bool operator== (CString& FileName);

	IStorage* GetStorage();

	CMMSObject* ParseStream(CString& StreamName);

private:
	void WriteSizeToStream(IStream* pStream);
};



LPCSTR GetStgErrorString(HRESULT err);

ULARGE_INTEGER GetStreamSize(IStream* pStream);

IStorage* OpenCompound(CString& CompoundFileName);

IStorage* OpenStorage(IStorage* pParentStorage, wchar_t* wStorName);
IStorage* OpenStorage(IStorage* pParentStorage, CString& StorName);

IStream* OpenStream(IStorage* pParentStorage, wchar_t* wStreamName);
IStream* OpenStream(IStorage* pParentStorage, CString& StreamName);

bool StringDifferFromFile(CString& String, CString& FileName);
bool CopyStringToFile(CString& String, CString& FileName);

//      
void AddToExtractedList(CString& FullFName);
void CheckPrune(CString& FullFName);

#endif