
#include <io.h>
#include "StreamInfo.h"
#include "CommonFunctions.h"

void CStreamInfo::Reset()
{
	Packed = false;
	MainMetadataStream = false;
	HaveSize = false;
	SizeOffset = 0;
	SizeBytes = 0;
	ContentOffset = 0;
	FullSize = 0;
	Size = 0;
}

CStreamInfo::CStreamInfo()
{
	Reset();
}

void CStreamInfo::UpdateInfo(LPCSTR StreamName)
{
	Reset();

	if( 0 == stricmp("MD Programm text", StreamName) ) Packed = true;
	else if( 0 == stricmp("Inplace description", StreamName) ) Packed = true;

	if( 0 == stricmp("Dialog Stream", StreamName) ) HaveSize = true;
	else if( 0 == stricmp("Main MetaData Stream", StreamName) ) 
	{
		HaveSize = true;
		MainMetadataStream = true;
	}
}

void CStreamInfo::DetermineSizeFormat(unsigned long FullSize)
{
	if( !HaveSize ) return;

	if( FullSize == 0 )
	{
		SizeOffset = 0;
		SizeBytes = 1;
		Size = 0;
	}
	else
	{
		if( (FullSize-1) <= 0xFF )
		{
			SizeOffset = 0;
			SizeBytes = 1;
		}
		else if( (FullSize-3) <= 0xFFFF )
		{
			SizeOffset = 1;
			SizeBytes = 2;
		}
		else
		{
			SizeOffset = 3;
			SizeBytes = 4;
		}
	}

	ContentOffset = SizeOffset + SizeBytes;
}

void CStreamInfo::DetermineFileSizeFormat(unsigned long FullSize)
{
	if( !HaveSize ) return;

	if( FullSize == 0 )
	{
		SizeOffset = 0;
		SizeBytes = 1;
		Size = 0;
	}
	else
	{
		if( (FullSize+1) <= 0xFF )
		{
			SizeOffset = 0;
			SizeBytes = 1;
		}
		else if( (FullSize+3) <= 0xFFFF )
		{
			SizeOffset = 1;
			SizeBytes = 2;
		}
		else
		{
			SizeOffset = 3;
			SizeBytes = 4;
		}
	}

	ContentOffset = SizeOffset + SizeBytes;
}


unsigned long CStreamInfo::ReadSize(IStream* pStream)
{
	LARGE_INTEGER Offset = {0, 0};
	ULARGE_INTEGER EndPos = {0, 0};

	Offset.LowPart = 0;
	pStream->Seek(Offset, STREAM_SEEK_END, &EndPos);
	FullSize = EndPos.LowPart;
	pStream->Seek(Offset, STREAM_SEEK_SET, NULL);

	SizeOffset = 0;
	SizeBytes = 0;
	ContentOffset = 0;
	if( Packed ) HaveSize = false;

	if( HaveSize )
	{
		DetermineSizeFormat(FullSize);
		if( FullSize > 0 )
		{
			Offset.LowPart = SizeOffset;
			pStream->Seek(Offset, STREAM_SEEK_SET, NULL);
			switch( SizeBytes )
			{
				case 1:
					BYTE bSize;
					pStream->Read(&bSize, SizeBytes, NULL);
					Size = bSize;
					break;
				case 2:
					WORD wSize;
					pStream->Read(&wSize, SizeBytes, NULL);
					Size = wSize;
					break;
				case 4:
					DWORD dwSize;
					pStream->Read(&dwSize, SizeBytes, NULL);
					Size = dwSize;
					break;
				default:
					STATSTG StatSgts;
					pStream->Stat(&StatSgts, STATFLAG_DEFAULT);
					Msg(0, "ERR: Don't know how to read size of stream '%S' (%i bytes)\n", StatSgts.pwcsName, (int)SizeBytes);
					exit(1);
					break;
			}
		}
	}
	else
	{
		Size = FullSize;
		ContentOffset = 0;
	}

	//   
	Offset.LowPart = 0;
	pStream->Seek(Offset, STREAM_SEEK_SET, NULL);

	return Size;
}

unsigned long CStreamInfo::ReadFileSize(FILE* File)
{
	SizeOffset = 0;
	SizeBytes = 0;
	ContentOffset = 0;

	fseek(File, 0, SEEK_END);
	FullSize = ftell(File);
	fseek(File, 0, SEEK_SET);

	Size = FullSize;

	DetermineFileSizeFormat(FullSize);
	ContentOffset = SizeOffset + SizeBytes;

	return Size;
}


