
#include "MMS.h"
#include "NameTable.h"
#include "Task.h"
#include "Storage.h"
#include "CommonFunctions.h"
#include "Ordering.h"


///////////////////////////////////////////////////////////////////////
///////////  class CMMSObject methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSObject::ExtractString(CString& Str, CString& DestDir, MMSObjectType Type)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CopyStringToFile(Str, nt_rec->PrepareFileName(DestDir));
}

void CMMSObject::ExtractMetadata(CString& DestDir, MMSObjectType Type)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString Content = AsString();

	if( nt_rec->Dir.GetLength() > 0 ) CreateDirectory(nt_rec->PrepareDirName(DestDir));
	
	CString FName = nt_rec->PrepareFileName(DestDir, this);
	CopyStringToFile(Content, FName);
}

void CMMSObject::ExtractMetadata(CString& DestDir)
{
	ExtractMetadata(DestDir, NT_MetadataPart);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSObjectWithProps methods  ///////////////////////
///////////////////////////////////////////////////////////////////////

//     '_'.     
int MangleFileName(CString str)
{
	char* ptr = (char*)(LPCSTR)str;
	int repl_count = 0;
	while( *ptr != '\0' )
	{
		int c = (unsigned char)(*ptr); //unsigned -    
		if( !__iscsym(c) ) { *ptr = '_'; repl_count++; };
		ptr++;
	}
	return repl_count;
}

void CMMSObjectWithProps::ExtractMoxelPages(CString& DestDir, CStorage& WBStorage)
{
	CNameTableRecord* nt_rec_mxl = NameTable.Find(NT_MoxelSheet);
	CMMSNodeList* WBContent = NULL;

	WBContent = (CMMSNodeList*)WBStorage.ParseStream(CString("Container.Contents"));
	if( WBContent == NULL ) return; // 

	//Analyze Container.Contents and extract moxel pages if any.
	CString std_tab_name("Moxel WorkPlace");
	CString ID_mxl("Moxcel.Worksheet");
	CString mxlFName;
	CObjectOrdering Order(3);
	//Order.FormatString = "%s.%s.%s\t%s\r\n";
	
	POSITION pos = WBContent->GetHeadPosition();
	while( pos != NULL )
	{
		CMMSObject* SubNode = WBContent->GetNext(pos);
		if( SubNode->sID == ID_mxl )
		{
			CMMSObject* pMXL = SubNode->GetPropByNum(1);
			CString tab_name = (LPCSTR)pMXL->sID;
			CString page_suffix = Suffix(SubNode->GetPropByNum(0)->sID);
			if( tab_name == std_tab_name )
				tab_name = "";
			else
			{
				if( MangleFileName(tab_name) > 0 )
					Msg(2, "MXL %s replaced by %s\n", pMXL->sID, tab_name);
			}

			mxlFName.Format("%s.%s.%s", tab_name, page_suffix, nt_rec_mxl->Ext);

			if( TaskParameters.NoEmptyMxl ) //  
			{
				long size = WBStorage.GetStreamSize(SubNode->GetPropByNum(0)->sID);
				if( size == 147 || size == 139 ) continue;
			}

			WBStorage.CopyToFile(SubNode->GetPropByNum(0)->sID, DestDir+"\\"+mxlFName);
			
			Order.Add(page_suffix, mxlFName, Translit(mxlFName), pMXL->sID);
		}
	}

	if( Order.Order.GetLength() > 0 ) Order.WriteFile(DestDir);

	delete WBContent;
}

void CMMSObjectWithProps::ExtractWorkBook(CString& DestDir, CStorage& Storage)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_Workbook);
	bool opened;

	if( TaskParameters.CompoundType == CTaskParameters::external_report )
		opened = true; //    WorkBook,     
	else
		opened = Storage.Open(nt_rec->StorageName);

	if( opened )
	{
		// 
		ExtractStreamByType(Storage, NT_FormModule, DestDir);
		// 
		ExtractStreamByType(Storage, NT_DialogForm, DestDir);

		// 
		ExtractMoxelPages(DestDir, Storage);

		if( TaskParameters.CompoundType != CTaskParameters::external_report )
			Storage.Close();
	}
}

void CMMSObjectWithProps::ExtractDescription(CString& DestDir, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_UserHelpStor);
	if( TypedTextStorage.Open(nt_rec->PrepareStorageName(ID)) )
	{
		ExtractStreamByType(TypedTextStorage, NT_UserHelp, DestDir);
		TypedTextStorage.Close();
	}
}

void CMMSObjectWithProps::ExtractListForms(CMMSObject* Forms, CString& Dir, 
										   CStorage& Storage, CString Prefix)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_ListForm);
	CString StorName;

	for( int i = 0; i < Forms->GetNProps(); i++ )
	{
		CMMSObject* Form = Forms->GetPropByNum(i);
		CString FormDir;
		FormDir.Format("%s\\%s.%s", Dir, Form->GetPropByNum(0)->sID, nt_rec->Ext);
		CreateDirectory(FormDir);
		
		StorName.Format("%s%i", Prefix, Form->ID);
		if( Storage.Open(StorName) )
		{
			ExtractWorkBook(FormDir, Storage);
			Storage.Close();
		}
	}
}

void CMMSObjectWithProps::ExtractStreamByType(CStorage& Storage, MMSObjectType Type, CString& Dir)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage SubStorage(Storage);
	SubStorage.CopyToFile(nt_rec->PrepareStorageName(ID), nt_rec->PrepareFileName(Dir));
}

void CMMSObjectWithProps::ExtractOrdering(CString& DestDir)
{
	int nProps = GetNProps();
	if( nProps == 0 ) return;

	CObjectOrdering Order(2);

	for( int i = 0; i < nProps; i++ )
	{
		CMMSObject* obj = GetPropByNum(i);
		Order.Add(obj->ID, obj->sID, Translit(obj->sID));
	}

	Order.WriteFile(DestDir);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSBasicObject methods  ///////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSBasicObject::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMS methods  //////////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMS::ExtractStorage(CString& Dir, CStorage& Storage, MMSObjectType Type, bool WithContainerCOntents)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString DestDir = nt_rec->PrepareDirName(Dir);
	CStorage SrcStorage(Storage);

	if( SrcStorage.Open(nt_rec->PrepareStorageName(ID)) )
	{
		CreateDirectory(DestDir);
		if( !SrcStorage.Extract(DestDir, WithContainerCOntents) ) remove(DestDir);
	}
}

void CMMS::ExtractCommonMXL(CString& Dir, CStorage& Storage)
{
	CNameTableRecord* nt_rec_gd = NameTable.Find(NT_GlobalData);
	CNameTableRecord* nt_rec = NameTable.Find(NT_CommonMXL);
	CString GDDir = nt_rec->PrepareDirName(Dir);
	
	CString StorName = nt_rec_gd->StorageName;
	StorName += "\\";
	StorName += nt_rec->StorageName;
	
	CreateDirectory(GDDir);
	CStorage GDStorage(Storage);
	if( GDStorage.Open(StorName) )
	{
		ExtractWorkBook(GDDir, GDStorage);
	}
}


CString PropertyPath(CMMSNodeList& PropPath)
{
	CString Path;
	bool add_dot = false;

	POSITION pos = PropPath.GetHeadPosition();
	while( pos != NULL )
	{
		CMMSObject* obj = PropPath.GetNext(pos);
		
		CString sID;
		if( obj->ID == 0 )
			sID = obj->sID; //    ,    
		else if( obj->ID == atoi(obj->sID) )
			if( obj->GetPropByNum(0) != NULL )
				sID = obj->GetPropByNum(0)->sID; // 
			else
				sID = obj->sID;
		else
			sID = obj->sID;

		//  .      sID .
		char* ptr = (char*)(LPCSTR)sID;
		while( *ptr != '\0' )
		{
			int c = (unsigned char)(*ptr); //unsigned -    
			if( isspace(c) )
				*ptr = '_';
			else if( !__iscsym(c) )
			{
				sID = obj->sID;
				break;
			}
			ptr++;
		}

		if( add_dot ) Path += ".";
		Path += sID;
		add_dot = true;
	}

	return Path;
}

void CMMS::ExtractDescriptions(CString& Dir, CStorage& Storage)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_UserHelpStor);
	CNameTableRecord* nt_rec_file = NameTable.Find(NT_UserHelp);
	int prefix_sz = nt_rec->StorageName.GetLength();
	CString StorName, FileName;
	CString DescrDir;
	CObjectOrdering Order(2);

	DescrDir.Format("%s\\%s", Dir, nt_rec->Dir);
	CreateDirectory(DescrDir);

	Storage.Open("TypedText");
	IEnumSTATSTG *ppenum;
	STATSTG stat;
	unsigned long uCount;
	Storage.GetStorage()->EnumElements(0, NULL, 0, &ppenum);
	while ( S_OK == ppenum->Next(1, &stat, &uCount) )
	{
		if( (stat.type & STGTY_STORAGE ) != 0 )
		{
			StorName.Format("%S", stat.pwcsName);
			if( StorName.Left(prefix_sz) != nt_rec->StorageName ) continue;
			int ID = atoi(StorName.Mid(prefix_sz));

			CMMSNodeList PropPath;
			PropPath.DestroyObjects = false;
			CMMSObject* obj = GetProperty(ID, true, &PropPath);
			
			if( obj == NULL ) continue;
			if( obj->Type == MMS_SbCnt ) continue;
			if( obj->Type == MMS_Document ) continue;
			if( obj->Type == MMS_Report ) continue;
			if( obj->Type == MMS_CalcJournal ) continue;
			if( obj->Type == MMS_CalcAlgorithm ) continue;

			Storage.Open(StorName);
			
			CString ObjFullName = PropertyPath(PropPath);
			ObjFullName += ".";
			ObjFullName += nt_rec_file->Ext;

			FileName.Format("%s\\%s", DescrDir, Translit(ObjFullName));
			Storage.CopyToFile(nt_rec_file->StorageName, FileName);
			Storage.Close();

			Order.Add(obj->ID, ObjFullName, Translit(ObjFullName));
		}
	}
	ppenum->Release();

	Storage.Close();
	Order.WriteFile(DescrDir);
}

void CMMS::DeleteUnusedObjects(CStorage& Storage)
{
	int i;

	for( i = 0; i < GetNProps(); i++ )
		GetPropByNum(i)->Used = true;


	CMMSObject* frm = Storage.ParseStream(NameTable.Find(NT_DialogForm)->PrepareStorageName(0));
	CMMSObject* Controls = frm->GetProperty((CString("Controls")));
	for( i = 0; i < Controls->GetNProps(); i++ )
	{
		int nProps = Controls->GetPropByNum(i)->GetNProps();
		CString& sWndClass = Controls->GetPropByNum(i)->GetPropByNum(0)->sID;
		CString sTypeLetter, sTypeID;
		if( isdigit(sWndClass[0]) ) // ,  1    ?!
		{
			sTypeLetter = Controls->GetPropByNum(i)->GetPropByNum(12)->sID;
			sTypeID = Controls->GetPropByNum(i)->GetPropByNum(15)->sID;
		}
		else
		{
			sTypeLetter = Controls->GetPropByNum(i)->GetPropByNum(13)->sID;
			sTypeID = Controls->GetPropByNum(i)->GetPropByNum(16)->sID;
		}

		int ID = atoi(sTypeID);
		if( ID != 0 ) 
			MarkUsed(ID);
	}

	for( i = 0; i < GetNProps(); i++ )
	{
		if( GetPropByNum(i)->Type == MMS_Buh ) continue;
		if( GetPropByNum(i)->Type == MMS_TaskItem ) continue;
		GetPropByNum(i)->DeleteUnused();
	}
}

void CMMS::Decompile(CString& Dir, CStorage& Storage)
{
	//       -      -
	//  
	CMMSDescr* Descr = (CMMSDescr*)GetPropByNum(0);
	Descr->MD_ver = 10009;
	// CRC
	int crc_num = FindProperty(CString("CRC"));
	if( crc_num >= 0 ) DelProperty(crc_num);

	if( TaskParameters.CompoundType == CTaskParameters::external_report	)
	{
		//DeleteUnusedObjects(Storage);
		if( TaskParameters.TruncateMMS )
			ExtractString(CString(MinimalMMS()), Dir, NT_MainMetadataStream);
		else
			ExtractMetadata(Dir);
		ExtractWorkBook(Dir, Storage);
		ExtractStreamByType(Storage, NT_ErtUserHelp, Dir);
		ExtractStorage(Dir, Storage, NT_PictureGallery, false);
		return;
	}

	int nProps = GetNProps();
	for( int i = 0; i < nProps; i++ )
	{
		GetPropByNum(i)->Decompile(Dir, Storage);
	}

	// 
	ExtractStreamByType(Storage, NT_GlobalModule, Dir);
	// 
	ExtractCommonMXL(Dir, Storage);
	//
	ExtractStorage(Dir, Storage, NT_PictureGallery, false);
	// 
	ExtractStorage(Dir, Storage, NT_UserInterface, true);
	// 
	ExtractStorage(Dir, Storage, NT_UserRights, true);

	// 
	ExtractStreamByType(Storage, NT_GUIDData, Dir);
	ExtractStreamByType(Storage, NT_TagStream, Dir);

	//
	ExtractDescriptions(Dir, Storage);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSMetadataPart methods  //////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSMetadataPart::Decompile(CString& Dir, CStorage& Storage)
{
	ExtractMetadata(Dir, Type);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSSubCnt methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSSbCnt::Decompile(CString& BaseDir, CStorage& Storage, CStorage& TypedTextStorage, CStorage& SubFolderStorage, CStorage& SubListStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage ScStorage(Storage);
	CString ScDir;
	CString StorName;

	ScDir.Format("%s\\%s", BaseDir, sID);
	InplaceTranslit(ScDir);

	CreateDirectory(ScDir);

	Msg(2, " %s\n", sID);

	//
	ExtractMetadata(ScDir);

	if( ScStorage.Open(nt_rec->PrepareStorageName(ID)) ) //    ,     
	{
		ExtractWorkBook(ScDir, ScStorage);
	}

	//
	ExtractDescription(ScDir, TypedTextStorage);

	// 
	nt_rec = NameTable.Find(NT_SubcontoFolder);
	CStorage GroupStorage(SubFolderStorage);
	if( GroupStorage.Open(nt_rec->PrepareStorageName(ID)) != NULL )
	{
		CString SubFldDir = nt_rec->PrepareDirName(ScDir);
		CreateDirectory(SubFldDir);
		ExtractWorkBook(SubFldDir, GroupStorage);
	}

	// 
	nt_rec = NameTable.Find(NT_SubcontoListForm);
	CMMSObject* ListForms = GetProperty(CString("Form"));
	ExtractListForms(ListForms, ScDir, SubListStorage, nt_rec->StorageName);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSSbCnts methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSSbCnts::Decompile(CString& BaseDir, CStorage& Storage)
{
	if( nProps == 0 ) return;

	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage ScsStorage(Storage,       nt_rec->StorageName);
	CStorage TypedTextStorage(Storage, "TypedText");
	CStorage SubFolderStorage(Storage, "SubFolder");
	CStorage SubListStorage(Storage,   "SubList");
	CString  ScsDir = nt_rec->PrepareDirName(BaseDir);

	CreateDirectory(ScsDir);

	for( int i = 0; i < nProps; i++ )
	{
		CMMSSbCnt* pSc = (CMMSSbCnt*)Properties[i];
		pSc->Decompile(ScsDir, ScsStorage, TypedTextStorage, SubFolderStorage, SubListStorage);
	}

	ExtractOrdering(ScsDir);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSGenJrnlFldDef methods  /////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSGenJrnlFldDef::Decompile(CString& Dir, CStorage& Storage)
{
	ExtractMetadata(Dir, Type);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSDocSelRefObj methods  //////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSDocSelRefObj::Decompile(CString& Dir, CStorage& Storage)
{
	ExtractMetadata(Dir, Type);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSDocNumDef methods  /////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSDocNumDef::Decompile(CString& Dir, CStorage& Storage)
{
	ExtractMetadata(Dir, Type);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSDocument methods  //////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSDocument::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage TransactStorage(TypedTextStorage);
	CString DocDir(Dir);

	DocDir += "\\";
	DocDir += sID;
	CreateDirectory(DocDir);

	ExtractMetadata(DocDir);

	if( Storage.Open(nt_rec->PrepareStorageName(ID)) ) //    ,     
	{
		ExtractWorkBook(DocDir, Storage);
		Storage.Close();
	}

	// 
	nt_rec = NameTable.Find(NT_TransModuleStor);
	if( TransactStorage.Open(nt_rec->PrepareStorageName(ID)) )
	{
		nt_rec = NameTable.Find(NT_TransactModule);
		TransactStorage.CopyToFile(nt_rec->StorageName, nt_rec->PrepareFileName(DocDir));
	}

	ExtractDescription(DocDir, TypedTextStorage);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSDocuments methods  /////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSDocuments::Decompile(CString& Dir, CStorage& Storage)
{
	if( nProps == 0 ) return;

	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage TypedTextStorage(Storage, "TypedText");
	CString DocsDir = nt_rec->PrepareDirName(Dir);

	CreateDirectory(DocsDir);

	Storage.Open(nt_rec->PrepareStorageName(ID));
	for( int i = 0; i < nProps; i++ )
	{
		CMMSDocument* pDoc = (CMMSDocument*)Properties[i];
		pDoc->Decompile(DocsDir, Storage, TypedTextStorage);
	}
	Storage.Close();

	ExtractOrdering(DocsDir);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSReport methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSReport::Decompile(CString& Dir, CStorage& Storage, CString& Prefix, CStorage& TypedTextStorage)
{
	CString RptDir(Dir);
	CString StorName;

	RptDir += "\\";
	RptDir += sID;
	CreateDirectory(RptDir);

	ExtractMetadata(RptDir);
	
	StorName.Format("%s%i", Prefix, ID);
	if( Storage.Open(StorName) )
	{
		ExtractWorkBook(RptDir, Storage);
		Storage.Close();
	}

	ExtractDescription(RptDir, TypedTextStorage);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSReportList methods  /////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSReportList::Decompile(CString& Dir, CStorage& Storage)
{
	if( nProps == 0 ) return;

	CNameTableRecord* nt_rec = NameTable.Find(sID);
	CStorage TypedTextStorage(Storage, "TypedText");
	CString ReportsDir = nt_rec->PrepareDirName(Dir);

	CreateDirectory(ReportsDir);

	if( Storage.Open(nt_rec->StorageName) )
	{
		CString ReportStorName = nt_rec->StorageName + "_Number";
		for( int i = 0; i < nProps; i++ )
		{
			CMMSReport* rpt = (CMMSReport*)Properties[i];
			rpt->Decompile(ReportsDir, Storage, ReportStorName, TypedTextStorage);
		}
		Storage.Close();
	}

	ExtractOrdering(ReportsDir);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSJournalister methods  //////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSJournalister::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString JournalDir = Dir;
	CMMSObject* Forms = GetProperty(CString("Form"));

	JournalDir += "\\";
	JournalDir += sID;
	CreateDirectory(JournalDir);

	ExtractMetadata(JournalDir);
	ExtractDescription(JournalDir, TypedTextStorage);

	ExtractListForms(Forms, JournalDir, Storage, nt_rec->StorageName);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSJournalisters methods  /////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSJournalisters::Decompile(CString& SrcDir, CStorage& Storage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage TypedTextStorage(Storage, "TypedText");
	CString JournalsDir = nt_rec->PrepareDirName(SrcDir);

	CreateDirectory(JournalsDir);

	Storage.Open(nt_rec->StorageName);
	for( int i = 0; i < nProps; i++ )
	{
		CMMSJournalister* pJournal = (CMMSJournalister*)Properties[i];
		pJournal->Decompile(JournalsDir, Storage, TypedTextStorage);
	}
	Storage.Close();

	ExtractOrdering(JournalsDir);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSCalcJournal methods  ///////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCalcJournal::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString JournalDir(Dir);
	CMMSObject* Forms = GetProperty(CString("Form"));

	JournalDir += "\\";
	JournalDir += sID;
	CreateDirectory(JournalDir);

	ExtractMetadata(JournalDir);
	ExtractDescription(JournalDir, TypedTextStorage);
	ExtractListForms(Forms, JournalDir, Storage, nt_rec->StorageName);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSCalcJournals methods  //////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCalcJournals::Decompile(CString& Dir, CStorage& Storage)
{
	if( nProps == 0 ) return;

	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString JournalsDir = nt_rec->PrepareDirName(Dir);
	CStorage TypedTextStorage(Storage, "TypedText");

	CreateDirectory(JournalsDir);

	Storage.Open(nt_rec->StorageName);
	for( int i = 0; i < nProps; i++ )
	{
		CMMSCalcJournal* pJournal = (CMMSCalcJournal*)Properties[i];
		pJournal->Decompile(JournalsDir, Storage, TypedTextStorage);
	}
	Storage.Close();

	ExtractOrdering(JournalsDir);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSCaclAlgorithm methods  /////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCaclAlgorithm::Decompile(CString& Dir, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec_stor = NameTable.Find(Type);
	CString AlgDir(Dir);

	AlgDir += "\\";
	AlgDir += sID;
	CreateDirectory(AlgDir);

	ExtractMetadata(AlgDir);

	if( TypedTextStorage.Open(nt_rec_stor->PrepareStorageName(ID)) )
	{
		CNameTableRecord* nt_rec = NameTable.Find(NT_CalcAlgorithm);
		TypedTextStorage.CopyToFile(nt_rec->StorageName, nt_rec->PrepareFileName(AlgDir));
		TypedTextStorage.Close();
	}

	ExtractDescription(AlgDir, TypedTextStorage);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSCaclAlgorithms methods  ////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCaclAlgorithms::Decompile(CString& Dir, CStorage& Storage)
{
	if( nProps == 0 ) return;


	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString AlgsDir = nt_rec->PrepareDirName(Dir);

	CreateDirectory(AlgsDir);

	if( Storage.Open(nt_rec->StorageName) )
	{
		for( int i = 0; i < nProps; i++ )
		{
			CMMSCaclAlgorithm* pAlg = (CMMSCaclAlgorithm*)Properties[i];
			pAlg->Decompile(AlgsDir, Storage);
		}
		Storage.Close();
	}

	ExtractOrdering(AlgsDir);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSBuh methods  ///////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSBuh::ExtractForm(CString& Dir, CStorage& Storage, 
						  MMSObjectType StorType, MMSObjectType Type)
{
	CNameTableRecord* nt_rec_stor = NameTable.Find(StorType);
	if( Storage.Open(nt_rec_stor->PrepareStorageName(BuhID)) )
	{
		CNameTableRecord* nt_rec = NameTable.Find(Type);
		if( Storage.Open(nt_rec->PrepareStorageName(BuhID)) )
		{
			CString DestDir;

			DestDir = nt_rec->PrepareDirName( nt_rec_stor->PrepareDirName(Dir) );
			CreateDirectory(DestDir);

			ExtractWorkBook(DestDir, Storage);

			Storage.Close();
		}
		Storage.Close();
	}
}

void CMMSBuh::ExtractListForm(CString& Dir, CStorage& Storage, MMSObjectType Type, CMMSObject* ListForms)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString DestDir = nt_rec->PrepareDirName(Dir);
	CStorage ListStor(Storage, nt_rec->StorageName);
	CreateDirectory(DestDir);
	ExtractListForms(ListForms, DestDir, ListStor, nt_rec->StorageName+"_Number");

	ListForms->ExtractMetadata(Dir, Type);
}

void CMMSBuh::Decompile(CString& Dir, CStorage& Storage)
{
	if( GetNProps() == 0 ) return;

	CNameTableRecord* nt_rec;
	CNameTableRecord* nt_rec_buh = NameTable.Find(MMS_Buh);
	CString BuhDir = nt_rec_buh->PrepareDirName(Dir);
	
	InplaceTranslit(BuhDir);
	CreateDirectory(BuhDir);

	// 
	ExtractForm(BuhDir, Storage, NT_AccFormStor, NT_AccForm);
	// 
	ExtractForm(BuhDir, Storage, NT_OperFormStor, NT_OperForm);

	//  
	ExtractListForm(BuhDir, Storage, NT_AccListForm, AccListForms);
	// 
	ExtractListForm(BuhDir, Storage, NT_ProvListForm, ProvListForms);
	// 
	ExtractListForm(BuhDir, Storage, NT_OperListForm, OperListForms);
	//  .       . , -  .
	UnknownListForms->ExtractMetadata(BuhDir, NT_UnknownListForm);

	CString BuhParams;
	BuhParams.Format("\"%i\"", ID);

	int state = 0;
	for( int i = 0; i < GetNProps(); i++ )
	{
		CMMSObject* obj = (CMMSObject*)GetPropByNum(i);
		if( (obj->Type == MMS_Property) || (obj->Type == MMS_Object) )
		{
			if( state == 0 )
			{
				if( BuhParams.GetLength() > 1 ) BuhParams += ",\r\n";
				BuhParams += obj->AsString();
			}
			continue;
		}
		else
		{
			state = 1;
		}

		CMMSObjectWithProps* prop = (CMMSObjectWithProps*)obj;

		if( prop->Type == MMS_Plans )
		{
			prop->Decompile(BuhDir, Storage);
			continue;
		}

		nt_rec = NameTable.Find(prop->Type);
		if( nt_rec == NULL ) continue;
		if( nt_rec->FileName.GetLength() == 0 ) continue;

		prop->ExtractMetadata(BuhDir, prop->Type);
	}

	CopyStringToFile(BuhParams, nt_rec_buh->PrepareFileName(Dir));
}

void CMMSAccountPlans::Decompile(CString& Dir, CStorage& Storage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString PlansDir = nt_rec->PrepareDirName(Dir, this);
	CString TranslitPlansDir = Translit(PlansDir);

	CObjectOrdering Order(2);
	for( int i = 0; i < GetNProps(); i++ )
	{
		CMMSAccountPlan* Plan = (CMMSAccountPlan*)GetPropByNum(i);
		Plan->Decompile(TranslitPlansDir, Storage, Order);
	}

	Order.WriteFile(TranslitPlansDir);
}

void CMMSAccountPlan::Decompile(CString& Dir, CStorage& Storage, CObjectOrdering& Order)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString PlanDir = nt_rec->PrepareDirName(CString(), this);
	CString TranslitPlanDir = Translit(PlanDir);

	Order.Add(ID, PlanDir, TranslitPlanDir);

	PlanDir = nt_rec->PrepareDirName(Dir, this);
	TranslitPlanDir = Translit(PlanDir);
	CreateDirectory(PlanDir);

	CNameTableRecord* nt_rec_mdp = NameTable.Find(NT_MetadataPart);
	CString FName = nt_rec_mdp->PrepareFileName(PlanDir, this);
	CopyStringToFile(HdrAsString(), FName);

	CObjectOrdering AccountsOrder(2);
	for( int i = 0; i < Accounts->GetNProps(); i++ )
	{
		CMMSAccount* Account = (CMMSAccount*)Accounts->GetPropByNum(i);
		Account->Decompile(TranslitPlanDir, Storage, AccountsOrder);
	}

	AccountsOrder.WriteFile(TranslitPlanDir);
}

void CMMSAccount::Decompile(CString& Dir, CStorage& Storage, CObjectOrdering& Order)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString FName = nt_rec->PrepareFileName(CString(), this);

	FName.Replace("%Code%", Code);

	Order.Add(ID, FName, Translit(FName));

	CopyStringToFile(AsString(-1), Dir+"\\"+FName);
}