
#ifndef NAME_TABLE_H
#define NAME_TABLE_H

#include "Declarations.h"

class CNameTableRecord
{
public:
	MMSObjectType Type;
	CString sID;
	CString StorageName;
	bool HasSuffix;
	CString Dir;
	CString FileName;
	CString Ext;

public:
	CString PrepareFileName(CString& Dir, CMMSObject* object = NULL);
	CString PrepareDirName(CString& Dir, CMMSObject* object = NULL);
	CString PrepareStorageName(int suffix = 0);
};

class CNameTable
{
private:
	CArray<CNameTableRecord*, CNameTableRecord*&> NameTable;
	int nRecords;

public:
	CNameTable() {};
	void RusConstructor();
	void EngConstructor();

	void AddRecord(MMSObjectType Type, LPCSTR sID, 
		LPCSTR StorageName, bool HasSuffix, 
		LPCSTR Dir, LPCSTR FileName = NULL, LPCSTR Ext = NULL);
	
	CNameTableRecord* Find(MMSObjectType Type);
	CNameTableRecord* Find(CString& sID);

	CString PrepareFileName(MMSObjectType Type, CString& Dir);

	inline int GetNRecords() {return nRecords;};
	inline CNameTableRecord* operator[](int i) {return NameTable[i];};
};

#endif