
#ifndef STORAGE_H
#define STORAGE_H


#include "Declarations.h"
#include "StreamInfo.h"

class CStorage
{
protected:
	CList<IStorage*, IStorage*&> Storages;
	bool ReleaseRootStorage;
public:
	IStream* pStream;
	CString StreamName;
	CStreamInfo StreamInfo;

public:
	CStorage();
	CStorage(CString& CompoundName);
	CStorage(IStorage* pStorage);
	CStorage(CStorage& Storage);
	//       ,   SubStorage
	//     -     
	CStorage(CStorage& Storage, CString SubStorage);
	~CStorage();

public:
	CString FullPath();

	bool Open(CStringArray* StorageName);
	bool Open(CString& StorageName);
	inline bool Open(LPCSTR StorageName) {return Open(CString(StorageName));};
	bool Open(const wchar_t* StorageName);
	bool Create(CStringArray* StorageName);
	bool Create(CString& StorageName);
	bool Delete(CString& StorageName);
	void Close();
	
	bool OpenStream(CString& StreamName);
	bool CreateStream(CString& StreamName);
	void CloseStream();

	bool StorageExist(CString& StorageName);
	bool StreamExist(CString& StreamName);
	long GetStreamSize(CString& StreamName);

	void Rewind();

	void GetCleanStream();
	bool CopyToFile(FILE* File, unsigned long bytes_to_copy);
	bool CopyToFile(CString& FileName, bool OnlyRestOfSream = false);
	bool CopyToFile(CString& StreamName, CString& FileName);
	bool Extract(CString& DestDir, bool WithContainerContents = true);
	bool StreamFromFile(CString& StreamName, CString& FileName);
	void AddZeroByte();
	bool StreamFromString(CString StreamName, CString& String);
	bool FromFile(CString& FileName);
	bool FromFile(FILE* File, LPCSTR FileName = NULL);
	bool StorageFromDir(CString& StorageName, CString& SrcDir);

	//     .    
	//  (  ,    ).   bytes_to_compare > 0, 
	//     .    -   
	//   .
	int Compare(FILE* File, unsigned long bytes_to_compare);
	int Compare(CString& FileName, unsigned long bytes_to_compare);
	//    (   )
	bool operator== (CString& FileName);

	IStorage* GetStorage();

	CMMSObject* ParseStream(CString& StreamName);

private:
	unsigned long AppendFile(IStream* pStream, FILE* File);
	unsigned long AppendFile(IStream* pStream, CString& FileName);
	void WriteSizeToStream(IStream* pStream);
	bool ExtractPictureGallery(CString& FileName);
	
	bool GalleryImported; // -    Gallery 3 
	bool ImportPictureGallery(CString& StreamName, CString& FileName);
};



LPCSTR GetStgErrorString(HRESULT err);

ULARGE_INTEGER GetStreamSize(IStream* pStream);

IStorage* OpenCompound(CString& CompoundFileName);

IStorage* OpenStorage(IStorage* pParentStorage, wchar_t* wStorName);
IStorage* OpenStorage(IStorage* pParentStorage, CString& StorName);

IStream* OpenStream(IStorage* pParentStorage, wchar_t* wStreamName);
IStream* OpenStream(IStorage* pParentStorage, CString& StreamName);

bool StringDifferFromFile(CString& String, CString& FileName);
bool CopyStringToFile(CString& String, CString& FileName);

//      
void AddToExtractedList(CString& FullFName, CMMSObject* object = NULL);
void CheckPrune(CString& FullFName);
bool ObjectExtracted(CMMSObject* object);

#endif