
#ifndef UserInterfaces_H
#define UserInterfaces_H 1

#include "Declarations.h"

class CUICommand
{
public:
	DWORD ID;
	CString Param1;
	CString Hint;
	BYTE HotKeyModifier; //Alt - 0x11, Ctrl - 0x09, Shift - 0x05   OR 
	WORD HotKey; //ScanCode 
	CString Command;
	CString CmdParameter;

public:
	CString AsString(bool IsChild);
};

class CUICommands
{
public:
	CString StorageName;
	CString ParentInterface;
	CString Description;
	DWORD NoOperMenuPresent;
	DWORD IsDefault;
	DWORD NCommands;
	CUICommand* Commands;
	bool IsChild;

public:
	CUICommands();
	~CUICommands();

	//   
	DWORD Read(CStorage& Storage, CString& UIName);
	CString AsString();
};

class CUIMenu
{
	typedef enum {MainMenu, MenuGroup, MenuItem, MenuDividor} TMenuType;
public:
	TMenuType Type;
	CUIMenu* Parent;
	DWORD Level;
	DWORD NItems;
	CString Caption;
	DWORD ID;
	CUIMenu* Items;

public:
	CUIMenu();
	~CUIMenu();

public:
	//   
	DWORD Read(CStorage& Storage, CUIMenu* Parent);
	CString AsString();
};

class CUIPanel
{
public:
	CString Caption;
	DWORD NButtons;
	DWORD Placement;
	DWORD IsVisible;
	DWORD OnNewLine;

public:
	//   
	DWORD Read(CStorage& Storage);
	CString AsString();
};

class CButton
{
public:
	DWORD ID;
	CString Caption;

	CString AsString(bool WithCaption);
};

class CUIPanels
{
private:
	DWORD BMP_offset;

public:
	DWORD ID;
	DWORD NPanels;
	CUIPanel* Panels;
	DWORD NButtons;
	CButton* AllButtons;
	DWORD NTextButtons;
	CButton* TextButtons;
	DWORD NPictureButtons;
	CButton* PictureButtons;

public:
	CUIPanels();
	~CUIPanels();

public:
	bool Read(CStorage& Storage);
	CString AsString();
	void ExtractBMP(CString& Dir, CStorage& Storage);
};


class CUserInterface;
typedef CUserInterface* PCUserInterface;
class CUserInterfaces;

class CUserInterfaces : public CArray<PCUserInterface, PCUserInterface&>
{
public:
	~CUserInterfaces();

public:
	void AddInterface(CUserInterface* Interface);
	CUserInterface* FindInterface(CString& Name);
	void Extract(CString& Dir, CStorage& Storage);
};

class CUserInterface
{
public:
	CString StorageName;

public:
	CString Name;
	CUserInterface* Parent;
	CUICommands Commands;
	CUIMenu Menu;
	CUIPanels Panels;

	CUserInterfaces Children;

public:
	CUserInterface() {Parent = NULL;};

public:
	void Read(CString& Dir, CStorage& Storage, CMMSObject* Container);
	void Extract(CString& Dir, CStorage& Storage);
};


bool DecompileUI(CString& Dir, CStorage& Storage);

#endif
