//////////////////////////////////////////////////////////////////////
// Task.cpp: implementation of the CTask class.
//////////////////////////////////////////////////////////////////////

#include <iostream.h>
#include "Task.h"
#include "CommonFunctions.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//////////////////////////////////////////////////////////
//// class CTaskParameters  //////////////////////////////
//////////////////////////////////////////////////////////
CTaskParameters::~CTaskParameters()
{
}

void CTaskParameters::ParseCommandLine(int argc, TCHAR* argv[])
{
	TCHAR *DirName  = "SRC";
	TCHAR *FileName = "1cv7.md";
	bool PreserveDir = false;

	if (argc <= 1) //no arguments at all
	{
		TaskType = help;
		return;
	}

	for( int i=1; i<argc; i++ )
	{
		TCHAR *arg;

		arg = argv[i];
		if( 0 == strcmp("-h", arg) )
		{
			TaskType = help;
		}
		else if( 0 == strcmp("-c", arg) )
		{
			TaskType = compile;
			FileName = "1cv7.new.md"; //  
		}
		else if( 0 == strcmp("-d", arg) )
		{
			TaskType = decompile;
		}
		else if( 0 == strcmp("-v", arg) )
		{
			Verbose = 1;
		}
		else if( 0 == strcmp("-vv", arg) )
		{
			Verbose = 2;
		}
		else if( 0 == strcmp("-vvv", arg) )
		{
			Verbose = 3;
		}
		else if( 0 == strcmp("-q", arg) )
		{
			Verbose = -1;
		}
		else if( 0 == strcmp("-D", arg) )
		{
			arg = argv[++i];
			DirName = arg;
		}
		else if( 0 == strcmp("-DD", arg) )
		{
			arg = argv[++i];
			DirName = arg;
			PreserveDir = true;
		}
		else if( 0 == strcmp("-F", arg) )
		{
			arg = argv[++i];
			FileName = arg;
		}
		else if( 0 == strcmp("--external-report", arg) )
		{
			CompoundType = external_report;
		}
		else if( 0 == strcmp("--meta-data", arg) )
		{
			CompoundType = meta_data;
		}
		else if( 0 == strcmp("--no-profiles", arg) )
		{
			NoProfiles = true;
		}
		else if( 0 == strcmp("--no-empty-mxl", arg) )
		{
			NoEmptyMxl = true;
		}
		else if( 0 == strcmp("--truncate-mms", arg) )
		{
			TruncateMMS = true;
		}
		else if( 0 == strcmp("--eng", arg) )
		{
			Language = Eng;
		}
		else if( 0 == strcmp("--translit", arg) )
		{
			Language = Translit;
		}
		else if( 0 == strcmp("--version", arg) )
		{
			ShowVersion = true;
		}
		else if( 0 == strcmp("--no-parse-dialog", arg) )
		{
			NotParseForms = true;
		}
		else
		{
			cout << "Invalid option '" << arg << "'\n";
			TaskType = help;
			return;
		}
	}

	//Copy file and dir names into class variables
	CompoundFileName = FileName;

	//Split file name on parts
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	_splitpath(FileName, NULL, NULL, fname, ext);

	//Try to determine file type by extension
	if( CompoundType == by_extension )
	{
		if( stricmp(ext, ".ert") == 0 )
			CompoundType = external_report;
		else
			CompoundType = meta_data;
	}

	//In case of external report add its name to directory. 
	//When directory specified explicitly leave its name unchanged
	if( (CompoundType == external_report) && !PreserveDir )
		DirectoryName.Format("%s\\%s", DirName, fname);
	else
		DirectoryName = DirName;

	//     ,         
	if( (CompoundType != external_report) ) TruncateMMS = false;
}


//////////////////////////////////////////////////////////
//// class CTask   ///////////////////////////////////////
//////////////////////////////////////////////////////////
CTask::CTask()
{
	thisTask = NULL;
}

CTask::CTask(int argc, TCHAR* argv[])
{
	thisTask = NULL;
	
	switch( TaskParameters.TaskType )
	{
		case CTaskParameters::help:
			thisTask = new CTaskHelp;
			break;
		case CTaskParameters::compile:
			thisTask = new CTaskCompile;
			break;
		case CTaskParameters::decompile:
			thisTask = new CTaskDecompile;
			break;
	}
}

CTask::~CTask()
{
	if( thisTask != NULL ) delete thisTask;
}

void CTask::Action()
{
	thisTask->Action();
}



