
#include "UI.h"
#include "CommonFunctions.h"
#include "NameTable.h"
#include "Storage.h"
#include "Container.h"

#define BUFF_SIZE 2048  //   , ..       255 

char* Trim(char* str)
{
	unsigned char* ptr = (unsigned char*)str;
	while( isspace(*ptr) && *ptr != '\0' ) ptr++;
	if( *ptr != '\0' )
	{
		unsigned char* end = ptr + strlen((char*)ptr) - 1;
		while( *end == '\r' || *end == '\n' ) *end-- = '\0'; //  \r\n
		//while( isspace(*end) && *end != '\0' ) *end-- = '\0'; //  
	}
	return (char*)ptr;
}

bool BreakString(char* str, char*& id, char*& value)
{
	char* colon = strchr(str, ':');

	id = NULL;
	value = NULL;
	if( colon == NULL ) return false;

	id = str;
	*colon++ = '\0';
	value = Trim(colon);
	return true;
}

DWORD YesNo2DWORD(char* str)
{
	if( _stricoll(str, "") == 0 ) return 1;
	return 0;
}

DWORD StrToID(char* str)
{
	char *stopstring;
	return strtol(str, &stopstring, 16);
}

void WriteUIString(IStream* pStream, CString& String)
{
	BYTE len = String.GetLength();
	pStream->Write(&len, sizeof(len), NULL);
	if( len > 0 ) pStream->Write((LPCSTR)String, len, NULL);
}

bool CUICommands::ReadFromFile(CString& FileName)
{
	FILE* File = fopen(FileName, "rt");
	char buff[BUFF_SIZE];
	CUICommand* Command = NULL;
	int state = 1; //1 - ; 2 - ; 3 - ; 4   ; 5 -  '}' 

	Msg(2, "  '%s'\n", FileName);

	NCommands = 0;
	Commands.SetSize(128);
	while( fgets(buff, sizeof(buff), File) != NULL )
	{
		char* ptr = Trim(buff);
		if( *ptr == '\0' ) continue;

		char *id, *value;
		BreakString(ptr, id, value);
		switch( state )
		{
		case 1: //  
			if( ptr[0] == '{' )
				state = 2;
			else
			{
				if( _stricoll(id, "") == 0 ) 
					StorageName = value;
				else if( _stricoll(id, "") == 0 )
				{
					if( _stricoll(value, "") == 0 )
						IsChild = false;
					else
						IsChild = true;
				}
				else if( _stricoll(id, "") == 0 )
					InterfaceName = value;
				else if( _stricoll(id, "") == 0 )
					ParentInterface = value;
				else if( _stricoll(id, "") == 0 )
					Description = value;
				else if( _stricoll(id, "") == 0 )
					NoOperMenuPresent = YesNo2DWORD(value);
				else if( _stricoll(id, "") == 0 )
					IsDefault = YesNo2DWORD(value);
			}
			break;
		case 2: // 
			if( ptr[0] == '}' )
			{
				state = 5;
			}
			else
			{
				NCommands++;
				if( Commands.GetSize() < NCommands ) Commands.SetSize(Commands.GetSize()*2);
				Command = &(Commands[NCommands-1]);
				if( IsChild )
				{
					//       2 (  state = 3  )
					Command->Command = id;
					Command->CmdParameter = value;
				}
				else
				{
					Command->ID = StrToID(id);
					state = 3;
				}
			}
			break;
		case 3: // 
			if( ptr[0] == '}' ) //   
			{
				state = 2;
			}
			else if( ptr[0] == '{' ) //   
			{
			}
			else
			{
				if( _stricoll(id, "1") == 0 ) 
					Command->Param1 = value;
				else if( _stricoll(id, "Hint") == 0 )
					Command->Hint = value;
				else if( _stricoll(id, "HotKey") == 0 )
				{
					BreakString(value, id, value);
					if( id != NULL ) Command->HotKeyModifier = StrToID(id);
					if( value != NULL ) Command->HotKey = StrToID(value);
				}
				else if( _stricoll(id, "") == 0 )
					Command->Command = value;
				else if( _stricoll(id, "") == 0 )
					Command->CmdParameter = value;
			}
			break;
		case 4: //   
			break;
		case 5: //    
			Msg(0, "WARN:  : '%s'\n", buff);
			break;
		default:
			Msg(0, "WARN:  : '%s'\n", buff);
			break;
		}
	}

	if( state == 5 )
		return true;
	else
		return false;
}

bool CUICommands::Write(CStorage& Storage, CString& SrcDir)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_UICommands);
	Storage.CreateStream(nt_rec->PrepareStorageName());
	IStream* pStream = Storage.pStream;

	pStream->Write(&ID, sizeof(ID), NULL);
	if( IsChild )
	{
		WriteUIString(pStream, ParentInterface);
	}
	else
	{
		WriteUIString(pStream, Description);
	}
	pStream->Write(&NoOperMenuPresent, sizeof(NoOperMenuPresent), NULL);
	pStream->Write(&IsDefault, sizeof(IsDefault), NULL);

	if( IsChild )
	{
		WriteUIString(pStream, Description);
	}
	
	pStream->Write(&NCommands, sizeof(NCommands), NULL);

	for( DWORD i = 0; i < NCommands; i++ )
	{
		CUICommand& cmd = Commands[i];
		
		cmd.CmdParameter.Replace(':', '\n');
		if( IsChild )
		{
			WriteUIString(pStream, cmd.Command);
			WriteUIString(pStream, cmd.CmdParameter);
		}
		else
		{
			pStream->Write(&cmd.ID, sizeof(cmd.ID), NULL);
			
			WriteUIString(pStream, cmd.Param1);
			WriteUIString(pStream, cmd.Hint);
			
			pStream->Write(&cmd.HotKeyModifier, sizeof(cmd.HotKeyModifier), NULL);
			pStream->Write(&cmd.HotKey, sizeof(cmd.HotKey), NULL);

			WriteUIString(pStream, cmd.Command);
			WriteUIString(pStream, cmd.CmdParameter);
		}
	}

	Msg(2, "CPY: %s\n", nt_rec->PrepareFileName(SrcDir));

	return true;
}

CUIMenu* CUIMenu::AddItem()
{
	NItems++;
	if( Items.GetSize() < NItems )
	{
		if( Items.GetSize() == 0 )
			Items.SetSize(32);
		else
			Items.SetSize(Items.GetSize()*2);
	}
	Items[NItems-1].Parent = this;
	return &(Items[NItems-1]);
}

bool CUIMenu::ReadFromFile(FILE* File, CUIMenu* Parent, int level)
{
	char buff[BUFF_SIZE];

	Level = level;
	NItems = 0;
	CUIMenu* Item;
	while( fgets(buff, sizeof(buff), File) != NULL )
	{
		char* ptr = Trim(buff);
		if( *ptr == '\0' ) continue;

		char *id, *value;
		BreakString(ptr, id, value);

		if( *ptr == '{' )
		{
		}
		else if( *ptr == '}' )
		{
			return true;
		}
		else if( _stricoll(id, " ") == 0 )
		{
			Type = MainMenu;
			ID = 0x01;
		}
		else if( _stricoll(id, "") == 0 )
		{
			Item = AddItem();
			Item->Type = MenuGroup;
			Item->ID = 0xFFFFFFFF;
			Item->Caption = value;
			Item->ReadFromFile(File, Item, level + 1);
		}
		else if( _stricoll(id, "") == 0 )
		{
			Item = AddItem();
			Item->Type = MenuItem;
			BreakString(value, id, value);
			Item->ID = StrToID(id);
			Item->Caption = value;
			Item->Level = Level + 1;
		}
		else if( _stricoll(id, "") == 0 )
		{
			Item = AddItem();
			Item->Type = MenuDividor;
			Item->ID = 0x00;
			Item->Level = Level + 1;
		}
	}
	return true;
}


bool CUIMenu::ReadFromFile(CString& FileName)
{
	FILE* File = fopen(FileName, "rt");

	Msg(2, "  '%s'\n", FileName);

	ReadFromFile(File, NULL, 0);
	return true;
}

bool CUIMenu::Write(CStorage& Storage, CString& SrcDir)
{
	if( Type == MainMenu )
	{
		CNameTableRecord* nt_rec = NameTable.Find(NT_UIMenu);
		Storage.CreateStream(nt_rec->PrepareStorageName());
		Msg(2, "CPY: %s\n", nt_rec->PrepareFileName(SrcDir));
	}
	IStream* pStream = Storage.pStream;

	pStream->Write(&ID, sizeof(ID), NULL);

	if( Type == MenuGroup || Type == MenuItem )
	{
		WriteUIString(pStream, Caption);
	}

	if( Type == MainMenu || Type == MenuGroup )
	{
		pStream->Write(&NItems, sizeof(NItems), NULL);
	}

	for( int i = 0; i < NItems; i++ )
	{
		Items[i].Write(Storage, SrcDir);
	}

	return true;
}


bool CUIPanel::Write(CStorage& Storage)
{
	IStream* pStream = Storage.pStream;
	WriteUIString(pStream, Caption);
	pStream->Write(&NButtons, sizeof(NButtons), NULL);
	pStream->Write(&Placement, sizeof(Placement), NULL);
	pStream->Write(&IsVisible, sizeof(IsVisible), NULL);
	pStream->Write(&OnNewLine, sizeof(OnNewLine), NULL);
	return true;
}

bool CUIPanels::ReadFromFile(CString& FileName)
{
	FILE* File = fopen(FileName, "rt");
	char buff[BUFF_SIZE];
	CUIPanel Panel;
	CButton Button;
	int state = 0; //0 -  ; 1 -  ; 2 -    ; 3 -   ; 4 -    

	Msg(2, "  '%s'\n", FileName);

	while( fgets(buff, sizeof(buff), File) != NULL )
	{
		char* ptr = Trim(buff);
		
		if( *ptr == '\0' ) continue;
		if( *ptr == '{' ) continue;
		if( *ptr == '}' )
		{
			state = 0;
			continue;
		}

		char *id, *value;
		BreakString(ptr, id, value);
		switch( state )
		{
		case 0:
			if( _stricoll(id, "") == 0 )
			{
				Panels.Add(Panel);
				Panels[NPanels].Caption = value;
				NPanels++;
				state = 1;
			}
			else if( _stricoll(id, "") == 0 )
			{
				state = 2;
			}
			else if( _stricoll(id, " ") == 0 )
			{
				state = 3;
			}
			else if( _stricoll(id, "  ") == 0 )
			{
				state = 4;
			}
			break;
		case 1:
			{
				CUIPanel& Panel = Panels[NPanels-1];
				if( _stricoll(id, "") == 0 )
				{
					if( _stricoll(value, "") == 0 ) Panel.Placement = 0xE81B;
					if( _stricoll(value, "")  == 0 ) Panel.Placement = 0xE81C;
					if( _stricoll(value, "") == 0 ) Panel.Placement = 0xE81D;
					if( _stricoll(value, "")  == 0 ) Panel.Placement = 0xE81E;
				}
				else if( _stricoll(id, "") == 0 )
					Panel.IsVisible = YesNo2DWORD(value);
				else if( _stricoll(id, "  ") == 0 )
					Panel.OnNewLine = YesNo2DWORD(value);
				else if( _stricoll(id, "") == 0 )
					Panel.NButtons = atol(value);
			}
			break;
		case 2:
			AllButtons.Add(Button);
			AllButtons[NButtons++].ID = StrToID(ptr);
			break;
		case 3:
			TextButtons.Add(Button);
			TextButtons[NTextButtons].ID = StrToID(id);
			TextButtons[NTextButtons].Caption = value;
			NTextButtons++;
			break;
		case 4:
			PictureButtons.Add(Button);
			PictureButtons[NPictureButtons++].ID = StrToID(ptr);
			break;
		}
	}

	return true;
}

bool CUIPanels::Write(CStorage& Storage, CString& Dir)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_UIPanels);
	Storage.CreateStream(nt_rec->PrepareStorageName());
	IStream* pStream = Storage.pStream;
	DWORD i;

	pStream->Write(&ID, sizeof(ID), NULL);
	pStream->Write(&NPanels, sizeof(NPanels), NULL);
	
	for( i = 0; i < NPanels; i++ )
	{
		Panels[i].Write(Storage);
	}

	for( i = 0; i < NButtons; i++ )
	{
		pStream->Write(&AllButtons[i].ID, sizeof(AllButtons[i].ID), NULL);
	}

	pStream->Write(&NTextButtons, sizeof(NTextButtons), NULL);
	for( i = 0; i < NTextButtons; i++ )
	{
		WriteUIString(pStream, TextButtons[i].Caption);
		pStream->Write(&TextButtons[i].ID, sizeof(TextButtons[i].ID), NULL);
	}

	pStream->Write(&NPictureButtons, sizeof(NPictureButtons), NULL);
	for( i = 0; i < NPictureButtons; i++ )
	{
		pStream->Write(&PictureButtons[i].ID, sizeof(PictureButtons[i].ID), NULL);
	}

	CNameTableRecord* nt_rec_b = NameTable.Find(NT_UIPanelsBMP);
	Storage.AppendFile(pStream, nt_rec_b->PrepareFileName(Dir));

	Msg(2, "CPY: %s\n", nt_rec->PrepareFileName(Dir));
	Msg(2, "CPY: %s\n", nt_rec_b->PrepareFileName(Dir));

	return true;
}

void CUserInterfaces::ReadFromDir(CString& SrcDir, CUserInterface* Parent)
{
	CString TranslitSrcDir = Translit(SrcDir);
	CString DirName;
	struct _finddata_t find_data;
	long hFind;

	hFind = _findfirst(TranslitSrcDir+"\\*", &find_data);
	if( hFind != -1 )
	{
		do
		{
			if( IsIgnoredFile(find_data.name) ) continue;
			
			if( (find_data.attrib & _A_SUBDIR) != 0 )
			{
				DirName.Format("%s\\%s", TranslitSrcDir, find_data.name);
				CUserInterface* Interface = new CUserInterface;
				if( Interface->ReadFromDir(DirName, Parent) )
				{
					Add(Interface);
				}
				else
				{
					delete Interface;
				}
			}
		} while( _findnext(hFind, &find_data) == 0 );
		_findclose(hFind);
	}
}


bool CUserInterface::ReadFromDir(CString& SrcDir, CUserInterface* Parent)
{
	CNameTableRecord* nt_rec_c = NameTable.Find(NT_UICommands);
	CNameTableRecord* nt_rec_m = NameTable.Find(NT_UIMenu);
	CNameTableRecord* nt_rec_p = NameTable.Find(NT_UIPanels);
	CNameTableRecord* nt_rec_pb = NameTable.Find(NT_UIPanelsBMP);

	CString CommandsFName = Translit(nt_rec_c->PrepareFileName(SrcDir));
	CString MenuFName = Translit(nt_rec_m->PrepareFileName(SrcDir));
	CString PanelsFName = Translit(nt_rec_p->PrepareFileName(SrcDir));

	if( !FileExist(CommandsFName) ) return false;

	this->DirName = SrcDir;
	this->Parent = Parent;
	Commands.ReadFromFile(CommandsFName);
	Name = Commands.InterfaceName;

	if( FileExist(MenuFName) ) Menu.ReadFromFile(MenuFName);
	if( FileExist(PanelsFName) ) Panels.ReadFromFile(PanelsFName);

	Children.ReadFromDir(SrcDir, this);

	return true;
}

bool CUserInterface::Write(CStorage& Storage)
{
	Storage.Create(Commands.StorageName);
	Commands.Write(Storage, DirName);
	if( !Commands.IsChild )
	{
		Menu.Write(Storage, DirName);
		Panels.Write(Storage, DirName);
	}
	CContainer CC;
	CC.Create(Storage, false, CT_UserInterfaces);
	Storage.Close();

	for( int i = 0; i < Children.GetSize(); i++ )
	{
		Children[i]->Write(Storage);
	}

	return true;
}

void CUserInterface::MakeContainerContents(CString& CC)
{
	if( Commands.IsChild )
		CC += ",{\"SubUsersInterfaceType\",\"";
	else
		CC += ",{\"UsersInterfaceType\",\"";
	CC += Commands.StorageName;
	CC += "\",\"";
	CC += Name;
	CC += "\",\"\"}";

	for( int i = 0; i < Children.GetSize(); i++ )
	{
		Children[i]->MakeContainerContents(CC);
	}
}


bool CompileUI(CStorage& Storage, CString& SrcDir)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_UserInterface);
	CString UIDir = nt_rec->PrepareDirName(SrcDir);
	CStorage UIStorage(Storage);
	CUserInterfaces UserInterfaces;

	UserInterfaces.ReadFromDir(UIDir);

	UIStorage.Create(nt_rec->PrepareStorageName());
	CString CC = "{\"Container.Contents\"";
	int i, sz = UserInterfaces.GetSize();
	for( i = 0; i < sz; i++ )
	{
		CUserInterface& Interface = *(UserInterfaces.GetAt(i));
		Interface.Write(UIStorage);
		Interface.MakeContainerContents(CC);
	}
	CC += "}\n";

	UIStorage.StreamFromString(CString("Container.Contents"), CC);
	return true;
}