
#include "MMS.h"
#include "NameTable.h"
#include "Task.h"
#include "Storage.h"
#include "CommonFunctions.h"
#include "Ordering.h"
#include "UI.h"


///////////////////////////////////////////////////////////////////////
///////////  class CMMSObject methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSObject::ExtractString(CString& Str, CString& DestDir, MMSObjectType Type)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CopyStringToFile(Str, nt_rec->PrepareFileName(DestDir));
}

void CMMSObject::ExtractMetadata(CString& DestDir, MMSObjectType Type, CStorage* TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString Content = AsString();

	if( nt_rec->Dir.GetLength() > 0 )
	{
		CString Dir = nt_rec->PrepareDirName(DestDir);
		CreateDirectory(Dir);
		if( TypedTextStorage != NULL )
		{
			ExtractDescriptions(Dir+"\\", *TypedTextStorage, true);
		}
	}
	
	CString FName = nt_rec->PrepareFileName(DestDir, this);
	CopyStringToFile(Content, FName);
}

void CMMSObject::ExtractMetadata(CString& DestDir, CStorage* TypedTextStorage)
{
	ExtractMetadata(DestDir, NT_MetadataPart, TypedTextStorage);
}

void CMMSObject::ExtractDescriptions(CString& FNamePrefix, CStorage& TypedTextStor, bool StdName)
{
	if( Type == MMS_Property ) return; //    

	CNameTableRecord* nt_rec = NameTable.Find(NT_UserHelpStor);
	CNameTableRecord* nt_rec_file = NameTable.Find(NT_UserHelp);
	CString StorName = nt_rec->PrepareStorageName(ID);
	CString NewPrefix = FNamePrefix;
	bool to_extract = true;
	
	if( ID_Type == IDT_NoID )
		to_extract = false;
	else if( ID_Type == IDT_OnlyTextual )
	{
		to_extract = false;
		NewPrefix.Format("%s%s.", FNamePrefix, sID);
	}
	else if( ID_Type == IDT_OnlyNumeric )
	{
		to_extract = false;
		NewPrefix.Format("%s%i.", FNamePrefix, ID);
	}
	else if( !IsValidFileName(sID) )
		NewPrefix.Format("%s%i.", FNamePrefix, ID);
	else
		NewPrefix.Format("%s%s.", FNamePrefix, sID);

	if( to_extract && !ObjectExtracted(this) && TypedTextStor.StorageExist(StorName) )
	{
		CString FName;

		if( StdName )
			FName.Format("%s%s.%s", FNamePrefix, nt_rec_file->FileName, nt_rec_file->Ext);
		else
			FName.Format("%s%s", NewPrefix, nt_rec_file->Ext);

		TypedTextStor.Open(StorName);
		TypedTextStor.CopyToFile(nt_rec_file->PrepareStorageName(ID), FName);
		AddToExtractedList(FName, this);
		TypedTextStor.Close();
	}

	for( int i = 0; i < GetNProps(); i++ )
	{
		GetPropByNum(i)->ExtractDescriptions(NewPrefix, TypedTextStor, false);
	}
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSObjectWithProps methods  ///////////////////////
///////////////////////////////////////////////////////////////////////

//     '_'.     
int MangleFileName(CString str)
{
	char* ptr = (char*)(LPCSTR)str;
	int repl_count = 0;
	while( *ptr != '\0' )
	{
		int c = (unsigned char)(*ptr); //unsigned -    
		if( !__iscsym(c) ) { *ptr = '_'; repl_count++; };
		ptr++;
	}
	return repl_count;
}

void CMMSObjectWithProps::ExtractMoxelPages(CString& DestDir, CStorage& WBStorage)
{
	CNameTableRecord* nt_rec_mxl = NameTable.Find(NT_MoxelSheet);
	CMMSNodeList* WBContent = NULL;

	WBContent = (CMMSNodeList*)WBStorage.ParseStream(CString("Container.Contents"));
	if( WBContent == NULL ) return; // 

	//Analyze Container.Contents and extract moxel pages if any.
	CString std_tab_name("Moxel WorkPlace");
	CString ID_mxl("Moxcel.Worksheet");
	CString mxlFName;
	CObjectOrdering Order(3);
	//Order.FormatString = "%s.%s.%s\t%s\r\n";
	
	POSITION pos = WBContent->GetHeadPosition();
	while( pos != NULL )
	{
		CMMSObject* SubNode = WBContent->GetNext(pos);
		if( SubNode->sID == ID_mxl )
		{
			CMMSObject* pMXL = SubNode->GetPropByNum(1);
			CString tab_name = (LPCSTR)pMXL->sID;
			CString page_suffix = Suffix(SubNode->GetPropByNum(0)->sID);
			if( tab_name == std_tab_name )
				tab_name = "";
			else
			{
				if( MangleFileName(tab_name) > 0 )
					Msg(2, "MXL %s replaced by %s\n", pMXL->sID, tab_name);
			}

			mxlFName.Format("%s.%s.%s", tab_name, page_suffix, nt_rec_mxl->Ext);

			if( TaskParameters.NoEmptyMxl ) //  
			{
				long size = WBStorage.GetStreamSize(SubNode->GetPropByNum(0)->sID);
				if( size == 147 || size == 139 ) continue;
			}

			WBStorage.CopyToFile(SubNode->GetPropByNum(0)->sID, DestDir+"\\"+mxlFName);
			
			Order.Add(page_suffix, mxlFName, Translit(mxlFName), pMXL->sID);
		}
	}

	if( Order.Order.GetLength() > 0 ) Order.WriteFile(DestDir);

	delete WBContent;
}

void CMMSObjectWithProps::ExtractWorkBook(CString& DestDir, CStorage& Storage)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_Workbook);
	bool opened;

	if( TaskParameters.CompoundType == CTaskParameters::external_report )
		opened = true; //    WorkBook,     
	else
		opened = Storage.Open(nt_rec->StorageName);

	if( opened )
	{
		// 
		ExtractStreamByType(Storage, NT_FormModule, DestDir);
		// 
		if( TaskParameters.NotParseForms )
		{
			ExtractStreamByType(Storage, NT_DialogForm, DestDir);
		}
		else
		{
			CNameTableRecord* nt_rec_dlg = NameTable.Find(NT_DialogForm);
			CMMSObject* dlg_form = Storage.ParseStream(nt_rec_dlg->PrepareStorageName());
			if( dlg_form != NULL )
			{
				CMMSObject* Prop1 = dlg_form->GetPropByNum(1);
				if( Prop1->ID == 0 && Prop1->sID.IsEmpty() ) dlg_form->DelProperty(1);
				ExtractString(dlg_form->AsString(), DestDir, NT_DialogForm);
				delete dlg_form;
			}
			else //-    -     
			{
				ExtractStreamByType(Storage, NT_DialogForm, DestDir);
			}
		}

		// 
		ExtractMoxelPages(DestDir, Storage);

		if( TaskParameters.CompoundType != CTaskParameters::external_report )
			Storage.Close();
	}
}

void CMMSObjectWithProps::ExtractListForms(CMMSObject* Forms, CString& Dir, 
										   CStorage& Storage, CString Prefix)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_ListForm);
	CString StorName;

	for( int i = 0; i < Forms->GetNProps(); i++ )
	{
		CMMSObject* Form = Forms->GetPropByNum(i);
		CString FormDir;
		FormDir.Format("%s\\%s.%s", Dir, Form->sID, nt_rec->Ext);
		CreateDirectory(FormDir);
		
		StorName.Format("%s%i", Prefix, Form->ID);
		if( Storage.Open(StorName) )
		{
			ExtractWorkBook(FormDir, Storage);
			Storage.Close();
		}
	}
}

void CMMSObjectWithProps::ExtractStreamByType(CStorage& Storage, MMSObjectType Type, CString& Dir)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage SubStorage(Storage);
	SubStorage.CopyToFile(nt_rec->PrepareStorageName(ID), nt_rec->PrepareFileName(Dir));
}

void CMMSObjectWithProps::ExtractOrdering(CString& DestDir)
{
	int nProps = GetNProps();
	if( nProps == 0 ) return;

	CObjectOrdering Order(2);

	for( int i = 0; i < nProps; i++ )
	{
		CMMSObject* obj = GetPropByNum(i);
		Order.Add(obj->ID, obj->sID, Translit(obj->sID));
	}

	Order.WriteFile(DestDir);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMS methods  //////////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMS::ExtractStorage(CString& Dir, CStorage& Storage, MMSObjectType Type, bool WithContainerCOntents)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString DestDir = nt_rec->PrepareDirName(Dir);
	CStorage SrcStorage(Storage);

	if( SrcStorage.Open(nt_rec->PrepareStorageName(ID)) )
	{
		CreateDirectory(DestDir);
		if( !SrcStorage.Extract(DestDir, WithContainerCOntents) ) remove(DestDir);
	}
}

void CMMS::ExtractCommonMXL(CString& Dir, CStorage& Storage)
{
	CNameTableRecord* nt_rec_gd = NameTable.Find(NT_GlobalData);
	CNameTableRecord* nt_rec = NameTable.Find(NT_CommonMXL);
	CString GDDir = nt_rec->PrepareDirName(Dir);
	
	CString StorName = nt_rec_gd->StorageName;
	StorName += "\\";
	StorName += nt_rec->StorageName;
	
	CreateDirectory(GDDir);
	CStorage GDStorage(Storage);
	if( GDStorage.Open(StorName) )
	{
		ExtractWorkBook(GDDir, GDStorage);
	}
}


void CMMS::DeleteUnusedObjects(CStorage& Storage)
{
	int i;

	for( i = 0; i < GetNProps(); i++ )
		GetPropByNum(i)->Used = true;


	CMMSObject* frm = Storage.ParseStream(NameTable.Find(NT_DialogForm)->PrepareStorageName(0));
	CMMSObject* Controls = frm->GetProperty((CString("Controls")));
	for( i = 0; i < Controls->GetNProps(); i++ )
	{
		int nProps = Controls->GetPropByNum(i)->GetNProps();
		CString& sWndClass = Controls->GetPropByNum(i)->GetPropByNum(0)->sID;
		CString sTypeLetter, sTypeID;
		if( isdigit(sWndClass[0]) ) // ,  1    ?!
		{
			sTypeLetter = Controls->GetPropByNum(i)->GetPropByNum(12)->sID;
			sTypeID = Controls->GetPropByNum(i)->GetPropByNum(15)->sID;
		}
		else
		{
			sTypeLetter = Controls->GetPropByNum(i)->GetPropByNum(13)->sID;
			sTypeID = Controls->GetPropByNum(i)->GetPropByNum(16)->sID;
		}

		int ID = atoi(sTypeID);
		if( ID != 0 ) 
			MarkUsed(ID);
	}

	for( i = 0; i < GetNProps(); i++ )
	{
		if( GetPropByNum(i)->Type == MMS_Buh ) continue;
		if( GetPropByNum(i)->Type == MMS_TaskItem ) continue;
		GetPropByNum(i)->DeleteUnused();
	}
}

void CMMS::ExtractPictureGallery(CString& Dir, CStorage& Storage)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_PictureGallery);
	CString DestDir = nt_rec->PrepareDirName(Dir);
	CStorage SrcStorage(Storage);

	if( SrcStorage.Open(nt_rec->PrepareStorageName(ID)) )
	{
		CreateDirectory(DestDir);
		if( !SrcStorage.Extract(DestDir, false) ) remove(DestDir);
	}
}

void CMMS::Decompile(CString& Dir, CStorage& Storage)
{
	//       -      -
	//  
	CMMSDescr* Descr = (CMMSDescr*)GetPropByNum(0);
	Descr->MD_ver = 10009;
	// CRC
	int crc_num = FindProperty(CString("CRC"));
	if( crc_num >= 0 ) DelProperty(crc_num);

	if( TaskParameters.CompoundType == CTaskParameters::external_report	)
	{
		//DeleteUnusedObjects(Storage);
		if( TaskParameters.TruncateMMS )
			ExtractString(CString(MinimalMMS()), Dir, NT_MainMetadataStream);
		else
			ExtractMetadata(Dir);
		ExtractWorkBook(Dir, Storage);
		ExtractStreamByType(Storage, NT_ErtUserHelp, Dir);
		ExtractStorage(Dir, Storage, NT_PictureGallery, false);
		return;
	}

	int nProps = GetNProps();
	for( int i = 0; i < nProps; i++ )
	{
		GetPropByNum(i)->Decompile(Dir, Storage);
	}

	// 
	ExtractStreamByType(Storage, NT_GlobalModule, Dir);
	// 
	ExtractCommonMXL(Dir, Storage);
	
	//
	//ExtractPictureGallery(Dir, Storage);
	ExtractStorage(Dir, Storage, NT_PictureGallery, false);

	// 
	DecompileUI(Dir, Storage);
	// 
	ExtractStorage(Dir, Storage, NT_UserRights, true);

	// 
	ExtractStreamByType(Storage, NT_GUIDData, Dir);
	ExtractStreamByType(Storage, NT_TagStream, Dir);

	//
	CNameTableRecord* nt_rec_descr = NameTable.Find(NT_UserHelpStor);
	CString DescrDir = nt_rec_descr->PrepareDirName(Dir);
	CStorage TypedTextStorage(Storage);
	TypedTextStorage.Open("TypedText");
	//if( !nt_rec_descr->Dir.IsEmpty() ) CreateDirectory(DescrDir); // ,   NameTable    NT_UserHelpStor
	ExtractDescriptions(DescrDir+"\\", TypedTextStorage, false);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSMetadataPart methods  //////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSMetadataPart::Decompile(CString& Dir, CStorage& Storage)
{
	CStorage TypedTextStorage(Storage);
	TypedTextStorage.Open("TypedText");
	ExtractMetadata(Dir, Type, &TypedTextStorage);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSSubCnt methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSSbCnt::Decompile(CString& BaseDir, CStorage& Storage, CStorage& TypedTextStorage, CStorage& SubFolderStorage, CStorage& SubListStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage ScStorage(Storage);
	CString ScDir;
	CString StorName;

	ScDir.Format("%s\\%s", BaseDir, sID);
	InplaceTranslit(ScDir);

	CreateDirectory(ScDir);

	Msg(2, " %s\n", sID);

	//
	ExtractMetadata(ScDir);

	if( ScStorage.Open(nt_rec->PrepareStorageName(ID)) ) //    ,     
	{
		ExtractWorkBook(ScDir, ScStorage);
	}

	//
	ExtractDescriptions(ScDir+"\\", TypedTextStorage, true);

	// 
	nt_rec = NameTable.Find(NT_SubcontoFolder);
	CStorage GroupStorage(SubFolderStorage);
	if( GroupStorage.Open(nt_rec->PrepareStorageName(ID)) != NULL )
	{
		CString SubFldDir = nt_rec->PrepareDirName(ScDir);
		CreateDirectory(SubFldDir);
		ExtractWorkBook(SubFldDir, GroupStorage);
	}

	// 
	nt_rec = NameTable.Find(NT_SubcontoListForm);
	CMMSObject* ListForms = GetProperty(CString("Form"));
	ExtractListForms(ListForms, ScDir, SubListStorage, nt_rec->StorageName);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSSbCnts methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSSbCnts::Decompile(CString& BaseDir, CStorage& Storage)
{
	if( nProps == 0 ) return;

	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage ScsStorage(Storage,       nt_rec->StorageName);
	CStorage TypedTextStorage(Storage, "TypedText");
	CStorage SubFolderStorage(Storage, "SubFolder");
	CStorage SubListStorage(Storage,   "SubList");
	CString  ScsDir = nt_rec->PrepareDirName(BaseDir);

	CreateDirectory(ScsDir);

	for( int i = 0; i < nProps; i++ )
	{
		CMMSSbCnt* pSc = (CMMSSbCnt*)Properties[i];
		pSc->Decompile(ScsDir, ScsStorage, TypedTextStorage, SubFolderStorage, SubListStorage);
	}

	ExtractOrdering(ScsDir);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSGenJrnlFldDef methods  /////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSGenJrnlFldDef::Decompile(CString& Dir, CStorage& Storage)
{
	ExtractMetadata(Dir, Type);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSDocSelRefObj methods  //////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSDocSelRefObj::Decompile(CString& Dir, CStorage& Storage)
{
	ExtractMetadata(Dir, Type);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSDocNumDef methods  /////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSDocNumDef::Decompile(CString& Dir, CStorage& Storage)
{
	ExtractMetadata(Dir, Type);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSDocument methods  //////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSDocument::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage TransactStorage(TypedTextStorage);
	CString DocDir(Dir);

	DocDir += "\\";
	DocDir += sID;
	CreateDirectory(DocDir);

	ExtractMetadata(DocDir);

	if( Storage.Open(nt_rec->PrepareStorageName(ID)) ) //    ,     
	{
		ExtractWorkBook(DocDir, Storage);
		Storage.Close();
	}

	// 
	nt_rec = NameTable.Find(NT_TransModuleStor);
	if( TransactStorage.Open(nt_rec->PrepareStorageName(ID)) )
	{
		nt_rec = NameTable.Find(NT_TransactModule);
		TransactStorage.CopyToFile(nt_rec->StorageName, nt_rec->PrepareFileName(DocDir));
	}

	ExtractDescriptions(DocDir+"\\", TypedTextStorage, true);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSDocuments methods  /////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSDocuments::Decompile(CString& Dir, CStorage& Storage)
{
	if( nProps == 0 ) return;

	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage TypedTextStorage(Storage, "TypedText");
	CString DocsDir = nt_rec->PrepareDirName(Dir);

	CreateDirectory(DocsDir);

	Storage.Open(nt_rec->PrepareStorageName(ID));
	for( int i = 0; i < nProps; i++ )
	{
		CMMSDocument* pDoc = (CMMSDocument*)Properties[i];
		pDoc->Decompile(DocsDir, Storage, TypedTextStorage);
	}
	Storage.Close();

	ExtractOrdering(DocsDir);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSReport methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSReport::Decompile(CString& Dir, CStorage& Storage, CString& Prefix, CStorage& TypedTextStorage)
{
	CString RptDir(Dir);
	CString StorName;

	RptDir += "\\";
	RptDir += sID;
	CreateDirectory(RptDir);

	ExtractMetadata(RptDir);
	
	StorName.Format("%s%i", Prefix, ID);
	if( Storage.Open(StorName) )
	{
		ExtractWorkBook(RptDir, Storage);
		Storage.Close();
	}

	ExtractDescriptions(RptDir+"\\", TypedTextStorage, true);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSReportList methods  /////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSReportList::Decompile(CString& Dir, CStorage& Storage)
{
	if( nProps == 0 ) return;

	CNameTableRecord* nt_rec = NameTable.Find(sID);
	CStorage TypedTextStorage(Storage, "TypedText");
	CString ReportsDir = nt_rec->PrepareDirName(Dir);

	CreateDirectory(ReportsDir);

	if( Storage.Open(nt_rec->StorageName) )
	{
		CString ReportStorName = nt_rec->StorageName + "_Number";
		for( int i = 0; i < nProps; i++ )
		{
			CMMSReport* rpt = (CMMSReport*)Properties[i];
			rpt->Decompile(ReportsDir, Storage, ReportStorName, TypedTextStorage);
		}
		Storage.Close();
	}

	ExtractOrdering(ReportsDir);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSJournalister methods  //////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSJournalister::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString JournalDir = Dir;
	CMMSObject* Forms = GetProperty(CString("Form"));

	JournalDir += "\\";
	JournalDir += sID;
	CreateDirectory(JournalDir);

	ExtractMetadata(JournalDir);
	ExtractDescriptions(JournalDir+"\\", TypedTextStorage, true);

	ExtractListForms(Forms, JournalDir, Storage, nt_rec->StorageName);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSJournalisters methods  /////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSJournalisters::Decompile(CString& SrcDir, CStorage& Storage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage TypedTextStorage(Storage, "TypedText");
	CString JournalsDir = nt_rec->PrepareDirName(SrcDir);

	CreateDirectory(JournalsDir);

	Storage.Open(nt_rec->StorageName);
	for( int i = 0; i < nProps; i++ )
	{
		CMMSJournalister* pJournal = (CMMSJournalister*)Properties[i];
		pJournal->Decompile(JournalsDir, Storage, TypedTextStorage);
	}
	Storage.Close();

	ExtractOrdering(JournalsDir);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSCalcJournal methods  ///////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCalcJournal::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString JournalDir(Dir);
	CMMSObject* Forms = GetProperty(CString("Form"));

	JournalDir += "\\";
	JournalDir += sID;
	CreateDirectory(JournalDir);

	ExtractMetadata(JournalDir);
	ExtractDescriptions(JournalDir+"\\", TypedTextStorage, true);

	ExtractListForms(Forms, JournalDir, Storage, nt_rec->StorageName);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSCalcJournals methods  //////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCalcJournals::Decompile(CString& Dir, CStorage& Storage)
{
	if( nProps == 0 ) return;

	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString JournalsDir = nt_rec->PrepareDirName(Dir);
	CStorage TypedTextStorage(Storage, "TypedText");

	CreateDirectory(JournalsDir);

	Storage.Open(nt_rec->StorageName);
	for( int i = 0; i < nProps; i++ )
	{
		CMMSCalcJournal* pJournal = (CMMSCalcJournal*)Properties[i];
		pJournal->Decompile(JournalsDir, Storage, TypedTextStorage);
	}
	Storage.Close();

	ExtractOrdering(JournalsDir);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSCaclAlgorithm methods  /////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCaclAlgorithm::Decompile(CString& Dir, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec_stor = NameTable.Find(Type);
	CString AlgDir(Dir);

	AlgDir += "\\";
	AlgDir += sID;
	CreateDirectory(AlgDir);

	ExtractMetadata(AlgDir);

	if( TypedTextStorage.Open(nt_rec_stor->PrepareStorageName(ID)) )
	{
		CNameTableRecord* nt_rec = NameTable.Find(NT_CalcAlgorithm);
		TypedTextStorage.CopyToFile(nt_rec->StorageName, nt_rec->PrepareFileName(AlgDir));
		TypedTextStorage.Close();
	}

	ExtractDescriptions(AlgDir+"\\", TypedTextStorage, true);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSCaclAlgorithms methods  ////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCaclAlgorithms::Decompile(CString& Dir, CStorage& Storage)
{
	if( nProps == 0 ) return;


	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString AlgsDir = nt_rec->PrepareDirName(Dir);

	CreateDirectory(AlgsDir);

	if( Storage.Open(nt_rec->StorageName) )
	{
		for( int i = 0; i < nProps; i++ )
		{
			CMMSCaclAlgorithm* pAlg = (CMMSCaclAlgorithm*)Properties[i];
			pAlg->Decompile(AlgsDir, Storage);
		}
		Storage.Close();
	}

	ExtractOrdering(AlgsDir);
}

