// TaskHelp.cpp: implementation of the CTaskHelp class.
//////////////////////////////////////////////////////////////////////

#include "Task.h"
#include "CommonFunctions.h"
#include <iostream.h>


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


void CTaskHelp::ActionRu()
{
	Msg(0,"\n: gcomp.exe <>\n\n: \n");
	Msg(0,"  -h -   \n");
	Msg(0,"  -d -   1cv7.md   SRC\n");
	Msg(0,"  -c -   SRC   1cv7.md\n");
	Msg(0,"  --version -    GComp  \n");
	Msg(0,"\n"); /*------------------------*/
	Msg(0,"     \n");
	Msg(0,"  -q -  .   .\n");
	Msg(0,"  -v -   ,   .\n");
	Msg(0,"  -vv -   .\n");
	Msg(0,"  -F <>\n");
	Msg(0,"  -D <>\n");
	Msg(0,"  -DD <>\n");
	Msg(0,"  --external-report - ,      (.ert )\n");
	Msg(0,"  --meta-data - ,      (1cv7.md )\n");
	Msg(0,"  --no-profiles -     (),   Container.Profile\n");
	Msg(0,"  --no-empty-mxl -       \n");
	Msg(0,"  --truncate-mms -     gcomp   'Main MetaData Stream'  \n");
	Msg(0,"  --eng - GComp         (     beta)\n");
	Msg(0,"  --translit - GComp         (     beta)\n");
	Msg(0,"  --no-parce-dialog -   ,  .        ,    .");
	Msg(0,"		 --eng  --translit     .");
	Msg(0,"\n"); /*------------------------*/
	Msg(0," ,     .\n");
	Msg(0,"      :\n");
	Msg(0,"<>\\<>\n");
	Msg(0,",    -DD,     ,     -DD\n");
	Msg(0,"\n"); /*------------------------*/
	Msg(0,":\n");
	Msg(0," > gcomp -d\n");
	Msg(0,"  1cv7.md   SRC\n");
	Msg(0," > gcomp -d -F TestReport.ert -D Reports\n");
	Msg(0,"  TestReport.ert   Reports\\TestReport\n");
	Msg(0," > gcomp -d -F TestReport.ert\n");
	Msg(0,"  TestReport.ert   SRC\\TestReport\n");
	Msg(0," > gcomp -d --external-report\n");
	Msg(0,"  1cv7.md   SRC\\1cv7\n");
	Msg(0," > gcomp -c -F TestReport.ert\n");
	Msg(0,"  TestReport.ert   SRC\\TestReport\n");
	Msg(0," > gcomp -c -F TestReport.ert -DD TestReportSource\n");
	Msg(0,"  TestReport.ert   TestReportSource\n");
	Msg(0,"\n"); /*------------------------*/
	Msg(0," \"gcomp -h | more\",    , \n");
	Msg(0,"\"gcomp -h > gcomp_hlp.txt\"      .");
}

void CTaskHelp::ActionEn()
{
	cout << "\nUsage: gcomp.exe <Argument>\n\n" << "Arguments: \n";
	cout << "  -h - Show this help\n";
	cout << "  -d - Decompile 1cv7.md into SRC folder\n";
	cout << "  -c - Compile SRC folder into 1cv7.md\n";
	cout << "  --version - show current GComp version and exit\n";
	cout << "\n";/*------------------------*/
	cout << "You may use this optional parameters\n";
	cout << "  -q - Quiet mode. No messages in stdout at all.\n";
	cout << "  -v - Verbose gcomp job.\n";
	cout << "  -vv - Much more verbose gcomp job.\n";
	cout << "  -F <FileName>\n";
	cout << "  -D <Directory>\n";
	cout << "  -DD <Directory>\n";
	cout << "  --external-report - tell to gcomp, that the file is external report (.ert style)\n";
	cout << "  --meta-data - tell to gcomp, that the file is metadata (1cv7.md style)\n";
	cout << "  --no-profiles - gcomp will skip files (streams), named Container.Profile\n";
	cout << "  --no-empty-mxl - gcomp will throw away empty mxl patterns\n";
	cout << "  --truncate-mms - when compiling external reports gcomp will repalce original 'Main MetaData Stream' with empty copy\n";
	cout << "  --eng - GComp will be try to create folders and files with english names (beta state)\n";
	cout.flush();
	Msg(0,"  --translit - GComp will be try to create folders and files with translit names (beta state)\n");
	Msg(0,"		\'--eng\' and \'--translit\' options didn't check originality of result names.\n");
	Msg(0,"  --no-parce-dialog - unload dialogs as is. If absence - there is small filter for dialogs, cutting some unnecessary info.");
	cout << "\n";/*------------------------*/
	cout << "By default external reports treated in some special way.\n";
	cout << "When they extracted/compiled the destination/source directory formed as\n";
	cout << "<StartDirectory>\\<FileNameWithoutExtension>\n";
	cout << "But if you specify -DD parameter, directory name will be\n";
	cout << "leaved unchanged.\n";
	cout << "\n";/*------------------------*/
	cout << "For example:\n";
	cout << " > gcomp -d\n";
	cout << "will extract contents of 1cv7.md into directory SRC\n";
	cout << " > gcomp -d -F TestReport.ert -D Reports\n";
	cout << "will extract contents of TestReport.ert into directory Reports\\TestReport\n";
	cout << " > gcomp -d -F TestReport.ert\n";
	cout << "will extract contents of TestReport.ert into directory SRC\\TestReport\n";
	cout << " > gcomp -d --external-report\n";
	cout << "will extract contents of 1cv7.md into directory SRC\\1cv7\n";
	cout << " > gcomp -c -F TestReport.ert\n";
	cout << "will compile file TestReport.ert from directory SRC\\TestReport\n";
	cout << " > gcomp -c -F TestReport.ert -DD TestReportSource\n";
	cout << "will compile file TestReport.ert from directory TestReportSource\n";
	cout << "\n";/*------------------------*/
	cout << "Use \"gcomp -h | more\", for paging help message, or\n";
	cout << "\"gcomp -h > gcomp_hlp.txt\" for create help file";
}

void CTaskHelp::Action()
{
	if (CTaskParameters::Eng == TaskParameters.Language)
		ActionEn();
	else
		ActionRu();

}
