// Task.h: interface for the CTask class tree.
//
//////////////////////////////////////////////////////////////////////

#ifndef TASK_H
#define TASK_H

#include <stdio.h>
#include "Declarations.h"


class CTaskParameters
{
public:
	enum TaskTypes {
		compile = 1,
		decompile = 2,
		help = 3
	};

	enum CompoundTypes {
		by_extension = 0,
		external_report = 1,
		meta_data = 2
	};

	TaskTypes TaskType;
	CompoundTypes CompoundType;
	
	// -1 - supress all messagess (quiet mode)
	// 0 - errors only
	// 1 - real deeds, if any
	// 2 - all together, checks included.
	// (maybe enum?)
	int Verbose;


	CString CompoundFileName;
	CString DirectoryName;

	bool NoProfiles;
	bool NoEmptyMxl;
	bool TruncateMMS;
	bool NotParseForms;

	enum Languages { Rus, Eng, Translit	};
	Languages Language;
	
	bool ShowVersion;

public:
	inline CTaskParameters() 
	{
		TaskType = help;
		CompoundType = by_extension;
		Verbose = 0;
		NoProfiles = false;
		NoEmptyMxl = false;
		TruncateMMS = false;
		NotParseForms = false;
		Language = Rus;

		ShowVersion = false;
	};

	~CTaskParameters();

	void ParseCommandLine(int argc, TCHAR* argv[]);
};


//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
class CTask  
{
public:
	virtual void Action();

public:
	CTask(int argc, TCHAR* argv[]);
	CTask();
	virtual ~CTask();

private:
	CTask* thisTask;
};

//////////////////////////////////////
class CTaskHelp : public CTask  
{
private:
	void ActionRu();
	void ActionEn();

public:
	void Action();
	CTaskHelp() {};
};

//////////////////////////////////////
class CTaskCompile : public CTask  
{
public:
	void Action();
	CTaskCompile() {};
};

//////////////////////////////////////
class CTaskDecompile : public CTask  
{
public:
	void Action();
	CTaskDecompile() {};

private:
	void CTaskDecompile::ReadMMS(IStorage* pStorage);
	void FindDeletedStreams(CString& Path);
};


#endif
