
#ifndef MMS_H
#define MMS_H

#include <afxtempl.h>
#include "StreamInfo.h"


///////////////////////////////////////////////////////////////////////
///// Main Metadata Stream ////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////

typedef enum {
	MMS_Property,
	MMS_Object, //untyped object
	MMS_MainDataContDef,
	MMS_TaskItem,
	MMS_GenJrnlFldDef,
	MMS_DocSelRefObj,
	MMS_DocNumDef,
	MMS_Consts,
	MMS_SbCnts,
	MMS_SbCnt,
	MMS_Registers,
	MMS_Documents,
	MMS_Document,
	MMS_DocRefers, //  
	MMS_DocHeadFields,
	MMS_DocTableFields,
	MMS_Journalister,
	MMS_Journalisters,
	MMS_EnumList,
	MMS_Report,
	MMS_ReportList,
	MMS_CalcJournal,
	MMS_CalcJournals,
	MMS_Calendars,
	MMS_CalcAlgorithm,
	MMS_CalcAlgorithms,
	MMS_RecalcRules,
	MMS_CalcVars,
	MMS_Groups,
	MMS_DocumentStreams,
	MMS_DocumentStream,
	MMS_Buh,
	//        
	NT_MetadataPart,
	NT_Workbook,
	NT_FormModule,
	NT_DialogForm,
	NT_ListForm,
	NT_MoxelSheet,
	NT_TransModuleStor,
	NT_TransactModule,
	NT_GlobalModuleStor,
	NT_GlobalModule,
	NT_UserHelpStor,
	NT_UserHelp,
	NT_SubcontoFolder,
	NT_SubcontoListForm,
	NT_CalcAlgorithm,
	NT_AccForm,
	NT_OperForm,
	NT_AccListForm,
	NT_OperListForm,
	NT_ProvListForm,
	NT_GlobalData,
	NT_CommonMXL,
	NT_PictureGallery,
	NT_GUIDData,
	NT_TagStream,
	NT_UserInterface,
	NT_UserRights,
	NT_ObjectOrdering
} MMSObjectType;


//#include "Storage.h"
class CStorage; //we can not include storage.h, but we need only class CStorage declaration

class CMMSObject; //generic MMS object
typedef CMMSObject* PCMMSObject;
typedef CMMSObject& RCMMSObject;

class CMMSNodeList; //Untyped objects list


///////////////////////////////////////////////////////////
class CMMSObject
{
public:
	MMSObjectType Type;
	CString sID;
	int ID;
	int Order; // 

public:
	CMMSObject() {Type = MMS_Object; ID = 0; };
	CMMSObject(CString& sID, CString& ID);
	virtual ~CMMSObject();

	void DestroyObjects();

public:
	virtual int GetNProps() {return 0;};
	virtual CMMSObject* GetPropByNum(int i) {return NULL;};
	//     pList      
	virtual CMMSObject* GetProperty(int ID, bool recursive = false, CMMSNodeList* pList = NULL);
	virtual CMMSObject* GetProperty(CString& sID);

	virtual CMMSObject* AddProperty(CMMSObject* Property) {return NULL;};

	virtual CString HdrAsString();
	// true,        .      
	virtual bool PropsAsString(CString& dest, int Depth = 0);
	virtual CString AsString(int Depth = 0);

	virtual void Decompile(CString& Dir, CStorage& Storage) {};
	virtual void Compile(CStorage& Storage, CString& Dir) {};
};

////////////////////////////////////////////////////////////
class CMMSObjectWithProps : public CMMSObject
{
protected:
	CArray<PCMMSObject, PCMMSObject&> Properties;
	int nProps;

public:
	CMMSObjectWithProps() {nProps = 0;};
	CMMSObjectWithProps(CString& sID, CString& ID) :CMMSObject(sID, ID) {nProps = 0;};
	CMMSObjectWithProps(CString& sID, CString& ID, CMMSNodeList *pList);
	CMMSObjectWithProps(CMMSNodeList *pList);
	~CMMSObjectWithProps();

	void SetProperties(CMMSNodeList *pList);

	void SortByName();
	void SortByOrder();

public:
	int GetNProps() {return nProps;};
	CMMSObject* GetPropByNum(int i) {return Properties[i];};

	void ExtractMetadata(CString& DestDir, MMSObjectType Type);
	void ExtractMetadata(CString& DestDir);
	void ExtractMoxelPages(CString& DestDir, CStorage& WBStorage);
	void ExtractWorkBook(CString& DestDir, CStorage& Storage);
	void ExtractDescription(CString& DestDir, CStorage& TypedTextStorage);
	void ExtractListForms(CMMSObject* Forms, CString& Dir, CStorage& Storage, CString Prefix);
	void ExtractOrdering(CString& DestDir);

	bool ImportMoxelPages(CStorage& Storage, CString& SrcDir, CString& ContCont);
	bool ImportWorkBook(CStorage& Storage, CString& SrcDir);
	void ImportDescription(CStorage& TypedTextStorage, CString& SrcDir);
	bool ImportListForms(CMMSObject* Forms, CStorage& Storage, CString& SrcDir, CString Prefix);
	void ImportOrdering(CString& SrcDir);

	void ExtractStreamByType(CStorage& Storage, MMSObjectType Type, CString& Dir);
	bool ImportStreamByType(CStorage& Storage, MMSObjectType Type, CString& SrcDir);
};

////////////////////////////////////////////////////////////
//   ,   .   properties. (, ,   ..)
class CMMSBasicObject : public CMMSObjectWithProps
{
public:
	CString Comment;
	CString Synonym;

public:
	CMMSBasicObject(CString& sID, CString& ID, CString& Comment, CString& Synonym, CMMSNodeList *pList);
	//~CMMSBasicObject();

public:
	CString HdrAsString();

	virtual void Decompile(CString& BaseDir, CStorage& Storage, CStorage& TypedTextStorage);
};


////////////////////////////////////////////////////////////
class CMMS : public CMMSObjectWithProps
{
public:
	CMMS(CMMSNodeList *pList);

public:
	int GetNProps() {return nProps;};
	CMMSObject* GetPropByNum(int i) {return Properties[i];};
	CString AsString(int Depth = 0);

	void Decompile(CString& Dir, CStorage& Storage);
	void ExtractStorage(CString& Dir, CStorage& Storage, MMSObjectType Type, bool WithContainerCOntents);
	void ExtractCommonMXL(CString& Dir, CStorage& Storage);
	void ExtractDescriptions(CString& Dir, CStorage& Storage);

	void Compile(CStorage& Storage, CString& Dir);
	void ImportGlobalModule(CStorage& Storage, CString& Dir);
	void ImportCommonMXL(CStorage& Storage, CString& SrcDir);
	void ImportStorage(CStorage& Storage, CString& SrcDir, MMSObjectType Type);
	void ImportPictureGallery(CStorage& Storage, CString& Dir);
	void ImportUI(CStorage& Storage, CString& SrcDir);
	void ImportUR(CStorage& Storage, CString& SrcDir);
	void ImportDescriptions(CStorage& Storage, CString& SrcDir);
};

////////////////////////////////////////////////////////////
class CMMSMetadataPart: public CMMSObjectWithProps
{
public:
	CMMSMetadataPart(MMSObjectType Type) 
		{this->Type = Type;};

	CMMSMetadataPart(MMSObjectType Type, CString& sID, CMMSNodeList* pPropsList)
		:CMMSObjectWithProps(sID, CString(""), pPropsList) 
		{ this->Type = Type; };

public:
	void Decompile(CString& Dir, CStorage& Storage);
};

////////////////////////////////////////////////////////////
class CMMSDescr : public CMMSMetadataPart
{
public:
	int FirstAvailableID; //   
	int MD_ver;
	int UnknownID;

public:
	CMMSDescr() 
		:CMMSMetadataPart(MMS_MainDataContDef) {};
	CMMSDescr(CString& sID, CString& FirstAvailableID, CString& MD_ver, CString& UnknownID);

public:
	CString AsString(int Depth = 0);
	//void Decompile(CString& Dir, CStorage& Storage);
};

////////////////////////////////////////////////////////////
class CMMSSbCnt : public CMMSBasicObject
{
public:
	CMMSSbCnt(CString& sID, CString& ID, CString& Comment, CString& Synonym, CMMSNodeList *pList);

public:
	void Decompile(CString& BaseDir, CStorage& Storage, CStorage& TypedTextStorage, CStorage& SubFolderStorage, CStorage& SubListStorage);
	void Compile(CStorage& Storage, CString& Dir, CStorage& TypedTextStorage, CStorage& SubFolderStorage, CStorage& SubListStorage);
};

////////////////////////////////////////////////////////////
class CMMSSbCnts : public CMMSObjectWithProps
{
public:
	CMMSSbCnts(CString sID, CMMSNodeList* pDocList);

public:
	void Decompile(CString& BaseDir, CStorage& Storage);
	void Compile(CStorage& Storage, CString& Dir);
};


////////////////////////////////////////////////////////////
//  
class CMMSGenJrnlFldDef : public CMMSObjectWithProps
{
public:
	CMMSGenJrnlFldDef(CString sID, CMMSNodeList* pConstList)
		:CMMSObjectWithProps(sID, CString(""), pConstList) 
	{ Type = MMS_GenJrnlFldDef; };

public:
	void Decompile(CString& Dir, CStorage& Storage);
};

////////////////////////////////////////////////////////////
//    
class CMMSDocSelRefObj : public CMMSObjectWithProps
{
public:
	CMMSDocSelRefObj(CString sID, CMMSNodeList* pConstList)
		:CMMSObjectWithProps(sID, CString(""), pConstList) 
	{ Type = MMS_DocSelRefObj; };

public:
	void Decompile(CString& Dir, CStorage& Storage);
};

////////////////////////////////////////////////////////////
class CMMSDocNumDef : public CMMSObjectWithProps
{
public:
	CMMSDocNumDef(CString sID, CMMSNodeList* pConstList)
		:CMMSObjectWithProps(sID, CString(""), pConstList) 
	{ Type = MMS_DocNumDef; };

public:
	void Decompile(CString& Dir, CStorage& Storage);
};

////////////////////////////////////////////////////////////
class CMMSDocument : public CMMSBasicObject
{
public:
	CMMSDocument(CString& sID, CString& ID, CString& Comment, CString& Synonym, CMMSNodeList *pList)
	:CMMSBasicObject(sID, ID, Comment, Synonym, pList)
	{Type = MMS_Document;};

public:
	void Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage);
	void Compile(CStorage& Storage, CString& SrcDir, CStorage& TypedTextStorage);
};


////////////////////////////////////////////////////////////
class CMMSDocuments : public CMMSObjectWithProps
{
public:
	CMMSDocuments(CString sID, CMMSNodeList* pDocList);

public:
	void Decompile(CString& Dir, CStorage& Storage);
	void Compile(CStorage& Storage, CString& SrcDir);
};

///////////////////////////////////////////////////////////
class CMMSDocStream: public CMMSObject
{
public:
	CString Comment;
	CString Synonym;
	CString Param1;
	CString Param2;

	CMMSObject* Registers;
	CMMSObject* Documents;

public:
	CMMSDocStream(CString& sID, CString& ID, 
		CString& Comment, CString& Synonym, CString& Param1, CString& Param2,
		CMMSObject* Registers, CMMSObject* Documents);
	~CMMSDocStream();

public:
	CString AsString(int Depth = 0);
};


////////////////////////////////////////////////////////////
class CMMSReport : public CMMSBasicObject
{
public:
	CMMSReport(CString& sID, CString& ID, CString& Comment, CString& Synonym)
		:CMMSBasicObject(sID, ID, Comment, Synonym, NULL)
		{
			Type = MMS_Report;
		};

public:
	void Decompile(CString& Dir, CStorage& Storage, CString& SubStroragePrefix, CStorage& TypedTextStorage);
	void Compile(CStorage& Storage, CString& SrcDir, CString& SubStroragePrefix, CStorage& TypedTextStorage);
};

////////////////////////////////////////////////////////////
class CMMSReportList : public CMMSObjectWithProps
{
public:
	CMMSReportList(CString sID, CMMSNodeList* pRepList)
		:CMMSObjectWithProps(sID, CString(""), pRepList) 
	{ Type = MMS_ReportList; };

public:
	void Decompile(CString& Dir, CStorage& Storage);
	void Compile(CStorage& Storage, CString& SrcDir);
};

///////////////////////////////////////////////////////////
class CMMSJournalister: public CMMSBasicObject
{
public:
	CMMSJournalister(CString& sID, CString& ID, CString& Comment, CString& Synonym, CMMSNodeList* pList)
		:CMMSBasicObject(sID, ID, Comment, Synonym, pList)
		{
			Type = MMS_Journalister;
		};

public:
	void Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage);
	void Compile(CStorage& Storage, CString& SrcDir, CStorage& TypedTextStorage);
};

////////////////////////////////////////////////////////////
class CMMSJournalisters: public CMMSObjectWithProps
{
public:
	CMMSJournalisters(CString sID, CMMSNodeList* pRepList)
		:CMMSObjectWithProps(sID, CString(""), pRepList) 
	{ Type = MMS_Journalisters; };

public:
	void Decompile(CString& Dir, CStorage& Storage);
	void Compile(CStorage& Storage, CString& SrcDir);
};

///////////////////////////////////////////////////////////
class CMMSCalcJournal : public CMMSBasicObject
{
public:
	CMMSCalcJournal(CString& sID, CString& ID, CString& Comment, CString& Synonym, CMMSNodeList* pList)
		:CMMSBasicObject(sID, ID, Comment, Synonym, pList)
		{
			Type = MMS_CalcJournal;
		};

public:
	void Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage);
	void Compile(CStorage& Storage, CString& SrcDir, CStorage& TypedTextStorage);
};

////////////////////////////////////////////////////////////
class CMMSCalcJournals: public CMMSObjectWithProps
{
public:
	CMMSCalcJournals(CString sID, CMMSNodeList* pRepList)
		:CMMSObjectWithProps(sID, CString(""), pRepList) 
	{ Type = MMS_CalcJournals; };

public:
	void Decompile(CString& Dir, CStorage& Storage);
	void Compile(CStorage& Storage, CString& SrcDir);
};


////////////////////////////////////////////////////////////
class CMMSCaclAlgorithm : public CMMSBasicObject
{
public:
	CMMSCaclAlgorithm(CString& sID, CString& ID, CString& Comment, CString& Synonym, CMMSNodeList *pList)
		:CMMSBasicObject(sID, ID, Comment, Synonym, pList)
		{Type = MMS_CalcAlgorithm;};

public:
	void Decompile(CString& Dir, CStorage& TypedTextStorage);
	void Compile(CStorage& TypedTextStorage, CString& SrcDir);
};


////////////////////////////////////////////////////////////
class CMMSCaclAlgorithms : public CMMSObjectWithProps
{
public:
	CMMSCaclAlgorithms(CString sID, CMMSNodeList* pAlgList)
		:CMMSObjectWithProps(sID, CString(""), pAlgList)
		{Type = MMS_CalcAlgorithms;};

public:
	void Decompile(CString& Dir, CStorage& Storage);
	void Compile(CStorage& Storage, CString& SrcDir);
};


////////////////////////////////////////////////////////////
class CMMSBuh: public CMMSObjectWithProps
{
private:
	int BuhID; //       ID
	CMMSObject* AccListForms;
	CMMSObject* ProvListForms;
	CMMSObject* OperListForms;

public:
	CMMSBuh(CString sID, CMMSNodeList* pList);

public:
	void ExtractForm(CString& Dir, CStorage& Storage, MMSObjectType Type);
	void ExtractListForm(CString& Dir, CStorage& Storage, MMSObjectType Type, CMMSObject* ListForms);
	void Decompile(CString& Dir, CStorage& Storage);

	void ImportForm(CStorage& Storage, CString& SrcDir, MMSObjectType Type);
	void ImportListForm(CStorage& Storage, CString& SrcDir, MMSObjectType Type, CMMSObject* ListForms);
	void Compile(CStorage& Storage, CString& SrcDir);

private:
	int FindProp(CString& sID, CMMSObject* obj);
};


///////////////////////////////////////////////////////////
class CMMSNode : public CMMSObject
{
public:
	CMMSNodeList *Properties;

public:
	CMMSNode(CMMSNodeList* pList) {Type = MMS_Object; ID = 0; Properties = pList;};
	CMMSNode(MMSObjectType Type, CString& sID, CString& ID, CMMSNodeList* pList = NULL) 
		:CMMSObject(sID, ID) 
		{this->Type = Type; Properties = pList;};

	~CMMSNode();

public:
	void AddValue(CString& Value);
	void AddValue(CMMSObject *Node);

	int GetNProps();
	CMMSObject* GetPropByNum(int i);

	CString HdrAsString();
	bool PropsAsString(CString& dest, int Depth);
};


///////////////////////////////////////////////////////////
class CMMSNodeList : public CList<CMMSObject*, CMMSObject*&>
{
public:
	bool DestroyObjects;

public:
	CMMSNodeList() {DestroyObjects = true;};
	~CMMSNodeList();

public:
	void AddNode(CString& Value);
	void AddNode(CMMSObject* Node);
	void AddNode(CMMSNode* Node);
};



/////////////////////////////////////////////////////////
/////  Stack value representation for Bison parser  /////
/////////////////////////////////////////////////////////
class MMS_StackValue 
{
public:
	CString String;
	CMMSObject* pNode;
	CMMSNodeList* pList;

public:
	MMS_StackValue() { pNode = NULL; pList = NULL; };
};

void MMS_InitParser();
int MMS_parse(FILE *File, CMMSObject** ParserResult);


#endif //MMS_H