// Task.cpp: implementation of the CTask class.
//
//////////////////////////////////////////////////////////////////////

#include <iostream.h>
#include "Task.h"
#include "CommonFunctions.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

CTaskParameters TaskParameters;


//////////////////////////////////////////////////////////
//// class CTaskParameters  //////////////////////////////
//////////////////////////////////////////////////////////
CTaskParameters::~CTaskParameters()
{
}

void CTaskParameters::ParseCommandLine(int argc, TCHAR* argv[])
{
	TCHAR *DirName  = "SRC";
	TCHAR *FileName = "1cv7.md";
	bool PreserveDir = false;

	if (argc <= 1) //no arguments at all
	{
		TaskType = help;
		return;
	}

	for( int i=1; i<argc; i++ )
	{
		TCHAR *arg;

		arg = argv[i];
		if( 0 == strcmp("-h", arg) )
		{
			TaskType = help;
		}
		else if( 0 == strcmp("-c", arg) )
		{
			TaskType = compile;
		}
		else if( 0 == strcmp("-d", arg) )
		{
			TaskType = decompile;
		}
		else if( 0 == strcmp("-v", arg) )
		{
			Verbose = 1;
		}
		else if( 0 == strcmp("-vv", arg) )
		{
			Verbose = 2;
		}
		else if( 0 == strcmp("-q", arg) )
		{
			Verbose = -1;
		}
		else if( 0 == strcmp("-D", arg) )
		{
			arg = argv[++i];
			DirName = arg;
		}
		else if( 0 == strcmp("-DD", arg) )
		{
			arg = argv[++i];
			DirName = arg;
			PreserveDir = true;
		}
		else if( 0 == strcmp("-F", arg) )
		{
			arg = argv[++i];
			FileName = arg;
		}
		else if( 0 == strcmp("--external-report", arg) )
		{
			CompoundType = external_report;
		}
		else if( 0 == strcmp("--meta-data", arg) )
		{
			CompoundType = meta_data;
		}
		else if( 0 == strcmp("--no-profiles", arg) )
		{
			NoProfiles = true;
		}
		else if( 0 == strcmp("--truncate-mms", arg) )
		{
			TruncateMMS = true;
		}
		else
		{
			cout << "Invalid option '" << arg << "'\n";
			TaskType = help;
			return;
		}
	}

	//Copy file and dir names into class variables
	CompoundFileName = FileName;

	//Split file name on parts
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	_splitpath(FileName, NULL, NULL, fname, ext);

	//Try to determine file type by extension
	if( CompoundType == by_extension )
	{
		if( stricmp(ext, ".ert") == 0 )
			CompoundType = external_report;
		else
			CompoundType = meta_data;
	}

	//In case of external report add its name to directory. 
	//When directory specified explicitly leave its name unchanged
	if( (CompoundType == external_report) && !PreserveDir )
		DirectoryName.Format("%s\\%s", DirName, fname);
	else
		DirectoryName = DirName;

	//     ,         
	if( (CompoundType != external_report) ) TruncateMMS = false;
}


//////////////////////////////////////////////////////////
//// class CTask   ///////////////////////////////////////
//////////////////////////////////////////////////////////
CTask::CTask()
{
	thisTask = NULL;
}

CTask::CTask(int argc, TCHAR* argv[])
{
	thisTask = NULL;
	
	TaskParameters.ParseCommandLine(argc, argv);

	switch( TaskParameters.TaskType )
	{
		case CTaskParameters::help:
			thisTask = new CTaskHelp;
			break;
		case CTaskParameters::compile:
			thisTask = new CTaskCompile;
			break;
		case CTaskParameters::decompile:
			thisTask = new CTaskDecompile;
			break;
	}
}

CTask::~CTask()
{
	if( thisTask != NULL ) delete thisTask;
}

void CTask::Action()
{
	thisTask->Action();
}


char* CTask::MinimalMDS()
{
	return "{\r\n\
{\"MainDataContDef\",\"15\",\"10009\",\"7120\"},\r\n\
{\"TaskItem\",\r\n\
{\"1\",\"\",\"\",\"\",\"\",\"1\",\"0\",\"0\",\"1\",\"0\"}},\r\n\
{\"GenJrnlFldDef\"},\r\n\
{\"DocSelRefObj\"},\r\n\
{\"DocNumDef\"},\r\n\
{\"Consts\"},\r\n\
{\"SbCnts\"},\r\n\
{\"Registers\"},\r\n\
{\"Documents\"},\r\n\
{\"Journalisters\"},\r\n\
{\"EnumList\"},\r\n\
{\"ReportList\"},\r\n\
{\"CJ\"},\r\n\
{\"Calendars\",\r\n\
{\"HolidaysDef\",\r\n\
{\"11\",\"\",\"\",\"\"}}},\r\n\
{\"Algorithms\"},\r\n\
{\"RecalcRules\"},\r\n\
{\"CalcVars\"},\r\n\
{\"Groups\"},\r\n\
{\"Document Streams\"},\r\n\
{\"Buh\",\r\n\
{\"2\",\"\",\"\",\"\",\"0\",\"8\",\"8\",\"25\",\"0\",\"0\",\"25\",\"14\",\"2\",\"14\",\"2\",\"14\",\"2\",\"14\",\"3\",\"0\",\"0\",\"10\",\"10\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"1\",\"1\",\"1\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"1\",\"0\",\"1\",\"0\",\"0\",\"0\",\"0\",\"1\",\r\n\
{},\"1\",\"1\",\r\n\
{\"AccParams\"},\r\n\
{\"Plans\"},\r\n\
{\"ProvParams\"},\r\n\
{\"OperParams\"},\r\n\
{\"Form\"},\r\n\
{\"Form\"},\r\n\
{\"Form\"},\r\n\
{\"SbKind\"},\r\n\
{\"TypOpersDef\",\r\n\
{\"3\",\"\",\"\",\"\"}},\r\n\
{\"CorrProvsDef\",\r\n\
{\"4\",\"\",\"\",\"\"}},\r\n\
{\"ProvHardFldDef\",\r\n\
{\"5\",\"\",\"\",\"\",\"P\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"},\r\n\
{\"6\",\"\",\"\",\"\",\"U\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"}},\r\n\
{\"OperJournal\",\r\n\
{\"7\",\"\",\"\",\"\",\"-1\",\"0\",\"9\",\"9\",\"1\",\r\n\
{\"0\",\"\",\"\",\"\",\r\n\
{\"Refers\"}},\r\n\
{\"JournalFld\"},\r\n\
{\"Form\",\r\n\
{\"9\",\"\",\"\",\"\"}}}}}}}\r\n\
";
}


