
#include <io.h>
#include <locale.h>
#include "GComp.h"
#include "Declarations.h"
#include "CommonFunctions.h"
#include "MMS.h"
#include "Storage.h"
#include "NameTable.h"
#include "Ordering.h"

CGCompParameters TaskParameters;
CNameTable NameTable;


LPCSTR GComp_GetVersion()
{
	return "2.1.0.beta";
}

void InitializeNameTable()
{
	if (CGCompParameters::Eng == TaskParameters.Language)
		NameTable.EngConstructor();
	else
		NameTable.RusConstructor();
}

bool GComp_Decompile(CGCompParameters* Parameters)
{
	TaskParameters = *Parameters;
	char* locale = setlocale( LC_ALL, ".ACP");
	InitializeNameTable();

	CMMS* MMS = NULL;
	CStorage Storage;
	Storage.OpenCompound(TaskParameters.CompoundFileName);
	CStorage TypedTextStorage(Storage, "TypedText");

	if( Storage.GetStorage() == NULL || TypedTextStorage.GetStorage() == NULL )
		return false;
	
	CoInitialize(NULL); //need it for unzip modules

	CNameTableRecord* nt_rec = NameTable.Find(NT_MainMetadataStream);
	if( CGCompParameters::external_report == TaskParameters.CompoundType )
	{
		MMS = (CMMS*)Storage.ParseStream(nt_rec->StorageName, false);
	}
	else
	{
		Storage.Open(CString("Metadata"));
		MMS = (CMMS*)Storage.ParseStream(nt_rec->StorageName, false);
		Storage.Close();
	}

	if( MMS != NULL )
	{
		CreateDirectory(TaskParameters.DirectoryName); //create directory for decompyle to

		if( TaskParameters.SaveVersion )
		{
			CString Version = GComp_GetVersion();
			CString FName = TaskParameters.DirectoryName + "\\gcomp.ver";
			Storage.CopyStringToFile(Version, FName);
		}

		MMS->Decompile(TaskParameters.DirectoryName, Storage, TypedTextStorage);
		delete MMS;
		Storage.PruneDirectory(TaskParameters.DirectoryName);
	}

	CoUninitialize(); //need it for unzip modules

	if( MMS == NULL )
		return false;
	else
		return true;
}

///////////////////////////////////////////////////////////////////////
//////  Compilation functions  ////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
FILE* AssembleMMS();
extern int MMS_debug;

bool GComp_Compile(CGCompParameters* Parameters)
{
	TaskParameters = *Parameters;
	char* locale = setlocale( LC_ALL, ".ACP");
	InitializeNameTable();

	if( !DirectoryExist(TaskParameters.DirectoryName) )
	{
		Msg(0, "ERR: Source directory '%s' not exist\n", TaskParameters.DirectoryName);
		return false;
	}
	CStorage Storage;
	if( !Storage.CreateCompound(TaskParameters.CompoundFileName) )
		return false;

	FILE *mmsFile = AssembleMMS();
	CMMSObject* MMSObject;
	rewind(mmsFile);
	MMS_InitParser(TaskParameters.DirectoryName+"\\MainMetadataStream");
	if( TaskParameters.Verbose >= 3) MMS_debug = 1;
	int RetCode = MMS_parse(mmsFile, &MMSObject);
	fclose(mmsFile);
	if( MMSObject == NULL )
		return false;

	CoInitialize(NULL);
	CStorage TypedTextStorage(Storage);
	if( TaskParameters.CompoundType != CGCompParameters::external_report )
		TypedTextStorage.Create(CString("TypedText"));
	MMSObject->Compile(Storage, TypedTextStorage, TaskParameters.DirectoryName);
	CoUninitialize();

	delete MMSObject;

	return true;
}

