
#ifndef GComp_H
#define GComp_H

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
//#include <windows.h>

#include <afx.h>
#include <afxtempl.h>

// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the GCOMPDLL_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// GCOMPDLL_API functions as being imported from a DLL, wheras this DLL sees symbols
// defined with this macro as being exported.
#ifdef GCOMPDLL_EXPORTS
#define GCOMPDLL_API __declspec(dllexport)
#else
#define GCOMPDLL_API __declspec(dllimport)
#endif



class CGCompParameters
{
public:
	enum CompoundTypes {
		by_extension = 0,
		external_report = 1,
		meta_data = 2
	};


	CompoundTypes CompoundType;
	
	// -1 - supress all messagess (quiet mode)
	// 0 - errors only
	// 1 - real deeds, if any
	// 2 - all together, checks included.
	// (maybe enum?)
	int Verbose;


	CString CompoundFileName;
	CString DirectoryName;

	bool NoProfiles;
	bool NoEmptyMxl;
	bool TruncateMMS;
	bool NotParseForms;
	bool SaveVersion; //save gcomp's version into file gcomp.ver

	enum Languages { Rus, Eng, Translit	};
	Languages Language;

public:
	inline CGCompParameters() 
	{
		CompoundType = by_extension;
		Verbose = 0;
		NoProfiles = false;
		NoEmptyMxl = false;
		TruncateMMS = false;
		NotParseForms = false;
		Language = Rus;
		SaveVersion = true;
	};
};

GCOMPDLL_API LPCSTR GComp_GetVersion();

GCOMPDLL_API bool GComp_Decompile(CGCompParameters* Parameters);
GCOMPDLL_API bool GComp_Compile(CGCompParameters* Parameters);

#endif