
#include "Strings.h"

char* trim(char* str)
{
	unsigned char* ptr = (unsigned char*)str;
	while( isspace(*ptr) && *ptr != '\0' ) ptr++;
	if( *ptr != '\0' )
	{
		unsigned char* end = ptr + strlen((char*)ptr) - 1;
		while( *end == '\r' || *end == '\n' ) *end-- = '\0'; //  \r\n
		//while( isspace(*end) && *end != '\0' ) *end-- = '\0'; //  
	}
	return (char*)ptr;
}

void str_repeate(CString& dest, CString src, int count)
{
	while( count > 0 )
	{
		dest += src;
		count--;
	}
}


//      "\n",   "\" -> "\\"
//     -        , 
// inplace   .
void quote_linefeeds(CString& str)
{
	str.Replace("\\", "\\\\");
	str.Replace("\r\n", "\\n");
}
// 
void unquote_linefeeds(CString& str)
{
	int len = str.GetLength();
	
	for( int i = 0; i < len; i++ )
	{
		if( str[i] != '\\' ) continue;
		switch( str[i+1] )
		{
		case 'n':
			str.SetAt(i++,  '\r');
			str.SetAt(i,  '\n');
			break;
		case '\\':
			str.Delete(i);
			len--;
			break;
		}
	}
}


/*////////////////////////////////////////////////////////////////////////////////
   ""    . ,   
   
 <>: []
////////////////////////////////////////////////////////////////////////////////*/

void add_offset(CString& dest, int level)
{
	while( level-- > 0 ) dest += "\t";
}

void add_parameter(CString& dest, int level, const char* id, const char* value, const char* default_value, bool force)
{
	if( !force )
	{
		if( value == default_value ) return;
		if( value == NULL ) return;
		if( default_value == NULL && value[0] == '\0' ) return;
		if( default_value != NULL && strcmp(value, default_value) == 0) return;
	}

	add_offset(dest, level);
	dest += id;
	dest += ": ";
	dest += value;
	dest += "\r\n";
}

void add_parameter(CString& dest, int level, const char* id, int value, int default_value)
{
	if( value == default_value ) return;

	char str[64];
	sprintf(str, "%i", value);
	add_parameter(dest, level, id, str, "");
}

void add_parameter(CString& dest, int level, const char* id, unsigned int value, unsigned int default_value)
{
	if( value == default_value ) return;

	char str[64];
	sprintf(str, "0x%x", value);
	add_parameter(dest, level, id, str, "");
}

void add_parameter(CString& dest, int level, const char* id, bool value, bool default_value)
{
	if( value == default_value ) return;

	if( value )
		add_parameter(dest, level, id, "", "");
	else
		add_parameter(dest, level, id, "", "");
}

void add_parameter(CString& dest, int level, const char* id, double value, double default_value)
{
	if( value == default_value ) return;

	char str[64];
	sprintf(str, "%g", value);
	add_parameter(dest, level, id, str, "");
}



/*/////////////////////////////////////////////////////////////////////
	    ,  ,    1
	    ;   
/////////////////////////////////////////////////////////////////////*/

void add_quoted(CString& dest, const char* value, bool add_comma)
{
	if( add_comma )
		dest += ",\"";
	else
		dest += "\"";
	dest += value;
	dest += "\"";
}

void add_quoted(CString& dest, int value, bool add_comma)
{
	char str[64];
	sprintf(str, "%i", value);
	add_quoted(dest, str, add_comma);
}
void add_quoted(CString& dest, unsigned int value, bool add_comma)
{
	char str[64];
	sprintf(str, "%u", value);
	add_quoted(dest, str, add_comma);
}
void add_quoted(CString& dest, bool value, bool add_comma)
{
	if( value )
		add_quoted(dest, "1", add_comma);
	else
		add_quoted(dest, "0", add_comma);
}
void add_quoted(CString& dest, double value, bool add_comma)
{
	char str[64];
	sprintf(str, "%g", value);
	add_quoted(dest, str, add_comma);
}

