// TaskHelp.cpp: implementation of the CTaskHelp class.
//////////////////////////////////////////////////////////////////////

#include "Task.h"
#include "CommonFunctions.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


void CTask::HelpRu()
{
	Msg(0,"\n: gcomp.exe <>\n\n: \n");
	Msg(0,"  -h -   \n");
	Msg(0,"  -d -   1cv7.md   SRC\n");
	Msg(0,"  -c -   SRC   1cv7.md\n");
	Msg(0,"  --version -    GComp  \n");
	Msg(0,"\n"); /*------------------------*/
	Msg(0,"     \n");
	Msg(0,"  -q -  .   .\n");
	Msg(0,"  -v -   ,   .\n");
	Msg(0,"  -vv -   .\n");
	Msg(0,"  -F <>\n");
	Msg(0,"  -D <>\n");
	Msg(0,"  -DD <>\n");
	Msg(0,"  --external-report - ,      (.ert )\n");
	Msg(0,"  --meta-data - ,      (1cv7.md )\n");
	Msg(0,"  --no-profiles -     (),   Container.Profile\n");
	Msg(0,"  --no-empty-mxl -       \n");
	Msg(0,"  --truncate-mms -     gcomp   'Main MetaData Stream'  \n");
	Msg(0,"  --eng - GComp         (     beta)\n");
	Msg(0,"  --translit - GComp         (     beta)\n");
	Msg(0,"  --no-parse-dialog -   ,  .        ,    .");
	Msg(0,"  --no-version -       gcomp.ver     gcomp.\n");
	Msg(0,"		 --eng  --translit     .");
	Msg(0,"\n"); /*------------------------*/
	Msg(0," ,     .\n");
	Msg(0,"      :\n");
	Msg(0,"<>\\<>\n");
	Msg(0,",    -DD,     ,     -DD\n");
	Msg(0,"\n"); /*------------------------*/
	Msg(0,":\n");
	Msg(0," > gcomp -d\n");
	Msg(0,"  1cv7.md   SRC\n");
	Msg(0," > gcomp -d -D C:\\Papka\n");
	Msg(0,"  1cv7.md   C:\\Papka\n");
	Msg(0," > gcomp -d -F TestReport.ert -D Reports\n");
	Msg(0,"  TestReport.ert   Reports\\TestReport\n");
	Msg(0," > gcomp -d -F TestReport.ert\n");
	Msg(0,"  TestReport.ert   SRC\\TestReport\n");
	Msg(0," > gcomp -d --external-report\n");
	Msg(0,"  1cv7.md   SRC\\1cv7\n");
	Msg(0," > gcomp -c -F TestReport.ert\n");
	Msg(0,"  TestReport.ert   SRC\\TestReport\n");
	Msg(0," > gcomp -c -F TestReport.ert -DD TestReportSource\n");
	Msg(0,"  TestReport.ert   TestReportSource\n");
	Msg(0,"\n"); /*------------------------*/
	Msg(0,":        !!!\n");
	Msg(0," !!!\n");
	Msg(0,"\n");/*------------------------*/
	Msg(0," \"gcomp -h | more\",    , \n");
	Msg(0,"\"gcomp -h > gcomp_hlp.txt\"      .");
}

void CTask::HelpEn()
{
	Msg(0,"\nUsage: gcomp.exe <Argument>\n\n");
	Msg(0,"Arguments: \n");
	Msg(0,"  -h - Show this help\n");
	Msg(0,"  -d - Decompile 1cv7.md into SRC folder\n");
	Msg(0,"  -c - Compile SRC folder into 1cv7.md\n");
	Msg(0,"  --version - show current GComp version and exit\n");
	Msg(0,"\n");/*------------------------*/
	Msg(0,"You may use this optional parameters\n");
	Msg(0,"  -q - Quiet mode. No messages in stdout at all.\n");
	Msg(0,"  -v - Verbose gcomp job.\n");
	Msg(0,"  -vv - Much more verbose gcomp job.\n");
	Msg(0,"  -F <FileName>\n");
	Msg(0,"  -D <Directory>\n");
	Msg(0,"  -DD <Directory>\n");
	Msg(0,"  --external-report - tell to gcomp, that the file is external report (.ert style)\n");
	Msg(0,"  --meta-data - tell to gcomp, that the file is metadata (1cv7.md style)\n");
	Msg(0,"  --no-profiles - gcomp will skip files (streams), named Container.Profile\n");
	Msg(0,"  --no-empty-mxl - gcomp will throw away empty mxl patterns\n");
	Msg(0,"  --truncate-mms - when compiling external reports gcomp will repalce original 'Main MetaData Stream' with empty copy\n");
	Msg(0,"  --eng - GComp will be try to create folders and files with english names (beta state)\n");
	Msg(0,"  --translit - GComp will be try to create folders and files with translit names (beta state)\n");
	Msg(0,"		\'--eng\' and \'--translit\' options didn't check originality of result names.\n");
	Msg(0,"  --no-parse-dialog - unload dialogs as is. If absence - there is small filter for dialogs, cutting some unnecessary info.");
	Msg(0,"  --no-version - file gcomp.ver (info about version of gcomp) will not create on decompile.\n");
	Msg(0,"\n");/*------------------------*/
	Msg(0,"By default external reports treated in some special way.\n");
	Msg(0,"When they extracted/compiled the destination/source directory formed as\n");
	Msg(0,"<StartDirectory>\\<FileNameWithoutExtension>\n");
	Msg(0,"But if you specify -DD parameter, directory name will be\n");
	Msg(0,"leaved unchanged.\n");
	Msg(0,"\n");/*------------------------*/
	Msg(0,"For example:\n");
	Msg(0," > gcomp -d\n");
	Msg(0,"will extract contents of 1cv7.md into directory SRC\n");
	Msg(0," > gcomp -d -D C:\\Papka\n");
	Msg(0,"will extract contents of 1cv7.md into directory C:\\Papka\n");
	Msg(0," > gcomp -d -F TestReport.ert -D Reports\n");
	Msg(0,"will extract contents of TestReport.ert into directory Reports\\TestReport\n");
	Msg(0," > gcomp -d -F TestReport.ert\n");
	Msg(0,"will extract contents of TestReport.ert into directory SRC\\TestReport\n");
	Msg(0," > gcomp -d --external-report\n");
	Msg(0,"will extract contents of 1cv7.md into directory SRC\\1cv7\n");
	Msg(0," > gcomp -c -F TestReport.ert\n");
	Msg(0,"will compile file TestReport.ert from directory SRC\\TestReport\n");
	Msg(0," > gcomp -c -F TestReport.ert -DD TestReportSource\n");
	Msg(0,"will compile file TestReport.ert from directory TestReportSource\n");
	Msg(0,"\n");/*------------------------*/
	Msg(0,"Warning: decompiling into not empty directory may cause data loss!!!\n");
	Msg(0,"Be carefull!!!\n");
	Msg(0,"\n");/*------------------------*/
	Msg(0,"Use \"gcomp -h | more\", for paging help message, or\n");
	Msg(0,"\"gcomp -h > gcomp_hlp.txt\" for create help file");
}

void CTask::Help()
{
	if (CTaskParameters::Eng == TaskParameters.Language)
		HelpEn();
	else
		HelpRu();

}
