unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, ToolWin, XPMan, ShellAPI, FileCtrl,
  Registry, Buttons, ImgList, Menus, ShellCtrls;

type
  TFormManage = class(TForm)
    PageControl2: TPageControl;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    Edit_path_place: TLabeledEdit;
    Edit_parse_place: TLabeledEdit;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    NoEmptyMxl: TCheckBox;
    NoProfiles: TCheckBox;
    btn_decompile: TButton;
    MsgVariant: TRadioGroup;
    NoParceDialog: TCheckBox;
    TabSheet2: TTabSheet;
    TruncateMms: TCheckBox;
    btn_compile: TButton;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    OpenDialog1: TOpenDialog;
    Edit_WinRar_path: TLabeledEdit;
    Edit_gcomp_place: TLabeledEdit;
    ImageList1: TImageList;
    btnSaveFile: TBitBtn;
    btnSaveDecompile: TBitBtn;
    SaveOptions: TCheckBox;
    btnChoiceFile: TBitBtn;
    btnDBFromReestr: TBitBtn;
    btn_choice_parse_place: TBitBtn;
    btn_choice_gcomp_place: TBitBtn;
    btn_Choice_WinRar: TBitBtn;
    FolderNames: TRadioGroup;
    Edit1: TEdit;
    btnSaveBat: TBitBtn;
    Button1: TButton;
    SaveDialog1: TSaveDialog;
    btnSave1CTitle: TBitBtn;
    procedure btn_choice_gcomp_placeClick(Sender: TObject);
    procedure btn_decompileClick(Sender: TObject);
    procedure btn_compileClick(Sender: TObject);
    procedure btn_choice_parse_placeClick(Sender: TObject);
    procedure btn_Choice_WinRarClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure btnSaveFileClick(Sender: TObject);
    procedure btnSaveDecompileClick(Sender: TObject);
    procedure btnDBFromReestrClick(Sender: TObject);
    procedure btnChoiceFileClick(Sender: TObject);
    procedure ToolButton1Click(Sender: TObject);
    function _GetStringDo():String ;
    procedure MsgVariantClick(Sender: TObject);
    procedure NoEmptyMxlClick(Sender: TObject);
    procedure NoProfilesClick(Sender: TObject);
    procedure FolderNamesClick(Sender: TObject);
    procedure NoParceDialogClick(Sender: TObject);
    procedure Edit_gcomp_placeChange(Sender: TObject);
    procedure Edit_WinRar_pathChange(Sender: TObject);
    procedure SaveOptionsClick(Sender: TObject);
    procedure Edit_path_placeChange(Sender: TObject);
    procedure Edit_parse_placeChange(Sender: TObject);
    procedure TruncateMmsClick(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure btnSaveBatClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure btnSave1CTitleClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormManage: TFormManage;

implementation

uses Unit2, Unit3, Unit5, Unit4;

{$R *.dfm}

procedure TFormManage.btn_choice_gcomp_placeClick(Sender: TObject);
begin
  if OpenDialog1.Execute then begin
    Edit_gcomp_place.Text := OpenDialog1.FileName;
  end;
  _GetStringDo()
end;

procedure TFormManage.btn_decompileClick(Sender: TObject);
var
  vPathExec : String;
begin
  vPathExec := '"' + Trim(Edit_gcomp_place.Text) + '" -d ';
  case MsgVariant.ItemIndex of
    1: vPathExec := vPathExec + '-v ';
    2: vPathExec := vPathExec + '-vv ';
  end;

  if NoEmptyMxl.Checked then vPathExec := vPathExec + '--no-empty-mxl ';
  if NoProfiles.Checked then vPathExec := vPathExec + '--no-profiles ';
  if NoParceDialog.Checked then vPathExec := vPathExec + '--no-parse-dialog ';

  case FolderNames.ItemIndex of
    1: vPathExec := vPathExec + '--translit ';
    2: vPathExec := vPathExec + '--eng ';
  end;

  vPathExec := vPathExec + '-F "' + Trim(Edit_path_place.Text) + '"';
  vPathExec := vPathExec + ' -D "' + Trim(Edit_parse_place.Text) + '"';
  WinExec(PChar(Trim(vPathExec)),1);
  Edit1.Text := vPathExec;
  ShowMessage('  ');
end;

procedure TFormManage.btn_compileClick(Sender: TObject);
var
  vPathExec : String;
begin

  vPathExec := '"' + Trim(Edit_gcomp_place.Text) + '" -c ';
  if TruncateMms.Checked then vPathExec := vPathExec + '--truncate-mms ';

  vPathExec := vPathExec + '-F "' + Trim(Edit_path_place.Text) + '"';
  vPathExec := vPathExec + ' -DD "' + Trim(Edit_parse_place.Text) + '"';
  WinExec(PChar(Trim(vPathExec)),1);
  Edit1.Text := vPathExec;
  ShowMessage('  ');
end;

procedure TFormManage.btn_choice_parse_placeClick(Sender: TObject);
var
  MyNewDir : String;
begin
  MyNewDir := Edit_parse_place.Text;
  SelectDirectory(' ','',MyNewDir);
  Edit_parse_place.Text := MyNewDir;
  _GetStringDo()
end;

procedure TFormManage.btn_Choice_WinRarClick(Sender: TObject);
begin
  if OpenDialog1.Execute then begin
    Edit_WinRar_path.Text := OpenDialog1.FileName;
  end;
  _GetStringDo()
end;

procedure TFormManage.FormClose(Sender: TObject; var Action: TCloseAction);
var
  Reg : TRegistry;
begin
  Reg := TRegistry.Create;
  Reg.RootKey := HKEY_CURRENT_USER;
  Reg.OpenKey('SOFTWARE\PhoenixSoft\VisualGcomp\',true);
  Reg.WriteString('Edit_gcomp_place',Edit_gcomp_place.Text);
  Reg.WriteString('Edit_WinRar_path',Edit_WinRar_path.Text);
  Reg.WriteBool('SaveOptions', SaveOptions.Checked);

  if SaveOptions.Checked then begin
    Reg.WriteString('Edit_path_place',Edit_path_place.Text);
    Reg.WriteString('Edit_parse_place',Edit_parse_place.Text);
    Reg.WriteInteger('MsgVariant',MsgVariant.ItemIndex);
    Reg.WriteBool('NoEmptyMxl', NoEmptyMxl.Checked);
    Reg.WriteBool('NoProfiles', NoProfiles.Checked);
    Reg.WriteBool('NoParceDialog', NoParceDialog.Checked);
    Reg.WriteInteger('FolderNames',FolderNames.ItemIndex);
    Reg.WriteBool('TruncateMms', TruncateMms.Checked);
  end;
  Reg.CloseKey;
  Reg.Free;
end;

procedure TFormManage.FormCreate(Sender: TObject);
var
  Reg : TRegistry;
begin
  Reg := TRegistry.Create;
  Reg.RootKey := HKEY_CURRENT_USER;
  Reg.OpenKey('SOFTWARE\PhoenixSoft\VisualGcomp\',true);
  try
    Edit_gcomp_place.Text := Reg.ReadString('Edit_gcomp_place');
    Edit_WinRar_path.Text := Reg.ReadString('Edit_WinRar_path');
    SaveOptions.Checked := Reg.ReadBool('SaveOptions');
  except
  end;

  if SaveOptions.Checked then begin
    Try
      Edit_path_place.Text := Reg.ReadString('Edit_path_place');
      Edit_parse_place.Text := Reg.ReadString('Edit_parse_place');
      MsgVariant.ItemIndex := Reg.ReadInteger('MsgVariant');
      NoEmptyMxl.Checked := Reg.ReadBool('NoEmptyMxl');
      NoProfiles.Checked := Reg.ReadBool('NoProfiles');
      NoParceDialog.Checked := Reg.ReadBool('NoParceDialog');
      FolderNames.ItemIndex := Reg.ReadInteger('FolderNames');
      TruncateMms.Checked := Reg.ReadBool('TruncateMms');
    except
    end
  end
  else begin
    MsgVariant.ItemIndex := 2;
    FolderNames.ItemIndex := 0;
  end;

  Reg.CloseKey;
  Reg.Free;

end;

procedure TFormManage.btnSaveFileClick(Sender: TObject);
begin
  with TFormArc.Create(nil) do begin
    EditArcPath.Text := Edit_path_place.Text;
    ArcObj := Edit_path_place.Text;
    ShowModal;
    Free;
  end;
end;

procedure TFormManage.btnSaveDecompileClick(Sender: TObject);
begin
  with TFormArc.Create(nil) do begin
    EditArcPath.Text := Edit_parse_place.Text;
    ArcObj := Edit_parse_place.Text;
    ShowModal;
    Free;
  end;
end;

procedure TFormManage.btnDBFromReestrClick(Sender: TObject);
begin
  with TFormChoiceDB.Create(nil) do begin
    ShowModal;
    Free;
  end;
  _GetStringDo()
end;

procedure TFormManage.btnChoiceFileClick(Sender: TObject);
begin
  OpenDialog1.InitialDir := ExtractFileDir(Edit_path_place.Text);
  if OpenDialog1.Execute then begin
    Edit_path_place.Text := OpenDialog1.FileName;
  end;
  _GetStringDo()
end;

procedure TFormManage.ToolButton1Click(Sender: TObject);
begin
  with TformAbout.Create(nil) do begin
    ShowModal;
    Free;
  end;
end;

function TFormManage._GetStringDo():String ;
var
  vPathExec : String;
begin
  if PageControl1.ActivePage = TabSheet1 then begin
    vPathExec := '"' + Trim(Edit_gcomp_place.Text) + '" -d ';
    case MsgVariant.ItemIndex of
      1: vPathExec := vPathExec + '-v ';
      2: vPathExec := vPathExec + '-vv ';
    end;

  if NoEmptyMxl.Checked then vPathExec := vPathExec + '--no-empty-mxl ';
  if NoProfiles.Checked then vPathExec := vPathExec + '--no-profiles ';
  if NoParceDialog.Checked then vPathExec := vPathExec + '--no-parse-dialog ';

  case FolderNames.ItemIndex of
    1: vPathExec := vPathExec + '--translit ';
    2: vPathExec := vPathExec + '--eng ';
  end;

  vPathExec := vPathExec + '-F "' + Trim(Edit_path_place.Text) + '"';
  vPathExec := vPathExec + ' -D "' + Trim(Edit_parse_place.Text) + '"';
  end;
  if PageControl1.ActivePage = TabSheet2 then begin

    vPathExec := '"' + Trim(Edit_gcomp_place.Text) + '" -c ';
    if TruncateMms.Checked then vPathExec := vPathExec + '--truncate-mms ';

    vPathExec := vPathExec + '-F "' + Trim(Edit_path_place.Text) + '"';
    vPathExec := vPathExec + ' -DD "' + Trim(Edit_parse_place.Text) + '"';
  end;

  Edit1.Text := vPathExec;

end;

procedure TFormManage.MsgVariantClick(Sender: TObject);
begin
  _GetStringDo()
end;

procedure TFormManage.NoEmptyMxlClick(Sender: TObject);
begin
_GetStringDo()
end;

procedure TFormManage.NoProfilesClick(Sender: TObject);
begin
_GetStringDo()
end;

procedure TFormManage.FolderNamesClick(Sender: TObject);
begin
_GetStringDo()
end;

procedure TFormManage.NoParceDialogClick(Sender: TObject);
begin
_GetStringDo()
end;

procedure TFormManage.Edit_gcomp_placeChange(Sender: TObject);
begin
_GetStringDo()
end;

procedure TFormManage.Edit_WinRar_pathChange(Sender: TObject);
begin
_GetStringDo()
end;

procedure TFormManage.SaveOptionsClick(Sender: TObject);
begin
_GetStringDo()
end;

procedure TFormManage.Edit_path_placeChange(Sender: TObject);
begin
_GetStringDo()
end;

procedure TFormManage.Edit_parse_placeChange(Sender: TObject);
begin
_GetStringDo()
end;

procedure TFormManage.TruncateMmsClick(Sender: TObject);
begin
_GetStringDo()
end;

procedure TFormManage.PageControl1Change(Sender: TObject);
begin
_GetStringDo()
end;

procedure TFormManage.btnSaveBatClick(Sender: TObject);
var
  F: TextFile;
begin
  SaveDialog1.DefaultExt := 'bat';
  SaveDialog1.FileName := 'gcomp_';
  if SaveDialog1.Execute then begin
    AssignFile(F, SaveDialog1.FileName);
    Rewrite(F);
    Writeln(F, edit1.Text);
    CloseFile(F);
  end;
end;

//
procedure TFormManage.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure TFormManage.btnSave1CTitleClick(Sender: TObject);
var
  Reg: TRegistry;
  SomeValues: TStringList;
  iCount, i, vHave, Change : Integer;
  vName, vPath : String;
  NameDB : String;
begin
  NameDB := InputBox(' ','     ','');
  if NameDB <> '' then begin
    Try
      Reg := TRegistry.Create;
      SomeValues := TStringList.Create;
      vHave := 0;
      Reg.RootKey := HKEY_CURRENT_USER;
      if Reg.OpenKey('Software\1C\1Cv7\7.7\Titles', False) then begin
        Reg.GetValueNames(SomeValues);
        iCount := SomeValues.Count;
        if iCount > 0 then begin
          for i := 0 to iCount - 1 do begin
            vName := Reg.ReadString(SomeValues.Strings[i]);
            vPath := SomeValues.Strings[i];
            if vName = NameDB then begin
              ShowMessage('     ');
              vHave := 1;
              Break;
            end; // if
            if vPath = ExtractFileDir(Edit_path_place.Text) + '\' then begin
              ShowMessage('     ');
              vHave := 1;
              Break;
            end; // if
          end; // for
          if vHave = 0 then begin
            Reg.WriteString(ExtractFileDir(Edit_path_place.Text) + '\',NameDB);
          end; // if
        end; // if
      end; // if
    finally
      Reg.Free;
      SomeValues.Free;
    end;
  end; // if 1
end;

end.
