
#include <sys/stat.h>
#include <direct.h>
#include <errno.h>

#include "Declarations.h"
#include "CommonFunctions.h"
#include "DLL\GComp.h"

bool IsValidFileName(CString& String)
{
	int len = String.GetLength();
	for( int i = 0; i < len; i++ )
	{
		int c = (unsigned char)String[i];
		if( !__iscsym(c) ) return false;
	}

	return true;
}

bool FileExist(LPCSTR FileName)
{
	struct _stat stat;

	if( _stat(FileName, &stat) == -1 ) return false;
	if( (stat.st_mode & _S_IFREG) != 0 ) return true;
	//FName - is directory. What we have to do?
	return false;
}

long GetFileSize(CString& FileName)
{
	struct _stat stat;
	_stat(FileName, &stat);
	return stat.st_size;
}

bool DirectoryExist(LPCSTR DirName)
{
	struct _stat stat;
	if( _stat(DirName, &stat) == -1 ) return false;
	if( (stat.st_mode & _S_IFDIR) != 0 ) return true;
	//DirName - is ordinary file. What we have to do?
	return false;
}

void DumbCreateDirectory(char *dir, bool IsUNCPath)
{
	if( *dir == '\0' ) return;

	if( DirectoryExist(dir) ) return;

	if( 0 == _mkdir(dir) ) return;
	if( IsUNCPath && errno == EEXIST ) return; //_stat()     UNC 

	Msg(0, "Can not create directory '%s' - %s", dir, strerror(errno));
	throw NULL;
}

void CreateDirectory(CString&  DirName)
{
	char dir[MAX_PATH];
	char *pointer;
	int level = 0;
	bool IsUNCPath = false;

	strcpy(dir, DirName);
	pointer = dir;
	if( dir[0] == '\\' && dir[1] == '\\' ) IsUNCPath = true;

	do
	{
		level++;

		pointer = strchr(pointer, '\\');
		if( pointer != NULL )
		{
			if (':' == *(pointer - 1))  //    ,   c:\    .
			{
				pointer++;
				continue;
			}
			else if( IsUNCPath && level <= 3 )
			{
				pointer++;
				continue;
			}
			else //     
				*pointer = '\0';
		}

		DumbCreateDirectory(dir, IsUNCPath);

		if( pointer != NULL )
		{
			*pointer = '\\'; //    ,  ,   .
			pointer++;
		}
	} while( pointer != NULL );
}

CStringArray* SplitPath(CString& Path)
{
	CStringArray *parts = new CStringArray;
	int pos = 0, prev_pos = 0;
	bool HasSubdirs = false;
	while( (pos = Path.Find("\\", pos)) >= 0 )
	{
		HasSubdirs = true;
		CString mid = Path.Mid(prev_pos, pos-prev_pos);
		parts->Add(mid);
		pos++;
		prev_pos = pos;
	}

	if( !HasSubdirs )
		parts->Add(Path);
	else
		parts->Add(Path.Mid(prev_pos));

	return parts;
}

void CopyFile(FILE* dest, FILE* src)
{
	char buf[1024];
	rewind(src);
	rewind(dest);
	while( !feof(src) )
	{
		int read = fread(buf, 1, sizeof(buf), src);
		fwrite(buf, 1, read, dest);
	}
}

bool IsIgnoredFile(LPCSTR FileName)
{
	if( 0 == strcmp(FileName, ".")          ) return true;
	if( 0 == strcmp(FileName, "..")         ) return true;
	if( 0 == stricmp(FileName, "CVS")       ) return true;
	if( 0 == stricmp(FileName, ".svn")      ) return true;
	if( 0 == stricmp(FileName, "ChangeLog") ) return true;
	return false;
}

CString Suffix(CString& str)
{
	int pos = str.Find('.');
	if( pos < 0 ) return "";
	return str.Mid(pos+1);
}

char* MinimalMMS()
{
	return "{\r\n\
	{\"MainDataContDef\",\"15\",\"10009\",\"7120\"},\r\n\
	{\"TaskItem\",\r\n\
		{\"1\",\"\",\"\",\"\",\"\",\"1\",\"0\",\"0\",\"1\",\"0\"}\r\n\
	},\r\n\
	{\"GenJrnlFldDef\"},\r\n\
	{\"DocSelRefObj\"},\r\n\
	{\"DocNumDef\"},\r\n\
	{\"Consts\"},\r\n\
	{\"SbCnts\"},\r\n\
	{\"Registers\"},\r\n\
	{\"Documents\"},\r\n\
	{\"Journalisters\"},\r\n\
	{\"EnumList\"},\r\n\
	{\"ReportList\"},\r\n\
	{\"CJ\"},\r\n\
	{\"Calendars\",\r\n\
		{\"HolidaysDef\",\r\n\
			{\"11\",\"\",\"\",\"\"}\r\n\
		}\r\n\
	},\r\n\
	{\"Algorithms\"},\r\n\
	{\"RecalcRules\"},\r\n\
	{\"CalcVars\"},\r\n\
	{\"Groups\"},\r\n\
	{\"Document Streams\"},\r\n\
	{\"Buh\",\r\n\
		{\"2\",\"\",\"\",\"\",\"0\",\"8\",\"8\",\"25\",\"0\",\"0\",\"25\",\"14\",\"2\",\"14\",\"2\",\"14\",\"2\",\"14\",\"3\",\"0\",\"0\",\"10\",\"10\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"1\",\"1\",\"1\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"1\",\"0\",\"1\",\"0\",\"0\",\"0\",\"0\",\"1\",\r\n\
			{},\"1\",\"1\",\r\n\
			{\"AccParams\"},\r\n\
			{\"Plans\"},\r\n\
			{\"ProvParams\"},\r\n\
			{\"OperParams\"},\r\n\
			{\"Form\"},\r\n\
			{\"Form\"},\r\n\
			{\"Form\"},\r\n\
			{\"SbKind\"},\r\n\
			{\"TypOpersDef\",\r\n\
				{\"3\",\"\",\"\",\"\"}\r\n\
			},\r\n\
			{\"CorrProvsDef\",\r\n\
				{\"4\",\"\",\"\",\"\"}\r\n\
			},\r\n\
			{\"ProvHardFldDef\",\r\n\
				{\"5\",\"\",\"\",\"\",\"P\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"},\r\n\
				{\"6\",\"\",\"\",\"\",\"U\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"}\r\n\
			},\r\n\
			{\"OperJournal\",\r\n\
				{\"7\",\"\",\"\",\"\",\"-1\",\"0\",\"9\",\"9\",\"1\",\r\n\
					{\"0\",\"\",\"\",\"\",\r\n\
						{\"Refers\"}\r\n\
					},\r\n\
					{\"JournalFld\"},\r\n\
					{\"Form\",\r\n\
						{\"9\",\"\",\"\",\"\"}\r\n\
					}\r\n\
				}\r\n\
			}\r\n\
		}\r\n\
	}\r\n\
}\r\n\
";
}


void SystemErrorMessage()
{
	char *ErrMsg = NULL;
	FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM, 
		NULL, 
		GetLastError(), 
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), 
		ErrMsg, 
		0, NULL);
	printf(ErrMsg);
	fflush(stdout);
	LocalFree(ErrMsg);
}

void Msg(int MinimalVerbosityLevel, char *msg, ...)
{
	if( MinimalVerbosityLevel <= TaskParameters.Verbose )
	{
		CString ConvertedMsg;
		va_list ap;
		va_start(ap, msg);
		ConvertedMsg.FormatV(msg, ap);
		va_end(ap);


		switch( TaskParameters.LogType )
		{
		case LogType_stdout:
			ConvertedMsg.AnsiToOem();
			printf((LPCSTR)ConvertedMsg);
			printf("\n");
			fflush(stdout);
			break;
		case LogType_ListBox:
			{
			SendMessage(TaskParameters.hwndLog, LB_ADDSTRING, 0, (LPARAM)(LPCSTR)ConvertedMsg);
			int Count = SendMessage(TaskParameters.hwndLog, LB_GETCOUNT, 0, 0);
			SendMessage(TaskParameters.hwndLog, LB_SETCURSEL, Count-1, 0);
			SendMessage(TaskParameters.hwndLog, WM_PAINT, 0, 0);
			}
			break;
		}
	}
}


//    ,      
//  
class CTranslitTable
{
public:
	static CMapWordToPtr Map;
public:
	CTranslitTable();
};
CMapWordToPtr CTranslitTable::Map;

CTranslitTable::CTranslitTable()
{
	Map.SetAt('', "a");
	Map.SetAt('', "b");
	Map.SetAt('', "v");
	Map.SetAt('', "g");
	Map.SetAt('', "d");
	Map.SetAt('', "e");
	Map.SetAt('', "jo");
	Map.SetAt('', "zh");
	Map.SetAt('', "z");
	Map.SetAt('', "i");
	Map.SetAt('', "j");
	Map.SetAt('', "k");
	Map.SetAt('', "l");
	Map.SetAt('', "m");
	Map.SetAt('', "n");
	Map.SetAt('', "o");
	Map.SetAt('', "p");
	Map.SetAt('', "r");
	Map.SetAt('', "s");
	Map.SetAt('', "t");
	Map.SetAt('', "u");
	Map.SetAt('', "f");
	Map.SetAt('', "h");
	Map.SetAt('', "c");
	Map.SetAt('', "ch");
	Map.SetAt('', "sh");
	Map.SetAt('', "shh");
	Map.SetAt('', "#");
	Map.SetAt('', "y");
	Map.SetAt('', "'");
	Map.SetAt('', "je");
	Map.SetAt('', "ju");
	Map.SetAt('', "ja");

	Map.SetAt('', "A");
	Map.SetAt('', "B");
	Map.SetAt('', "V");
	Map.SetAt('', "G");
	Map.SetAt('', "D");
	Map.SetAt('', "E");
	Map.SetAt('', "Jo");
	Map.SetAt('', "Zh");
	Map.SetAt('', "Z");
	Map.SetAt('', "I");
	Map.SetAt('', "J");
	Map.SetAt('', "K");
	Map.SetAt('', "L");
	Map.SetAt('', "M");
	Map.SetAt('', "N");
	Map.SetAt('', "O");
	Map.SetAt('', "P");
	Map.SetAt('', "R");
	Map.SetAt('', "S");
	Map.SetAt('', "T");
	Map.SetAt('', "U");
	Map.SetAt('', "F");
	Map.SetAt('', "H");
	Map.SetAt('', "C");
	Map.SetAt('', "Ch");
	Map.SetAt('', "Sh");
	Map.SetAt('', "Shh");
	Map.SetAt('', "#");
	Map.SetAt('', "Y");
	Map.SetAt('', "'");
	Map.SetAt('', "Je");
	Map.SetAt('', "Ju");
	Map.SetAt('', "Ja");
}
static CTranslitTable TranslitTable;

void InplaceTranslit(CString& str)
{
	if ( lang_Rus == TaskParameters.Language ) return;

	CString Result;
	for (int i=0; i < str.GetLength(); i++)
	{
		TCHAR ch = str.GetAt(i);
		void *ptr;
		if( CTranslitTable::Map.Lookup(ch, ptr) )
			Result += (LPCSTR)ptr;
		else
			Result += ch;
	}

	str = Result;
}

CString Translit(CString& str)
{
	CString Result = str;
	InplaceTranslit(Result);
	return Result;
}

