
#include <io.h>
#include <locale.h>
#include <direct.h>
#include "DLL\GComp.h"
#include "Declarations.h"
#include "CommonFunctions.h"
#include "MMS.h"
#include "Storage.h"
#include "NameTable.h"
#include "Ordering.h"
#include "MMS_Filter.h"

CGCompParameters TaskParameters;
CNameTable NameTable;
CMMSFilter MMS_Filter;
CMMS* MainMetadataStream = NULL;


LPCSTR GComp_GetVersion()
{
	return "2.1.1.beta";
}


void GComp_SetDefaults(CGCompParameters* Parameters) 
{
	Parameters->CompoundFileName = NULL;
	Parameters->DirectoryName = NULL;

	Parameters->CompoundType = by_extension;
	Parameters->Verbose = 0;
	Parameters->LogType = LogType_stdout;
	Parameters->hwndLog = NULL;
	Parameters->NoOrdering = FALSE;
	Parameters->NoProfiles = FALSE;
	Parameters->NoEmptyMxl = FALSE;
	Parameters->TruncateMMS = FALSE;
	Parameters->NotParseForms = FALSE;
	Parameters->NoDefaultsInDialogs = FALSE;
	Parameters->Language = lang_Rus;
	Parameters->SaveVersion = TRUE;
	Parameters->MetadataBySubfolders = FALSE;
	Parameters->MetadataPath = NULL;
};


void InitializeNameTable()
{
	if( lang_Eng == TaskParameters.Language )
		NameTable.EngConstructor();
	else
		NameTable.RusConstructor();
}

BOOL GComp_Decompile(CGCompParameters* Parameters)
{
	TaskParameters = *Parameters;
	char* locale = setlocale( LC_ALL, ".ACP");
	CString csDirectoryName = TaskParameters.DirectoryName;

	try
	{
		InitializeNameTable();

		MMS_Filter.Init(TaskParameters.MetadataPath);

		CStorage Storage;
		Storage.OpenCompound(CString(TaskParameters.CompoundFileName));
		CStorage TypedTextStorage(Storage, "TypedText");

		if( Storage.GetStorage() == NULL || TypedTextStorage.GetStorage() == NULL )
			return FALSE;
		
		CoInitialize(NULL); //need it for unzip modules

		CNameTableRecord* nt_rec = NameTable.Find(NT_MainMetadataStream);
		if( external_report == TaskParameters.CompoundType )
		{
			MainMetadataStream = (CMMS*)Storage.ParseStream(nt_rec->StorageName, false);
		}
		else
		{
			Storage.Open(CString("Metadata"));
			MainMetadataStream = (CMMS*)Storage.ParseStream(nt_rec->StorageName, false);
			Storage.Close();
		}

		if( MainMetadataStream != NULL )
		{
			CreateDirectory(csDirectoryName); //create directory for decompyle to

			if( TaskParameters.SaveVersion )
			{
				CString Version = GComp_GetVersion();
				CString FName = csDirectoryName + "\\gcomp.ver";
				Storage.CopyStringToFile(Version, FName);
			}

			MainMetadataStream->Decompile(csDirectoryName, Storage, TypedTextStorage);
			delete MainMetadataStream;

			if( MMS_Filter.IsEmpty() )
				Storage.PruneDirectory(csDirectoryName);
		}

		CoUninitialize(); //need it for unzip modules
	}
	/*   -  
	catch(CGCompError* e)
	{
		if( MMS != NULL ) delete MMS;
		e->LogError();
		return false;
	}
	*/
	catch(...)
	{
		if( MainMetadataStream != NULL ) delete MainMetadataStream;
		return FALSE;
	}

	if( MainMetadataStream == NULL )
		return FALSE;
	else
		return TRUE;
}

///////////////////////////////////////////////////////////////////////
//////  Compilation functions  ////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
FILE* AssembleMMS();
extern int MMS_debug;

BOOL GComp_Compile(CGCompParameters* Parameters)
{
	TaskParameters = *Parameters;
	char* locale = setlocale( LC_ALL, ".ACP");
	FILE *mmsFile = NULL;
	CString csDirectoryName = TaskParameters.DirectoryName;

	try
	{
		InitializeNameTable();

		if( !DirectoryExist(csDirectoryName) )
		{
			Msg(0, "ERR: Source directory '%s' not exist", TaskParameters.DirectoryName);
			return FALSE;
		}
		CStorage Storage;
		if( !Storage.CreateCompound(CString(TaskParameters.CompoundFileName)) )
			return FALSE;

		mmsFile = AssembleMMS();
		rewind(mmsFile);
		MMS_InitParser(csDirectoryName+"\\MainMetadataStream");
		if( TaskParameters.Verbose >= 3) MMS_debug = 1;
		int RetCode = MMS_parse(mmsFile, (CMMSObject**)&MainMetadataStream);

		if( RetCode != 0 || MainMetadataStream == NULL )
		{
			FILE *f = fopen("MMS.mdp", "wb");
			char cwd[MAX_PATH];
			_getcwd(cwd, sizeof(cwd));
			Msg(0, "   MainMetadataStream  : %s\\MMS.mdp", cwd);
			CopyFile(f, mmsFile);
			fclose(f);
		}
		fclose(mmsFile);
		mmsFile = NULL;

		if( MainMetadataStream == NULL )
			return FALSE;

		CoInitialize(NULL);
		CStorage TypedTextStorage(Storage);
		if( TaskParameters.CompoundType != external_report )
			TypedTextStorage.Create(CString("TypedText"));
		MainMetadataStream->Compile(Storage, TypedTextStorage, csDirectoryName);
		CoUninitialize();
	}
	catch(...)
	{
		if( mmsFile != NULL ) fclose(mmsFile);
		if( MainMetadataStream != NULL ) delete MainMetadataStream;
		return false;
	}

	delete MainMetadataStream;
	return TRUE;
}

