
#ifndef DialogForm_H
#define DialogForm_H

#include "Declarations.h"
#include "Storage.h"
#include "Lexer.h"

#pragma pack(1) // ,      CPropertySet

class CObjectProperty
{
public:
	const char* Name;
	int MMS_Index;
	enum {t_object, t_string, t_quotstring, t_bool, t_int, t_uint, t_bitset, t_double} Type;
	char** FlagList; //  32_ ,       
	short Size; //size in bytes
	int Offset; //offset from beginning of object, in bytes
};


class CPropertySet
{
private:
	CObjectProperty* Propertys;
	void* DefaultValues;
public:
	int nProps;
	int MaxMMS_Index;

private:
	void add_flags(CString& String, int level, const char* id, unsigned int Flags, char* FlagNames[]);
public:
	CPropertySet(CObjectProperty* Props, void* Defaults);
	~CPropertySet();

	CObjectProperty& operator[] (int i) { return Propertys[i]; };
	
	int FindByName(const char* Name);
	int FindByMMSIndex(int Index);
	void SetValue(void* Object, int i, CString& Value, bool Unqoute = true);
	
	void BeautyString(CString& String, int level, const void* Object, int i);
	void ToString(CString& String, const void* Object, int i, bool AddComma);
};

class CFormFont
{
public:
	double FontSize; //-1 - 1pt; -2 - 1.5pt; -3 - 2pt; -4 - 2.5pt ... etc
	int Param2;
	int Param3;
	int Param4;
	bool FontBold; //in source: 400 - normal; 700 - bold
	bool FontItalic; //1 - italic; 0 - normal
	bool FontUnderline; //1 - undeline; 0 - normal
	int Param8;
	int Param9;
	int Param10;
	int Param11;
	int Param12;
	int Param13;
	CString FontName;

private:
	static CPropertySet PropSet;
	static CObjectProperty Props[];

public:
	CFormFont();

public:
//	double RealFontSize();
//	void ReadRealFontSize(double size);

	double From_1C_to_pt(int size);
	int From_pt_to_1C(double size);

	//       (StartIndex)   
	//  .  StartIndex == -1,       - .. 
	//   sID -            
	//   ID
	// ,     
	int FromMMSObject(CMMSObject* Object, int StartIndex);
	void BeautyString(CString& String, int level);

	//   ,    1
	void ReadFromFile(CLexer& Lexer);
	void ToString(CString& String);
};


class CHotKey
{
typedef struct {
	int code;
	char* name;
} VK_Pair;
public:
	int Modifier;
	int KeyCode;

private:
	static VK_Pair virtual_keys[];

public:
	CHotKey() { Modifier = 0; KeyCode = 0; };

	void FromMMSObject(CMMSObject* mms_hotkey);
	void FromString(CString& String, CLexer& Lexer);
	void BeautyString(CString& String, int level);
	void ToString(CString& String);
};


class CFormControlBase
{
public:
	CString Caption;
	CString Class; //1CGROUPBOX, STATIC, 1CEDIT, BMASKED, BUTTON, CHECKBOX, RADIO, LISTBOX, CMBOBOX, TABLE, PICTURE, SysTreeView32
	CString Identifier;
	int ObjectID; //ID  -.    - 
	CString ValueType;  //U(),N(),S(),B(),O(),T(),K( )
	int ValueLen;    //
	int ValuePrec;   //
	CString TypeObjectID; //ID    ValueType in [B, O, T, K].    - 0
	unsigned int ValueFlags;  //1 - , 2 -  .   OR.

protected:
	static char* FlagList[]; //  32_ ,       
	static char* BasicFlagList[]; //  32_ ,       
	static char* ValueFlagList[]; //   .

protected:
	const char* ToRealType(const char* type);
	CString FromRealType(const char* type, bool AsNumber);
	void ObjectNameToID();
};

class CFormControl : public CFormControlBase
{
public:
	unsigned int Flags;
	int PosX;
	int PosY;
	int Width;
	int Height;
	bool IsObjectAttribute; //control     -  . 1 - , 0 - 
	int Param9;
	int TabOrder;
	CString Param11;
	CString Formula;
	unsigned int BasicFlags;
	CString Mask;    //  - ,   - " ".
	CString LongHint;
	CString ShortHint;
	int Param24;
	CFormFont Font; //  25  38
	int FontColor; //-1 - default.  hex-: 0xBBGGRR
	int Param40;
	unsigned int PictureID;
	CString Layer;
	CHotKey HotKey;

private:
	static CPropertySet PropSet;
	static CObjectProperty Props[];

public:
	CFormControl();

public:
	void FromMMSObject(CMMSObject* Object);
	void BeautyString(CString& String, int level);

	void ReadFromFile(CLexer& Lexer);
	void ToString(CString& String);

private:
	bool NeedFont();
	bool NeedType();
};

class CFormColumn : public CFormControlBase
{
public:
	int ColumnType;
	int Width;
	int TabOrder;
	CString Param6;
	CString Formula;
	CString Param15;
	CString Param16;
	int TextAlignment;
	unsigned int BasicFlags;
	CString Mask;    //  - ,   - " ".
	CString LongHint;
	CString ShortHint;
	CString Param22;

private:
	static CObjectProperty Props[];
	static CPropertySet PropSet;

public:
	CFormColumn();

public:
	void FromMMSObject(CMMSObject* Object);
	void BeautyString(CString& String, int level);

	void ReadFromFile(CLexer& Lexer);
	void ToString(CString& String);
};

class CFormBrowser
{
public:
	int Param1;
	int Param2;
	CFormControl Multicolumn;
	CArray<CFormColumn, CFormColumn&> Fixed;

public:
	CFormBrowser() { Param1 = 0; Param2 = 0; };
public:
	void FromMMSObject(CMMSObject* mms_browser);
	void BeautyString(CString& String);
	
	void ReadFromFile(CLexer& Lexer);
	void ToString(CString& String);
};

class CFormControls : public CArray<CFormControl, CFormControl&>
{
public:
	void FromMMSObject(CMMSObject* mms_controls);
	void BeautyString(CString& String);

	void ReadFromFile(CLexer& Lexer);
	void ToString(CString& String);
};


class CFormLayer
{
public:
	CString Caption;
	bool IsVisible;

public:
	CFormLayer() { IsVisible = false; };
};

class CFormLayers : public CArray<CFormLayer, CFormLayer&>
{
public:
	int ActiveLayer; //zero based

public:
	CFormLayers() { ActiveLayer = 0; };

public:
	void FromMMSObject(CMMSObject* Object);
	void BeautyString(CString& String);

	void ReadFromFile(CLexer& Lexer);
	void ToString(CString& String);
};


class CDialogForm
{
public:
	CFormFont Font;
	int Width;
	int Height;
	CString Caption;
	CString Param18;
	CString Param19;
	unsigned int Flags1; // 
	CString Param21;
	bool FontDefault; //1 - default; 0 - user defined
	bool AutoTabOrder;
	CString Param24;
	CString Param25;
	int BackgroundColor; //-1 - default.  hex-: 0xBBGGRR
	CString Param27;
	unsigned int Flags2; // Flags1
	CFormLayers Layers;
	bool ShowPanel; //1 - ; 0 -  
	bool AllowResize; //1 -   ; 0 - 

	CString Braces; // {{{}},{}} -  

	CFormBrowser Browser;
	CFormControls Controls;

	CString Cnt_Ver; //   10001

public:
	CDialogForm();

public:
	//  ,     
	void FromMMSObject(CMMSObject* Object);
	void BeautyString(CString& String);
	void WriteToFile(CStorage& Storage, CString FileName);

	//        
	void ReadFromFile(CString& FileName);
	void ToString(CString& String);

private:
	static char* FlagList[]; //  32_ ,       
	static CPropertySet PropSet;
	static CObjectProperty Props[];

private:
	void FrameFromMMSObject(CMMSObject* mms_frame);
	bool FlagToString(CString& String, short flag, const char* FlagName, bool add_delimiter);
};

#pragma pack() //   

#endif
