///////////////////////////////////////////////////////////////////////
///// Main Metadata Stream ////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////

#ifndef MMS_H
#define MMS_H

#include <afxtempl.h>
#include "StreamInfo.h"
#include "Declarations.h"



///////////////////////////////////////////////////////////
//// Generic MMS object ///////////////////////////////////
///////////////////////////////////////////////////////////
class CMMSObject
{
public:
	MMSObjectType Type;
	enum {IDT_NoID = 0, IDT_OnlyNumeric = 1, IDT_OnlyTextual = 2, IDT_BothIDs = 3} ID_Type;
	CString sID;
	int ID;
	int Order; // 

	bool Used; //       

public:
	CMMSObject() {Type = MMS_Object; ID = 0; ID_Type = IDT_NoID; Used = false;};
	CMMSObject(CString& sID, CString& ID);
	virtual ~CMMSObject();

	void DestroyObjects();

public:
	virtual int GetNProps() {return 0;};
	virtual CMMSObject* GetPropByNum(int i) {return NULL;};
	//     pList      
	virtual CMMSObject* GetProperty(int ID, bool recursive = false, CMMSNodeList* pList = NULL);
	virtual CMMSObject* GetProperty(CString& sID, bool recursive = false, int* pIndex = NULL);

	//      .   .
	void MarkUsed(int ID);
	void DeleteUnused();

	virtual CMMSObject* AddProperty(CMMSObject* Property) {return NULL;};
	virtual bool DelProperty(int i) {return false;};

	virtual CString HdrAsString();
	// true,        .      
	virtual bool PropsAsString(CString& dest, int Depth = 0);
	virtual CString AsString(int Depth = 0);

	virtual void Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage) {};
	virtual void Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& Dir);

	//   
	void ExtractString(CStorage& Storage, CString& DestDir, CString& Str, MMSObjectType Type);
	bool ExtractMetadata(CString& DestDir, MMSObjectType Type, CStorage& TypedTextStorage);
	void ExtractMetadata(CString& DestDir, CStorage& TypedTextStorage);
	
	//FNamePrefix -        '\'
	//StdName -  true,         NameTable   sID. 
	//                sID.
	void ExtractDescriptions(CString& FNamePrefix, CStorage& TypedTextStor, bool StdName);
	void ImportDescriptions(CStorage& TypedTextStor, CString& FNamePrefix, bool StdName);
};

////////////////////////////////////////////////////////////
//// MMS object with properties (stored in array) //////////
////////////////////////////////////////////////////////////
class CMMSObjectWithProps : public CMMSObject
{
protected:
	CArray<PCMMSObject, PCMMSObject&> Properties;
	int nProps;

public:
	CMMSObjectWithProps() {nProps = 0;};
	CMMSObjectWithProps(CString& sID, CString& ID) :CMMSObject(sID, ID) {nProps = 0;};
	CMMSObjectWithProps(CString& sID, CString& ID, CMMSNodeList *pList);
	CMMSObjectWithProps(CMMSNodeList *pList);
	~CMMSObjectWithProps();

	void SetProperties(CMMSNodeList *pList);

	void SortByOrder();

public:
	CMMSObject* AddProperty(CMMSObject* Property);
	bool DelProperty(int i);

	int GetNProps() {return nProps;};
	CMMSObject* GetPropByNum(int i) {return Properties[i];};
	
	void ExtractMoxelPages(CString& DestDir, CStorage& WBStorage);
	void ExtractWorkBook(CString& DestDir, CStorage& Storage);
	void ExtractListForms(CMMSObject* Forms, CString& Dir, CStorage& Storage, CString Prefix);
	void ExtractOrdering(CStorage& Storage, CString& DestDir);

	bool ImportMoxelPages(CStorage& Storage, CString& SrcDir, CString& ContCont);
	void ImportContainerProfile(CStorage& Storage, CString& SrcDir);
	bool ImportWorkBook(CStorage& Storage, CString& SrcDir);
	bool ImportListForms(CMMSObject* Forms, CStorage& Storage, CString& SrcDir, CString Prefix);
	void ImportOrdering(CString& SrcDir);

	void ExtractStreamByType(CStorage& Storage, MMSObjectType Type, CString& Dir);
	bool ImportStreamByType(CStorage& Storage, MMSObjectType Type, CString& SrcDir);
};

////////////////////////////////////////////////////////////
//   ,   .   properties. (, ,   ..)
class CMMSBasicObject : public CMMSObjectWithProps
{
public:
	CString Comment;
	CString Synonym;

public:
	CMMSBasicObject(CString& sID, CString& ID, CString& Comment, CString& Synonym, CMMSNodeList *pList);

public:
	CString HdrAsString();
protected:
	CString GetObjectDir(CString& ParentDir);
};


////////////////////////////////////////////////////////////
////      /////////////////////////////////
////////////////////////////////////////////////////////////
class CMMS : public CMMSObjectWithProps
{
public:
	CMMS(CMMSNodeList *pList);

private:
	typedef struct {
		int ID;
		CString Name;
	} TObjNameCache;
	CArray<TObjNameCache, TObjNameCache&> ObjNameCache;

public:
	int GetNProps() {return nProps;};
	CMMSObject* GetPropByNum(int i) {return Properties[i];};
	CString AsString(int Depth = 0);

	// ID     
	CString& ObjectIDtoName(int ID);
	int     ObjectNameToID(CString& Name);

	void DeleteUnusedObjects(CStorage& Storage);

	void Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage);
	void ExtractStorage(CString& Dir, CStorage& Storage, MMSObjectType Type, bool WithContainerCOntents);
	void ExtractCommonMXL(CString& Dir, CStorage& Storage);
	void ExtractPictureGallery(CString& Dir, CStorage& Storage);

	void Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& Dir);
	void ImportMMS(CStorage& Storage);
	void ImportGlobalModule(CStorage& Storage, CString& Dir);
	void ImportCommonMXL(CStorage& Storage, CString& SrcDir);
	bool ImportStorage(CStorage& Storage, CString& SrcDir, MMSObjectType Type);
};

////////////////////////////////////////////////////////////////////
//  ,        1cv7.md //
////////////////////////////////////////////////////////////////////
class CMMSMetadataPart: public CMMSObjectWithProps
{
public:
	CMMSMetadataPart(MMSObjectType Type) 
		{this->Type = Type;};

	CMMSMetadataPart(MMSObjectType Type, CString& sID, CMMSNodeList* pPropsList)
		:CMMSObjectWithProps(sID, CString(), pPropsList) 
		{ this->Type = Type; ID_Type = CMMSObject::IDT_OnlyTextual;};

public:
	void Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage);
	void Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& Dir);
};

////////////////////////////////////////////////////////////
////        /////////////////
////////////////////////////////////////////////////////////
class CMMSDescr : public CMMSMetadataPart
{
public:
	int FirstAvailableID; //   
	int MD_ver;
	int UnknownID;

public:
	CMMSDescr() 
		:CMMSMetadataPart(MMS_MainDataContDef) {};
	CMMSDescr(CString& sID, CString& FirstAvailableID, CString& MD_ver, CString& UnknownID);

public:
	CString AsString(int Depth = 0);
};

////////////////////////////////////////////////////////////
class CMMSSbCnt : public CMMSBasicObject
{
public:
	CMMSSbCnt(CString& sID, CString& ID, CString& Comment, CString& Synonym, CMMSNodeList *pList);

public:
	void Decompile(CString& BaseDir, CStorage& Storage, CStorage& TypedTextStorage, CStorage& SubFolderStorage, CStorage& SubListStorage);
	void Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& Dir, CStorage& SubFolderStorage, CStorage& SubListStorage);
};

////////////////////////////////////////////////////////////
class CMMSSbCnts : public CMMSObjectWithProps
{
public:
	CMMSSbCnts(CString sID, CMMSNodeList* pDocList);

public:
	void Decompile(CString& BaseDir, CStorage& Storage, CStorage& TypedTextStorage);
	void Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& Dir);
};


////////////////////////////////////////////////////////////
class CMMSDocument : public CMMSBasicObject
{
public:
	CMMSDocument(CString& sID, CString& ID, CString& Comment, CString& Synonym, 
		CMMSNodeList *pList);

public:
	void Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage);
	void Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir);
};


////////////////////////////////////////////////////////////
class CMMSDocuments : public CMMSObjectWithProps
{
public:
	CMMSDocuments(CString sID, CMMSNodeList* pDocList);

public:
	void Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage);
	void Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir);
};

///////////////////////////////////////////////////////////
////   ////////////////////////
///////////////////////////////////////////////////////////
class CMMSDocStream: public CMMSObject
{
public:
	CString Comment;
	CString Synonym;
	CString Param1;
	CString Param2;

	CMMSObject* Registers;
	CMMSObject* Documents;

public:
	CMMSDocStream(CString& sID, CString& ID, 
		CString& Comment, CString& Synonym, CString& Param1, CString& Param2,
		CMMSObject* Registers, CMMSObject* Documents);
	~CMMSDocStream();

public:
	CString AsString(int Depth = 0);
};

////////////////////////////////////////////////////////////
class CMMSRegisters: public CMMSMetadataPart
{
public:
	CMMSRegisters(MMSObjectType Type, CString& sID, CMMSNodeList* pPropsList);
};

////////////////////////////////////////////////////////////
class CMMSEnums: public CMMSMetadataPart
{
public:
	CMMSEnums(MMSObjectType Type, CString& sID, CMMSNodeList* pPropsList);
};


////////////////////////////////////////////////////////////
class CMMSReport : public CMMSBasicObject
{
public:
	CMMSReport(CString& sID, CString& ID, CString& Comment, CString& Synonym)
		:CMMSBasicObject(sID, ID, Comment, Synonym, NULL)
		{Type = MMS_Report;};

public:
	void Decompile(CString& Dir, CStorage& Storage, CString& Prefix, CStorage& TypedTextStorage);
	void Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir, CString& SubStroragePrefix);
};

////////////////////////////////////////////////////////////
class CMMSReportList : public CMMSObjectWithProps
{
public:
	CMMSReportList(CString sID, CMMSNodeList* pRepList)
		:CMMSObjectWithProps(sID, CString(), pRepList) 
		{Type = MMS_ReportList; ID_Type = CMMSObject::IDT_OnlyTextual;};

public:
	void Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage);
	void Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir);
};

///////////////////////////////////////////////////////////
class CMMSJournalister: public CMMSBasicObject
{
public:
	CMMSJournalister(CString& sID, CString& ID, CString& Comment, CString& Synonym, CMMSNodeList* pList)
		:CMMSBasicObject(sID, ID, Comment, Synonym, pList)
		{Type = MMS_Journalister;};

public:
	void Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage);
	void Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir);
};

////////////////////////////////////////////////////////////
class CMMSJournalisters: public CMMSObjectWithProps
{
public:
	CMMSJournalisters(CString sID, CMMSNodeList* pRepList)
		:CMMSObjectWithProps(sID, CString(), pRepList) 
		{Type = MMS_Journalisters; ID_Type = CMMSObject::IDT_OnlyTextual;};

public:
	void Decompile(CString& SrcDir, CStorage& Storage, CStorage& TypedTextStorage);
	void Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir);
};

///////////////////////////////////////////////////////////
class CMMSCalcJournal : public CMMSBasicObject
{
public:
	CMMSCalcJournal(CString& sID, CString& ID, CString& Comment, CString& Synonym, CMMSNodeList* pList)
		:CMMSBasicObject(sID, ID, Comment, Synonym, pList)
		{Type = MMS_CalcJournal;};

public:
	void Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage);
	void Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir);
};

////////////////////////////////////////////////////////////
class CMMSCalcJournals: public CMMSObjectWithProps
{
public:
	CMMSCalcJournals(CString sID, CMMSNodeList* pRepList)
		:CMMSObjectWithProps(sID, CString(), pRepList) 
		{Type = MMS_CalcJournals; ID_Type = CMMSObject::IDT_OnlyTextual;};

public:
	void Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage);
	void Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir);
};


////////////////////////////////////////////////////////////
class CMMSCaclAlgorithm : public CMMSBasicObject
{
public:
	CMMSCaclAlgorithm(CString& sID, CString& ID, CString& Comment, CString& Synonym, CMMSNodeList *pList)
		:CMMSBasicObject(sID, ID, Comment, Synonym, pList)
		{Type = MMS_CalcAlgorithm;};

public:
	void Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage);
	void Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir);
};


////////////////////////////////////////////////////////////
class CMMSCaclAlgorithms : public CMMSObjectWithProps
{
public:
	CMMSCaclAlgorithms(CString sID, CMMSNodeList* pAlgList)
		:CMMSObjectWithProps(sID, CString(), pAlgList)
		{Type = MMS_CalcAlgorithms; ID_Type = CMMSObject::IDT_OnlyTextual;};

public:
	void Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage);
	void Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir);
};


////////////////////////////////////////////////////////////
////   /////////////////////////////////
////////////////////////////////////////////////////////////
class CMMSBuh: public CMMSObjectWithProps
{
private:
	int nForms;

private:
	int BuhID; //       ID
	CMMSObject* AccountPlans;
	CMMSObject* AccListForms;
	CMMSObject* ProvListForms;
	CMMSObject* OperListForms;
	CMMSObject* UnknownListForms;

public:
	CMMSBuh(CString sID, CMMSNodeList* pList);
	CMMSBuh(CString sID, CString& BuhID);

	CMMSObject* AddProperty(CMMSObject* Property);

	CString HdrAsString();
	// true,        .      
	bool PropsAsString(CString& dest, int Depth = 0);

public:
	void ExtractForm(CString& Dir, CStorage& Storage, MMSObjectType StorType, MMSObjectType Type);
	void ExtractListForm(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage,
		MMSObjectType Type, CMMSObject* ListForms);
	void Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage);

	void ImportForm(CStorage& Storage, CString& SrcDir, MMSObjectType StorType, MMSObjectType Type);
	void ImportListForm(CStorage& Storage, CString& SrcDir, MMSObjectType Type, CMMSObject* ListForms);
	void Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir);
};


////////////////////////////////////////////////////////////
////   ///////////////////////////////////////////
////////////////////////////////////////////////////////////
class CMMSAccountPlans: public CMMSObjectWithProps
{
public:
	CMMSAccountPlans(CString& sID, CMMSNodeList *pList);

public:
	void Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage);
	void Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir);
};

class CMMSAccountPlan: public CMMSBasicObject
{
public:
	CString AccountMask1; //  
	CString AccountMask2; //    -   
	CMMSObject* Accounts;
	
public:
	CMMSAccountPlan(CString& sID, CString& ID, CString& Comment, CString& Synonym, 
		CString& AccountMask1, CString& AccountMask2, CMMSObject *pAccList);

	CString HdrAsString();

public:
	void Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage, CObjectOrdering& Order);
	void Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir);
};

////////////////////////////////////////////////////////////
////   /////////////////////////////////////////////////
////////////////////////////////////////////////////////////
class CMMSAccount: public CMMSObjectWithProps
{
public:
	CString Name;
	CString Param2; // .  ""
	CString Code;   // 
	int IsCurrency; //
	int IsAmount;   // 
	int IsSingle;   // 
	int IsGroup;    //   
	int IsActive;   //1 - ; 2 - ; 3 - -

public:
	CMMSAccount(CString& sID, CString& ID, CString& Name, CString& Param2, 
		CString& Code, CString& IsCurrency, CString& IsAmount, 
		CString& IsSingle, CString& IsGroup, CString& IsActive,
		CMMSNodeList *pSubcontoList);

	CString HdrAsString();

public:
	void Decompile(CString& Dir, CStorage& Storage, CObjectOrdering& Order);
};

///////////////////////////////////////////////////////////
////  .      ///////
///////////////////////////////////////////////////////////
class CMMSNode : public CMMSObject
{
public:
	CMMSNodeList *Properties;

public:
	CMMSNode(CMMSNodeList* pList) 
		:CMMSObject() 
		{Type = MMS_Object; Properties = pList;};
	CMMSNode(MMSObjectType Type, CString& sID, CString& ID, CMMSNodeList* pList = NULL) 
		:CMMSObject(sID, ID) 
		{this->Type = Type; Properties = pList;};

	~CMMSNode();

public:
	void AddValue(CString& Value);
	void AddValue(CMMSObject *Node);

	int GetNProps();
	CMMSObject* GetPropByNum(int i);

	CString HdrAsString();
	bool PropsAsString(CString& dest, int Depth);
};


///////////////////////////////////////////////////////////
////   .     //////////
///////////////////////////////////////////////////////////
class CMMSNodeList : public CList<CMMSObject*, CMMSObject*&>
{
public:
	bool DestroyObjects;

public:
	CMMSNodeList() {DestroyObjects = true;};
	~CMMSNodeList();

public:
	void AddNode(CString& Value);
	void AddNode(CMMSObject* Node);
	void AddNode(CMMSNode* Node);
};



/////////////////////////////////////////////////////////
/////  Stack value representation for Bison parser  /////
/////////////////////////////////////////////////////////
class MMS_StackValue 
{
public:
	CString String;
	CMMSObject* pNode;
	CMMSNodeList* pList;

public:
	MMS_StackValue() { pNode = NULL; pList = NULL; };
};

void MMS_InitParser(CString& ParsedObjectName, bool ParseWitnNoIDs = false);
int MMS_parse(FILE *File, CMMSObject** ParserResult);


#endif //MMS_H