
#include <io.h>
#include "MMS.h"
#include "NameTable.h"
#include "Storage.h"
#include "CommonFunctions.h"
#include "Container.h"
#include "Ordering.h"
#include "DLL\GComp.h"
#include "UI.h"
#include "DialogForm.h"

void CreateTypedTextContainerContents(CStorage& TypedTextStorage)
{
	CString CC = "{\"Container.Contents\",{\"MetaDataDescription\",\"MD Programm text\",\"MD Programm text\",\"\"}}\n";
	TypedTextStorage.StreamFromString("Container.Contents", CC);
}

void CreateContainerContents(CStorage& Storage)
{
	CContainer CC;
	CC.Create(Storage, true);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSObject methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSObject::Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	if( nt_rec == NULL ) return;
	if( !nt_rec->Dir.IsEmpty() )
	{
		CString Dir = nt_rec->PrepareDirName(SrcDir);
		ImportDescriptions(TypedTextStorage, Dir+"\\", true);
	}
}

void CMMSObject::ImportDescriptions(CStorage& TypedTextStor, CString& FNamePrefix, bool StdName)
{
	if( Type == MMS_Property ) return; //    

	CNameTableRecord* nt_rec_obj = NameTable.Find(Type);
	CNameTableRecord* nt_rec = NameTable.Find(NT_UserHelpStor);
	CNameTableRecord* nt_rec_file = NameTable.Find(NT_UserHelp);
	CString StorName = nt_rec->PrepareStorageName(ID);
	CString NewPrefix = FNamePrefix;
	CString Suffix;
	
	if( ID_Type != IDT_NoID && 
		(nt_rec_obj == NULL || nt_rec_obj->Type1C == "sID") )
	{
		if( ID_Type == IDT_OnlyTextual )
			Suffix.Format("%s.", sID);
		else if( ID_Type == IDT_OnlyNumeric )
			Suffix.Format("%s.%i.", nt_rec_file->FileName, ID);
		else if( sID.IsEmpty() || !IsValidFileName(sID) )
			Suffix.Format("%s.%i.", nt_rec_file->FileName, ID);
		else
			Suffix.Format("%s.", sID);
	}

	InplaceTranslit(Suffix);
	NewPrefix += Suffix;

	if( ID_Type == IDT_BothIDs && 
		!TypedTextStor.StorageExist(StorName) )
	{
		CString FName;

		if( StdName || Suffix.IsEmpty() )
			FName.Format("%s%s.%s", FNamePrefix, nt_rec_file->FileName, nt_rec_file->Ext);
		else
			FName.Format("%s%s", NewPrefix, nt_rec_file->Ext);

		if( FileExist(FName) )
		{
			if( TypedTextStor.Create(StorName) )
			{
				TypedTextStor.StreamFromFile(nt_rec_file->PrepareStorageName(ID), FName);
				CreateTypedTextContainerContents(TypedTextStor);
				TypedTextStor.Close();
			}
		}
	}

	for( int i = 0; i < GetNProps(); i++ )
	{
		GetPropByNum(i)->ImportDescriptions(TypedTextStor, NewPrefix, false);
	}
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSObjectWithProps methods  ///////////////////////
///////////////////////////////////////////////////////////////////////
bool CMMSObjectWithProps::ImportMoxelPages(CStorage& Storage, CString& SrcDir, CString& ContCont)
{
	bool HavePages = false;
	CString FName, Page, CC;

	CObjectOrdering Order(4);

	if( !Order.OpenFile(SrcDir) ) return false;

	while( Order.ReadString() )
	{
		
		// 
		FName.Format("%s\\%s", SrcDir, Order.GetValue(2));
		Page.Format("Page.%s", Order.GetValue(0));

		if( TaskParameters.NoEmptyMxl ) //  
		{
			long size = GetFileSize(FName);
			if( size == 147 || size == 139 ) continue;
		}

		Storage.StreamFromFile(Page, FName);

		CC.Format(",{\"Moxcel.Worksheet\",\"%s\",\"%s\",\"\"}", Page, Order.GetValue(3));
		ContCont += CC;

		HavePages = true;
	}

	return HavePages;
}

void CMMSObjectWithProps::ImportContainerProfile(CStorage& Storage, CString& SrcDir)
{
	CString ContProfName = SrcDir + "\\Container.Profile";
	CString StreamName = "Container.Profile";

	if( FileExist(ContProfName) )
	{
		Storage.StreamFromFile(StreamName, ContProfName);
		return;
	}

	if( TaskParameters.NoProfiles ) return;

	CString CP = "{\n\
{\"MoxelName\",\"\",\"\"},\n\
{\"MoxelPos\",\"0\",\"\"},\n\
{\"UUID\",\"D41D8CD98F00B204E9800998ECF8427E\",\"\"},\n\
{\"Entry\",\"1\",\"\"},\n\
{\"MoxelNextMode\",\"1\",\"\"}}";

	Storage.StreamFromString(StreamName, CP);
}


bool CMMSObjectWithProps::ImportStreamByType(CStorage& Storage, MMSObjectType Type, CString& SrcDir)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString FileName = nt_rec->PrepareFileName(SrcDir);

	if( !FileExist(FileName) ) return false;

	CStorage SubStorage(Storage);
	bool res = SubStorage.StreamFromFile(
		nt_rec->PrepareStorageName(ID), 
		FileName);
	
	return res;
}

extern int MMS_debug;
bool CMMSObjectWithProps::ImportWorkBook(CStorage& Storage, CString& SrcDir)
{
	CNameTableRecord* nt_rec_wb = NameTable.Find(NT_Workbook);
	CNameTableRecord* nt_rec;
	CString ContCont = "{\"Container.Contents\"";
	bool NotEmpty = false;

	//     
	if( TaskParameters.CompoundType == external_report )
		ContCont += ",{\"MetaDataHolderContainer\",\"Main MetaData Stream\",\"Main MetaData Stream\",\"\"}";

	if( TaskParameters.CompoundType != external_report )
		Storage.Create(nt_rec_wb->StorageName);

	// 
	bool dlg_form_imported = false;
	nt_rec = NameTable.Find(NT_DialogForm);
	CString FormFName = nt_rec->PrepareFileName(SrcDir);
	if( TaskParameters.NotParseForms )
	{
		if( Storage.StreamFromFile(nt_rec->StorageName, nt_rec->PrepareFileName(SrcDir)) )
		{
			dlg_form_imported = true;
		}
	}
	else
	{
		if( FileExist(FormFName) )
		{
			CDialogForm DlgForm;
			DlgForm.ReadFromFile(FormFName);
			CString DlgAsString;
			DlgForm.ToString(DlgAsString);
			if( Storage.StreamFromString(nt_rec->StorageName, DlgAsString) )
			{
				dlg_form_imported = true;
			}
		}
	}
	if( dlg_form_imported )
	{
		NotEmpty = true;
		ContCont += ",{\"DialogEditor\",\"Dialog Stream\",\"Dialog Form\",\"\"}";
	}

	// 
	nt_rec = NameTable.Find(NT_FormModule);
	if( Storage.StreamFromFile(nt_rec->StorageName, nt_rec->PrepareFileName(SrcDir)) )
	{
		NotEmpty = true;
		ContCont += ",{\"TextDocument\",\"MD Programm text\",\"Module text\",\"\"}";
	}

	//       .   "Inplace description"
	if( TaskParameters.CompoundType == external_report )
	{
		ImportStreamByType(Storage, NT_ErtUserHelp, SrcDir);
		ContCont += ",{\"MetaDataDescription\",\"Inplace description\",\"\",\"\"}";
	}

	// 
	if( ImportMoxelPages(Storage, SrcDir, ContCont) ) NotEmpty = true;
	
	ContCont += "}\n";
	Storage.StreamFromString("Container.Contents", ContCont);
	
	//Container.Profile
	ImportContainerProfile(Storage, SrcDir);

	if( TaskParameters.CompoundType != external_report )
	{
		Storage.Close();
		if( !NotEmpty ) Storage.Delete(nt_rec_wb->StorageName);
	}

	return NotEmpty;
}

bool CMMSObjectWithProps::ImportListForms(CMMSObject* Forms, CStorage& Storage, 
										  CString& SrcDir, CString Prefix)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_ListForm);
	CString StorName;
	bool NotEmpty = false;

	for( int i = 0; i < Forms->GetNProps(); i++ )
	{
		CMMSObject* Form = Forms->GetPropByNum(i);
		CString FormDir;
		FormDir.Format("%s\\%s.%s", SrcDir, Translit(Form->sID), nt_rec->Ext);
		
		StorName.Format("%s%i", Prefix, Form->ID);
		Storage.Create(StorName);
		NotEmpty = ImportWorkBook(Storage, FormDir);
		Storage.Close();
		if( !NotEmpty )
			Storage.Delete(StorName);
	}

	return NotEmpty;
}

void CMMSObjectWithProps::ImportOrdering(CString& SrcDir)
{
	CObjectOrdering Order(3);
	if( !Order.OpenFile(SrcDir) ) return;
	
	int i = 0;
	while( Order.ReadString() )
	{
		int ID = atoi(Order.GetValue(0));
		CMMSObject* obj = GetProperty(ID, false);
		if( obj != NULL ) obj->Order = i++;
	}

	SortByOrder();
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMS methods  //////////////////////////////////////
///////////////////////////////////////////////////////////////////////
bool CMMS::ImportStorage(CStorage& Storage, CString& SrcDir, MMSObjectType Type)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage DestStor(Storage);

	return DestStor.StorageFromDir(nt_rec->PrepareStorageName(ID), nt_rec->PrepareDirName(SrcDir));
}

void CMMS::ImportCommonMXL(CStorage& Storage, CString& SrcDir)
{
	CNameTableRecord* nt_rec_gd = NameTable.Find(NT_GlobalData);
	CNameTableRecord* nt_rec = NameTable.Find(NT_CommonMXL);
	
	CStorage GDStorage(Storage);
	GDStorage.Create(nt_rec_gd->StorageName);
	CStorage MXLStorage(GDStorage);
	MXLStorage.Create(nt_rec->StorageName);

	if( !ImportWorkBook(MXLStorage, nt_rec->PrepareDirName(SrcDir)) )
	{
		MXLStorage.Close();
		GDStorage.Delete(nt_rec->StorageName);
	}
}

void CMMS::ImportGlobalModule(CStorage& Storage, CString& Dir)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_GlobalModuleStor);
	CStorage GMStorage(Storage);

	if( ImportStreamByType(Storage, NT_GlobalModule, Dir) && GMStorage.Open(nt_rec->StorageName) )
	{
		GMStorage.Open(nt_rec->StorageName);
		CreateTypedTextContainerContents(GMStorage);
	}
}


void CMMS::ImportMMS(CStorage& Storage)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_MainMetadataStream);

	//  
	CMMSDescr* Descr = (CMMSDescr*)GetPropByNum(0);
	Descr->MD_ver = 10009;
	// CRC
	int crc_num;
	GetProperty(CString("CRC"), false, &crc_num);
	if( crc_num >= 0 ) DelProperty(crc_num);


	if( TaskParameters.CompoundType != external_report )
	{
		Storage.Create(CString("Metadata"));
	}

	if( (TaskParameters.CompoundType == external_report) 
		&& TaskParameters.TruncateMMS )
	{
		Storage.StreamFromString(nt_rec->StorageName, CString(MinimalMMS()));
	}
	else
	{
		Storage.StreamFromString(nt_rec->StorageName, AsString(-100));
	}

	if( TaskParameters.CompoundType == external_report )
	{
		Storage.AddZeroByte(); //        '\0'
	}

	if( TaskParameters.CompoundType != external_report )
	{
		Storage.Close();
	}
}


void CMMS::Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& Dir)
{
	if( TaskParameters.CompoundType == external_report	)
	{
		ImportWorkBook(Storage, Dir);
		ImportStorage(Storage, Dir, NT_PictureGallery);
		ImportMMS(Storage);
		CreateContainerContents(Storage);
		return;
	}
	
	//    
	CNameTableRecord* nt_rec_descr = NameTable.Find(NT_UserHelpStor);
	CString DescrDir = nt_rec_descr->PrepareDirName(Dir);
	ImportDescriptions(TypedTextStorage, DescrDir+"\\", false);
	// 
	ImportGlobalModule(TypedTextStorage, Dir);

	for( int i = 0; i < GetNProps(); i++ )
	{
		CMMSObject *obj = GetPropByNum(i);
		Msg(2, "%s:", obj->sID);
		obj->Compile(Storage, TypedTextStorage, Dir);
	}

	// 
	ImportCommonMXL(Storage, Dir);
	//
	ImportStorage(Storage, Dir, NT_PictureGallery);
	
	//
	CompileUI(Storage, Dir);
	//
	ImportStorage(Storage, Dir, NT_UserRights);

	// 
	ImportStreamByType(Storage, NT_GUIDData, Dir);
	ImportStreamByType(Storage, NT_TagStream, Dir);

	//Container.Contents   UserDef
	Storage.Open(CString("UserDef"));
	CString CC = "{\"Container.Contents\",{\"WorkPlaceType\",\"Page.1\",\"\",\"\"},{\"RigthType\",\"Page.2\",\"\",\"\"}}";
	Storage.StreamFromString("Container.Contents", CC);
	Storage.Close();

	//  - Main Metadata Stream
	ImportMMS(Storage);

	//   storage   Container.Contents    .
	CreateContainerContents(Storage);
	CreateContainerContents(TypedTextStorage);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSMetadataPart methods  /////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSMetadataPart::Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& Dir)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString MdpDir = nt_rec->PrepareDirName(Dir, this);

	CObjectOrdering Order(3);
	if( Order.OpenFile(MdpDir) )
	{
		int i = 0;
		while( Order.ReadString() )
		{
			int ID = atoi(Order.GetValue(0));
			CMMSObject* obj = GetProperty(ID, false);
			if( obj != NULL ) obj->Order = i++;
		}
		SortByOrder();
	}

	//     ,       .
	for( int i = 0; i < nProps; i++ )
	{
		CMMSMetadataPart* pMdp = (CMMSMetadataPart*)Properties[i];
		CString MdpSubDir;
		MdpSubDir.Format("%s\\%s\\", MdpDir, pMdp->sID);
		pMdp->ImportDescriptions(TypedTextStorage, MdpSubDir, true);
	}
	//    ,    
	ImportDescriptions(TypedTextStorage, MdpDir+"\\", true);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSSbCnt methods  /////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSSbCnt::Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& Dir, CStorage& SubFolderStorage, CStorage& SubListStorage)
{
	CNameTableRecord* nt_rec_sc = NameTable.Find(Type);
	CNameTableRecord* nt_rec;
	CString ScDir = GetObjectDir(Dir);
	//ScDir.Format("%s\\%s", Dir, sID);

	Storage.Create(nt_rec_sc->PrepareStorageName(ID));

	// 
	bool NotEmpty = ImportWorkBook(Storage, ScDir);
	Storage.Close();
	if( !NotEmpty )
		Storage.Delete(nt_rec_sc->PrepareStorageName(ID));

	//
	ImportDescriptions(TypedTextStorage, ScDir+"\\", true);
	// 
	nt_rec = NameTable.Find(NT_SubcontoFolder);
	CString SubFldDir = nt_rec->PrepareDirName(ScDir);
	if( DirectoryExist(SubFldDir) )
	{
		SubFolderStorage.Create(nt_rec->PrepareStorageName(ID));
		ImportWorkBook(SubFolderStorage, SubFldDir);
		SubFolderStorage.Close();
	}

	// 
	nt_rec = NameTable.Find(NT_SubcontoListForm);
	CMMSObject* ListForms = GetProperty(CString("Form"));
	ImportListForms(ListForms, SubListStorage, ScDir, nt_rec->StorageName);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSSbCnts methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSSbCnts::Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& Dir)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage SubFolderStorage(Storage);
	CStorage SubListStorage(Storage);
	CString ScsDir;
	
	ScsDir.Format("%s\\%s", Dir, nt_rec->Dir);

	ImportOrdering(ScsDir);

	SubFolderStorage.Create(CString("SubFolder"));
	SubListStorage.Create(CString("SubList"));

	Storage.Create(nt_rec->StorageName);
	for( int i = 0; i < GetNProps(); i++ )
	{
		CMMSSbCnt* Sc = (CMMSSbCnt*)GetPropByNum(i);
		Sc->Compile(Storage, TypedTextStorage, ScsDir, SubFolderStorage, SubListStorage);
	}

	Storage.Close();
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSDocument methods  //////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSDocument::Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir)
{
	CNameTableRecord* nt_rec_stor = NameTable.Find(Type);
	CStorage TransactStorage(TypedTextStorage);

	CString DocDir = GetObjectDir(SrcDir);
	Storage.Create(nt_rec_stor->PrepareStorageName(ID));
	bool NotEmpty = ImportWorkBook(Storage, DocDir);
	Storage.Close();
	if( !NotEmpty )
		Storage.Delete(nt_rec_stor->PrepareStorageName(ID));

	// 
	CNameTableRecord* nt_rec_file = NameTable.Find(NT_TransactModule);
	CString FileName = nt_rec_file->PrepareFileName(DocDir);
	if( FileExist(FileName) )
	{
		nt_rec_stor = NameTable.Find(NT_TransModuleStor);
		TransactStorage.Create(nt_rec_stor->PrepareStorageName(ID));
		ImportStreamByType(TransactStorage, NT_TransactModule, DocDir);
		CreateTypedTextContainerContents(TransactStorage);
	}

	//
	ImportDescriptions(TypedTextStorage, DocDir+"\\", true);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSDocuments methods  /////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSDocuments::Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString DocsDir = nt_rec->PrepareDirName(SrcDir);

	ImportOrdering(DocsDir);

	Storage.Create(nt_rec->PrepareStorageName(ID));
	
	for( int i = 0; i < nProps; i++ )
	{
		CMMSDocument* pDoc = (CMMSDocument*)Properties[i];
		pDoc->Compile(Storage, TypedTextStorage, DocsDir);
	}
	
	Storage.Close();

}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSReport methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSReport::Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir, CString& SubStroragePrefix)
{
	CString RptDir = GetObjectDir(SrcDir);
	CString StorName;

	StorName.Format("%s%i", SubStroragePrefix, ID);
	Storage.Create(StorName);
	bool NotEmpty = ImportWorkBook(Storage, RptDir);
	Storage.Close();
	if( !NotEmpty )
		Storage.Delete(StorName);

	ImportDescriptions(TypedTextStorage, RptDir+"\\", true);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSReportList methods  /////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSReportList::Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir)
{
	CNameTableRecord* nt_rec = NameTable.Find(sID);
	CString ReportsDir = nt_rec->PrepareDirName(SrcDir);

	ImportOrdering(ReportsDir);

	Storage.Create(nt_rec->StorageName);
	CString ReportStorName = nt_rec->StorageName + "_Number";
	for( int i = 0; i < nProps; i++ )
	{
		CMMSReport* rpt = (CMMSReport*)Properties[i];
		rpt->Compile(Storage, TypedTextStorage, ReportsDir, ReportStorName);
	}
	Storage.Close();
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSJournalister methods  //////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSJournalister::Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString JournalDir = GetObjectDir(SrcDir);
	CMMSObject* Forms = GetProperty(CString("Form"));

	ImportDescriptions(TypedTextStorage, JournalDir+"\\", true);
	ImportListForms(Forms, Storage, JournalDir, nt_rec->StorageName);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSJournalisters methods  /////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSJournalisters::Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString JournalsDir = nt_rec->PrepareDirName(SrcDir);

	ImportOrdering(JournalsDir);

	Storage.Create(nt_rec->StorageName);
	for( int i = 0; i < nProps; i++ )
	{
		CMMSJournalister* pJournal = (CMMSJournalister*)Properties[i];
		pJournal->Compile(Storage, TypedTextStorage, JournalsDir);
	}

	Storage.Close();
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSCalcJournal methods  ///////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCalcJournal::Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString JournalDir = GetObjectDir(SrcDir);
	CMMSObject* Forms = GetProperty(CString("Form"));

	ImportDescriptions(TypedTextStorage, JournalDir+"\\", true);
	ImportListForms(Forms, Storage, JournalDir, nt_rec->StorageName);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSCalcJournals methods  //////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCalcJournals::Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString JournalsDir = nt_rec->PrepareDirName(SrcDir);

	ImportOrdering(JournalsDir);

	Storage.Create(nt_rec->StorageName);
	for( int i = 0; i < nProps; i++ )
	{
		CMMSCalcJournal* pJournal = (CMMSCalcJournal*)Properties[i];
		pJournal->Compile(Storage, TypedTextStorage, JournalsDir);
	}
	Storage.Close();
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSCaclAlgorithm methods  /////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCaclAlgorithm::Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir)
{
	CNameTableRecord* nt_rec_stor = NameTable.Find(Type);
	CNameTableRecord* nt_rec_file = NameTable.Find(NT_CalcAlgorithm);
	CString AlgDir = GetObjectDir(SrcDir);
	CString FileName;

//	AlgDir += "\\";
//	AlgDir += sID;

	FileName = nt_rec_file->PrepareFileName(AlgDir);
	if( FileExist(FileName) )
	{
		TypedTextStorage.Create(nt_rec_stor->PrepareStorageName(ID));
		TypedTextStorage.StreamFromFile(nt_rec_file->StorageName, FileName);
		
		CreateTypedTextContainerContents(TypedTextStorage);
		TypedTextStorage.Close();
	}

	ImportDescriptions(TypedTextStorage, AlgDir+"\\", true);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSCaclAlgorithms methods  ////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCaclAlgorithms::Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString AlgsDir = nt_rec->PrepareDirName(SrcDir);

	ImportOrdering(AlgsDir);

	for( int i = 0; i < nProps; i++ )
	{
		CMMSCaclAlgorithm* pAlg = (CMMSCaclAlgorithm*)Properties[i];
		pAlg->Compile(Storage, TypedTextStorage, AlgsDir);
	}
}

