
#include "MMS.h"
#include "NameTable.h"
#include "DLL\GComp.h"
#include "Storage.h"
#include "CommonFunctions.h"
#include "Ordering.h"
#include "MMS_Filter.h"
#include "UI.h"
#include "DialogForm.h"

///////////////////////////////////////////////////////////////////////
///////////  class CMMSObject methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSObject::ExtractString(CStorage& Storage, CString& DestDir, CString& Str, MMSObjectType Type)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	Storage.CopyStringToFile(Str, nt_rec->PrepareFileName(DestDir));
}

bool CMMSObject::ExtractMetadata(CString& DestDir, MMSObjectType Type, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);

	MMS_Filter.Down();
	bool ToExtract = MMS_Filter.Test(this, nt_rec);
	if( ToExtract )
	{
		CString Content = AsString();

		if( !nt_rec->Dir.IsEmpty() )
		{
			CString Dir = nt_rec->PrepareDirName(DestDir);
			CreateDirectory(Dir);
			ExtractDescriptions(Dir+"\\", TypedTextStorage, true);
		}
		
		CString FName = nt_rec->PrepareFileName(DestDir, this);
		TypedTextStorage.CopyStringToFile(Content, FName);
	}
	MMS_Filter.Up();
	return ToExtract;
}

void CMMSObject::ExtractMetadata(CString& DestDir, CStorage& TypedTextStorage)
{
	ExtractMetadata(DestDir, NT_MetadataPart, TypedTextStorage);
}

void CMMSObject::ExtractDescriptions(CString& FNamePrefix, CStorage& TypedTextStor, bool StdName)
{
	if( Type == MMS_Property ) return; //    

	CNameTableRecord* nt_rec_obj = NameTable.Find(Type);
	CNameTableRecord* nt_rec = NameTable.Find(NT_UserHelpStor);
	CNameTableRecord* nt_rec_file = NameTable.Find(NT_UserHelp);

	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec_obj) || MMS_Filter.Test(NULL, nt_rec_file) )
	{
		CString StorName = nt_rec->PrepareStorageName(ID);
		CString NewPrefix = FNamePrefix;
		CString Suffix;
		
		if( ID_Type != IDT_NoID && 
			(nt_rec_obj == NULL || nt_rec_obj->Type1C == "sID") )
		{
			if( ID_Type == IDT_OnlyTextual )
				Suffix.Format("%s.", sID);
			else if( ID_Type == IDT_OnlyNumeric )
				Suffix.Format("%s.%i.", nt_rec_file->FileName, ID);
			else if( sID.IsEmpty() || !IsValidFileName(sID) )
				Suffix.Format("%s.%i.", nt_rec_file->FileName, ID);
			else
				Suffix.Format("%s.", sID);
		}

		InplaceTranslit(Suffix);
		NewPrefix += Suffix;

		if( ID_Type == IDT_BothIDs && 
			!TypedTextStor.ObjectExtracted(this) && 
			TypedTextStor.StorageExist(StorName) )
		{
			CString FName;

			if( StdName || Suffix.IsEmpty() )
				FName.Format("%s%s.%s", FNamePrefix, nt_rec_file->FileName, nt_rec_file->Ext);
			else
				FName.Format("%s%s", NewPrefix, nt_rec_file->Ext);

			TypedTextStor.Open(StorName);
			TypedTextStor.CopyToFile(nt_rec_file->PrepareStorageName(ID), FName);
			TypedTextStor.AddToExtractedList(FName, this);
			TypedTextStor.Close();
		}

		for( int i = 0; i < GetNProps(); i++ )
		{
			GetPropByNum(i)->ExtractDescriptions(NewPrefix, TypedTextStor, false);
		}
	}
	MMS_Filter.Up();
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSObjectWithProps methods  ///////////////////////
///////////////////////////////////////////////////////////////////////

//     '_'.     
int MangleFileName(CString& str)
{
	char* ptr = (char*)(LPCSTR)str;
	int repl_count = 0;
	while( *ptr != '\0' )
	{
		int c = (unsigned char)(*ptr); //unsigned -    
		if( !__iscsym(c) ) { *ptr = '_'; repl_count++; };
		ptr++;
	}
	return repl_count;
}

void CMMSObjectWithProps::ExtractMoxelPages(CString& DestDir, CStorage& WBStorage)
{
	CNameTableRecord* nt_rec_mxl = NameTable.Find(NT_MoxelSheet);
	CMMSNodeList* WBContent = NULL;

	WBContent = (CMMSNodeList*)WBStorage.ParseStream(CString("Container.Contents"), false);
	if( WBContent == NULL ) return; // 

	//Analyze Container.Contents and extract moxel pages if any.
	CString std_tab_name("Moxel WorkPlace");
	CString ID_mxl("Moxcel.Worksheet");
	CString mxlFName;
	CObjectOrdering Order(3);
	
	POSITION pos = WBContent->GetHeadPosition();
	while( pos != NULL )
	{
		CMMSObject* SubNode = WBContent->GetNext(pos);
		if( SubNode->sID == ID_mxl )
		{
			CMMSObject* pMXL = SubNode->GetPropByNum(1);
			CString tab_name = (LPCSTR)pMXL->sID;
			CString page_suffix = Suffix(SubNode->GetPropByNum(0)->sID);
			if( tab_name == std_tab_name )
				tab_name = "";
			else
			{
				if( MangleFileName(tab_name) > 0 )
					Msg(2, "MXL %s replaced by %s", pMXL->sID, tab_name);
			}

			mxlFName.Format("%s.%s", tab_name, nt_rec_mxl->Ext);

			if( TaskParameters.NoEmptyMxl ) //  
			{
				long size = WBStorage.GetStreamSize(SubNode->GetPropByNum(0)->sID);
				if( size == 147 || size == 139 ) continue;
			}

			WBStorage.CopyToFile(SubNode->GetPropByNum(0)->sID, DestDir+"\\"+Translit(mxlFName));
			
			Order.Add(page_suffix, mxlFName, Translit(mxlFName), pMXL->sID);
		}
	}

	if( Order.Order.GetLength() > 0 ) Order.WriteFile(WBStorage, DestDir);

	delete WBContent;
}

void CMMSObjectWithProps::ExtractWorkBook(CString& DestDir, CStorage& Storage)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_Workbook);

	if( TaskParameters.CompoundType != external_report ) //    WorkBook,     
		if( !Storage.Open(nt_rec->StorageName) )
			return; // ,    

	CreateDirectory(DestDir); // TODO ,       CreateDirectory()?

	// 
	ExtractStreamByType(Storage, NT_FormModule, DestDir);
	// 
	if( TaskParameters.NotParseForms )
	{
		ExtractStreamByType(Storage, NT_DialogForm, DestDir);
	}
	else
	{
		CNameTableRecord* nt_rec_dlg = NameTable.Find(NT_DialogForm);
		MMS_Filter.Down();
		if( MMS_Filter.Test(this, nt_rec_dlg) )
		{
			CMMSObject* dlg_form = Storage.ParseStream(nt_rec_dlg->PrepareStorageName(), true);
			if( dlg_form != NULL )
			{
				//extracting as beautiful formated string
				Msg(2, "Form of: %i, %s", ID, sID);
				CDialogForm DialogForm;
				DialogForm.FromMMSObject(dlg_form);
				DialogForm.WriteToFile(Storage, nt_rec_dlg->PrepareFileName(DestDir));
				delete dlg_form;
			}
			else //-    -     
			{
				ExtractStreamByType(Storage, NT_DialogForm, DestDir);
			}
		}
		MMS_Filter.Up();
	}

	// 
	MMS_Filter.Down();
	if( MMS_Filter.Test(CString("")) || MMS_Filter.Test(CString("MoxelPages")) )
	{
		ExtractMoxelPages(DestDir, Storage);

		//Container.Profile     ,     
		CString ContProfName = "Container.Profile";
		if( Storage.OpenStream(ContProfName) )
		{
			//      ,      
			//  - ,   {"MoxelName","",""}
			CString EmptyHeader = "{\n{\"MoxelName\",\"\",\"\"},\n{\"MoxelPos\"";
			if( 0 != Storage.CompareWithString(EmptyHeader) )
			{
				Storage.CopyToFile(DestDir+"\\"+ContProfName);
			}
			Storage.CloseStream();
		}
	}
	MMS_Filter.Up();

	if( TaskParameters.CompoundType != external_report )
		Storage.Close();
}

void CMMSObjectWithProps::ExtractListForms(CMMSObject* Forms, CString& Dir, CStorage& Storage, CString Prefix)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_ListForm);
	CString StorName;

	for( int i = 0; i < Forms->GetNProps(); i++ )
	{
		CMMSObject* Form = Forms->GetPropByNum(i);
		MMS_Filter.Down();
		if( MMS_Filter.Test(Form, nt_rec) || MMS_Filter.Test(CString("")) )
		{
			CString FormDir;
			FormDir.Format("%s\\%s.%s", Dir, Translit(Form->sID), nt_rec->Ext);
			
			StorName.Format("%s%i", Prefix, Form->ID);
			if( Storage.Open(StorName) )
			{
				ExtractWorkBook(FormDir, Storage);
				Storage.Close();
			}
		}
		MMS_Filter.Up();
	}
}

void CMMSObjectWithProps::ExtractStreamByType(CStorage& Storage, MMSObjectType Type, CString& Dir)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);

	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec) )
	{
		CStorage SubStorage(Storage);
		SubStorage.CopyToFile(nt_rec->PrepareStorageName(ID), nt_rec->PrepareFileName(Dir));
	}
	MMS_Filter.Up();
}

void CMMSObjectWithProps::ExtractOrdering(CStorage& Storage, CString& DestDir)
{
	if( TaskParameters.NoOrdering ) return;

	int nProps = GetNProps();
	if( nProps == 0 ) return;

	CObjectOrdering Order(2);

	for( int i = 0; i < nProps; i++ )
	{
		CMMSObject* obj = GetPropByNum(i);
		Order.Add(obj->ID, obj->sID, obj->sID);
	}

	Order.WriteFile(Storage, DestDir);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMS methods  //////////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMS::ExtractStorage(CString& Dir, CStorage& Storage, MMSObjectType Type, bool WithContainerCOntents)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);

	MMS_Filter.Down();
	if( MMS_Filter.Test(NULL, nt_rec) )
	{
		CString DestDir = nt_rec->PrepareDirName(Dir);
		CStorage SrcStorage(Storage);

		if( SrcStorage.Open(nt_rec->PrepareStorageName(ID)) )
		{
			CreateDirectory(DestDir);
			if( !SrcStorage.Extract(DestDir, WithContainerCOntents) ) remove(DestDir);
		}
	}
	MMS_Filter.Up();
}

void CMMS::ExtractCommonMXL(CString& Dir, CStorage& Storage)
{
	CNameTableRecord* nt_rec_gd = NameTable.Find(NT_GlobalData);
	CNameTableRecord* nt_rec = NameTable.Find(NT_CommonMXL);

	MMS_Filter.Down();
	if( MMS_Filter.Test(NULL, nt_rec) )
	{
		CString GDDir = nt_rec->PrepareDirName(Dir);
		
		CString StorName = nt_rec_gd->StorageName;
		StorName += "\\";
		StorName += nt_rec->StorageName;
		
		CStorage GDStorage(Storage);
		if( GDStorage.Open(StorName) )
		{
			ExtractWorkBook(GDDir, GDStorage);
		}
	}
	MMS_Filter.Up();
}


void CMMS::DeleteUnusedObjects(CStorage& Storage)
{
	int i;

	for( i = 0; i < GetNProps(); i++ )
		GetPropByNum(i)->Used = true;


	CMMSObject* frm = Storage.ParseStream(NameTable.Find(NT_DialogForm)->PrepareStorageName(0), false);
	if( frm == NULL )
		return;

	CMMSObject* Controls = frm->GetProperty((CString("Controls")));
	for( i = 0; i < Controls->GetNProps(); i++ )
	{
		int nProps = Controls->GetPropByNum(i)->GetNProps();
		CString& sWndClass = Controls->GetPropByNum(i)->GetPropByNum(0)->sID;
		CString sTypeLetter, sTypeID;
		if( isdigit(sWndClass[0]) ) // ,  1    ?!
		{
			sTypeLetter = Controls->GetPropByNum(i)->GetPropByNum(12)->sID;
			sTypeID = Controls->GetPropByNum(i)->GetPropByNum(15)->sID;
		}
		else
		{
			sTypeLetter = Controls->GetPropByNum(i)->GetPropByNum(13)->sID;
			sTypeID = Controls->GetPropByNum(i)->GetPropByNum(16)->sID;
		}

		int ID = atoi(sTypeID);
		if( ID != 0 ) 
			MarkUsed(ID);
	}

	for( i = 0; i < GetNProps(); i++ )
	{
		if( GetPropByNum(i)->Type == MMS_Buh ) continue;
		if( GetPropByNum(i)->Type == MMS_TaskItem ) continue;
		GetPropByNum(i)->DeleteUnused();
	}

	delete frm;
}

void CMMS::ExtractPictureGallery(CString& Dir, CStorage& Storage)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_PictureGallery);
	CString DestDir = nt_rec->PrepareDirName(Dir);
	CStorage SrcStorage(Storage);

	if( SrcStorage.Open(nt_rec->PrepareStorageName(ID)) )
	{
		CreateDirectory(DestDir);
		if( !SrcStorage.Extract(DestDir, false) ) remove(DestDir);
	}
}

void CMMS::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	//       -      -
	//  
	CMMSDescr* Descr = (CMMSDescr*)GetPropByNum(0);
	Descr->MD_ver = 10009;
	// CRC
	int crc_num;
	GetProperty(CString("CRC"), false, &crc_num);
	if( crc_num >= 0 ) DelProperty(crc_num);

	if( TaskParameters.CompoundType == external_report	)
	{
		//DeleteUnusedObjects(Storage);
		if( TaskParameters.TruncateMMS )
			ExtractString(Storage, Dir, CString(MinimalMMS()), NT_MainMetadataStream);
		else
			ExtractMetadata(Dir, TypedTextStorage);
		ExtractWorkBook(Dir, Storage);
		ExtractStreamByType(Storage, NT_ErtUserHelp, Dir);
		ExtractStorage(Dir, Storage, NT_PictureGallery, false);
		return;
	}

	int nProps = GetNProps();
	for( int i = 0; i < nProps; i++ )
	{
		CMMSObject *obj = GetPropByNum(i);
		obj->Decompile(Dir, Storage, TypedTextStorage);
	}

	// 
	ExtractStreamByType(TypedTextStorage, NT_GlobalModule, Dir);
	// 
	ExtractCommonMXL(Dir, Storage);
	
	//
	//ExtractPictureGallery(Dir, Storage);
	ExtractStorage(Dir, Storage, NT_PictureGallery, false);

	// 
	DecompileUI(Dir, Storage);
	// 
	ExtractStorage(Dir, Storage, NT_UserRights, true);

	// 
	ExtractStreamByType(Storage, NT_GUIDData, Dir);
	ExtractStreamByType(Storage, NT_TagStream, Dir);

	//
	CNameTableRecord* nt_rec_descr = NameTable.Find(NT_UserHelpStor);
	CString DescrDir = nt_rec_descr->PrepareDirName(Dir);
	ExtractDescriptions(DescrDir+"\\", TypedTextStorage, false);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSMetadataPart methods  //////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSMetadataPart::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);

	if( TaskParameters.MetadataBySubfolders && 
		nt_rec->sID == sID && !nt_rec->Dir.IsEmpty() )
	{
		if( nProps == 0 ) return;

		MMS_Filter.Down();
		if( MMS_Filter.Test(this, nt_rec) )
		{
			CString MdpDir = nt_rec->PrepareDirName(Dir, this);
			CreateDirectory(MdpDir);

			for( int i = 0; i < nProps; i++ )
			{
				CMMSMetadataPart* pMdp = (CMMSMetadataPart*)Properties[i];
				MMS_Filter.Down();
				if( MMS_Filter.Test(pMdp, NULL) )
				{
					CString MdpSubDir;
					MdpSubDir.Format("%s\\%s", MdpDir, pMdp->sID);
					CreateDirectory(MdpSubDir);
					pMdp->ExtractMetadata(MdpSubDir, NT_MetadataPart, TypedTextStorage);
					pMdp->ExtractDescriptions(MdpSubDir+"\\", TypedTextStorage, true);
				}
				MMS_Filter.Up();
			}

			ExtractOrdering(Storage, MdpDir);
		}
		MMS_Filter.Up();
	}
	else
	{
		if( ExtractMetadata(Dir, Type, TypedTextStorage) )
			Msg(2, "%s", sID);
	}
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSSubCnt methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSSbCnt::Decompile(CString& BaseDir, CStorage& Storage, CStorage& TypedTextStorage, CStorage& SubFolderStorage, CStorage& SubListStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	
	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec) )
	{

		CStorage ScStorage(Storage);
		CString ScDir = GetObjectDir(BaseDir);
		CString StorName;

		CreateDirectory(ScDir);

		Msg(2, " %s", sID);

		//
		ExtractMetadata(ScDir, TypedTextStorage);
		//
		ExtractDescriptions(ScDir+"\\", TypedTextStorage, true);

		// 
		if( ScStorage.Open(nt_rec->PrepareStorageName(ID)) ) //    ,     
		{
			ExtractWorkBook(ScDir, ScStorage);
		}

		// 
		nt_rec = NameTable.Find(NT_SubcontoFolder);
		MMS_Filter.Down();
		if( MMS_Filter.Test(NULL, nt_rec) )
		{
			CStorage GroupStorage(SubFolderStorage);
			if( GroupStorage.Open(nt_rec->PrepareStorageName(ID)) != NULL )
			{
				CString SubFldDir = nt_rec->PrepareDirName(ScDir);
				CreateDirectory(SubFldDir);
				ExtractWorkBook(SubFldDir, GroupStorage);
			}
		}
		MMS_Filter.Up();

		// 
		nt_rec = NameTable.Find(NT_SubcontoListForm);
		CMMSObject* ListForms = GetProperty(CString("Form"));
		ExtractListForms(ListForms, ScDir, SubListStorage, nt_rec->StorageName);
	}

	MMS_Filter.Up();
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSSbCnts methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSSbCnts::Decompile(CString& BaseDir, CStorage& Storage, CStorage& TypedTextStorage)
{
	if( nProps == 0 ) return;

	CNameTableRecord* nt_rec = NameTable.Find(Type);

	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec) )
	{
		CStorage ScsStorage(Storage,       nt_rec->StorageName);
		CStorage SubFolderStorage(Storage, "SubFolder");
		CStorage SubListStorage(Storage,   "SubList");
		CString  ScsDir = nt_rec->PrepareDirName(BaseDir);

		CreateDirectory(ScsDir);

		for( int i = 0; i < nProps; i++ )
		{
			CMMSSbCnt* pSc = (CMMSSbCnt*)Properties[i];
			pSc->Decompile(ScsDir, ScsStorage, TypedTextStorage, SubFolderStorage, SubListStorage);
		}

		ExtractOrdering(Storage, ScsDir);
	}
	MMS_Filter.Up();
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSDocument methods  //////////////////////////////
///////////////////////////////////////////////////////////////////////

void CMMSDocument::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);

	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec) )
	{
		CStorage TransactStorage(TypedTextStorage);
		
		Msg(2, " %s", sID);
		//   
		CString DocDir = GetObjectDir(Dir);	
		CreateDirectory(DocDir);

		// ,   
		if( Storage.Open(nt_rec->PrepareStorageName(ID)) ) //    ,     
		{
			ExtractWorkBook(DocDir, Storage);
			Storage.Close();
		}

		// 
		CNameTableRecord* nt_rec_stor = NameTable.Find(NT_TransModuleStor);
		nt_rec = NameTable.Find(NT_TransactModule);
		MMS_Filter.Down();
		if( MMS_Filter.Test(NULL, nt_rec) )
		{
			if( TransactStorage.Open(nt_rec_stor->PrepareStorageName(ID)) )
			{
				TransactStorage.CopyToFile(nt_rec->StorageName, nt_rec->PrepareFileName(DocDir));
			}
		}
		MMS_Filter.Up();

		ExtractMetadata(DocDir, TypedTextStorage);
		ExtractDescriptions(DocDir+"\\", TypedTextStorage, true);
	}
	MMS_Filter.Up();
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSDocuments methods  /////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSDocuments::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	if( nProps == 0 ) return;

	CNameTableRecord* nt_rec = NameTable.Find(Type);

	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec) )
	{
		CString DocsDir = nt_rec->PrepareDirName(Dir);

		CreateDirectory(DocsDir);

		Storage.Open(nt_rec->PrepareStorageName(ID));
		for( int i = 0; i < nProps; i++ )
		{
			CMMSDocument* pDoc = (CMMSDocument*)Properties[i];
			pDoc->Decompile(DocsDir, Storage, TypedTextStorage);
		}
		Storage.Close();

		ExtractOrdering(Storage, DocsDir);
	}
	MMS_Filter.Up();
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSReport methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSReport::Decompile(CString& Dir, CStorage& Storage, CString& Prefix, CStorage& TypedTextStorage)
{
	MMS_Filter.Down();
	if( MMS_Filter.Test(this, NULL) )
	{
		CString StorName;

		Msg(2, " () %s", sID);

		CString RptDir = GetObjectDir(Dir);
		CreateDirectory(RptDir);
		
		StorName.Format("%s%i", Prefix, ID);
		if( Storage.Open(StorName) )
		{
			ExtractWorkBook(RptDir, Storage);
			Storage.Close();
		}

		ExtractMetadata(RptDir, TypedTextStorage);
		ExtractDescriptions(RptDir+"\\", TypedTextStorage, true);
	}
	MMS_Filter.Up();
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSReportList methods  /////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSReportList::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	if( nProps == 0 ) return;

	CNameTableRecord* nt_rec = NameTable.Find(sID);

	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec) )
	{
		CString ReportsDir = nt_rec->PrepareDirName(Dir);

		CreateDirectory(ReportsDir);

		if( Storage.Open(nt_rec->StorageName) )
		{
			CString ReportStorName = nt_rec->StorageName + "_Number";
			for( int i = 0; i < nProps; i++ )
			{
				CMMSReport* rpt = (CMMSReport*)Properties[i];
				rpt->Decompile(ReportsDir, Storage, ReportStorName, TypedTextStorage);
			}
			Storage.Close();
		}

		ExtractOrdering(Storage, ReportsDir);
	}
	MMS_Filter.Up();
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSJournalister methods  //////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSJournalister::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);

	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec) )
	{
		CString JournalDir = GetObjectDir(Dir);
		CMMSObject* Forms = GetProperty(CString("Form"));
		CreateDirectory(JournalDir);

		ExtractMetadata(JournalDir, TypedTextStorage);
		ExtractDescriptions(JournalDir+"\\", TypedTextStorage, true);

		ExtractListForms(Forms, JournalDir, Storage, nt_rec->StorageName);
	}
	MMS_Filter.Up();
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSJournalisters methods  /////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSJournalisters::Decompile(CString& SrcDir, CStorage& Storage, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);

	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec) )
	{
		CString JournalsDir = nt_rec->PrepareDirName(SrcDir);

		CreateDirectory(JournalsDir);

		Storage.Open(nt_rec->StorageName);
		for( int i = 0; i < nProps; i++ )
		{
			CMMSJournalister* pJournal = (CMMSJournalister*)Properties[i];
			pJournal->Decompile(JournalsDir, Storage, TypedTextStorage);
		}
		Storage.Close();

		ExtractOrdering(Storage, JournalsDir);
	}
	MMS_Filter.Up();
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSCalcJournal methods  ///////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCalcJournal::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);

	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec) )
	{
		CString JournalDir = GetObjectDir(Dir);
		CMMSObject* Forms = GetProperty(CString("Form"));
		CreateDirectory(JournalDir);

		ExtractMetadata(JournalDir, TypedTextStorage);
		ExtractDescriptions(JournalDir+"\\", TypedTextStorage, true);

		ExtractListForms(Forms, JournalDir, Storage, nt_rec->StorageName);
	}
	MMS_Filter.Up();
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSCalcJournals methods  //////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCalcJournals::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	if( nProps == 0 ) return;

	CNameTableRecord* nt_rec = NameTable.Find(Type);

	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec) )
	{
		CString JournalsDir = nt_rec->PrepareDirName(Dir);

		CreateDirectory(JournalsDir);

		Storage.Open(nt_rec->StorageName);
		for( int i = 0; i < nProps; i++ )
		{
			CMMSCalcJournal* pJournal = (CMMSCalcJournal*)Properties[i];
			pJournal->Decompile(JournalsDir, Storage, TypedTextStorage);
		}
		Storage.Close();

		ExtractOrdering(Storage, JournalsDir);
	}
	MMS_Filter.Up();
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSCaclAlgorithm methods  /////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCaclAlgorithm::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec_stor = NameTable.Find(Type);

	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec_stor) )
	{
		Msg(2, "  %s", sID);
		CString AlgDir = GetObjectDir(Dir);
		CreateDirectory(AlgDir);

		ExtractMetadata(AlgDir, TypedTextStorage);

		// 
		CNameTableRecord* nt_rec = NameTable.Find(NT_CalcAlgorithm);
		MMS_Filter.Down();
		if( MMS_Filter.Test(NULL, nt_rec) )
		{
			if( TypedTextStorage.Open(nt_rec_stor->PrepareStorageName(ID)) )
			{
				TypedTextStorage.CopyToFile(nt_rec->StorageName, nt_rec->PrepareFileName(AlgDir));
				TypedTextStorage.Close();
			}
		}
		MMS_Filter.Up();

		//
		ExtractDescriptions(AlgDir+"\\", TypedTextStorage, true);
	}
	MMS_Filter.Up();
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMSCaclAlgorithms methods  ////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSCaclAlgorithms::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	if( nProps == 0 ) return;

	CNameTableRecord* nt_rec = NameTable.Find(Type);

	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec) )
	{
		CString AlgsDir = nt_rec->PrepareDirName(Dir);

		CreateDirectory(AlgsDir);

		for( int i = 0; i < nProps; i++ )
		{
			CMMSCaclAlgorithm* pAlg = (CMMSCaclAlgorithm*)Properties[i];
			pAlg->Decompile(AlgsDir, Storage, TypedTextStorage);
		}

		ExtractOrdering(Storage, AlgsDir);
	}
	MMS_Filter.Up();
}

