
#ifndef STORAGE_H
#define STORAGE_H


#include "Declarations.h"
#include "StreamInfo.h"

class CStorage
{
protected:
	CList<IStorage*, IStorage*&> Storages;
	bool IsRootStorage;
	void Push(IStorage* pStorage);
	IStorage* Pop();

	//-   ,    . 
	//       
	CMapStringToPtr* ExtractedFiles;
	//. - .        
	CMapPtrToPtr*    ExtractedObjects;

public:
	IStream* pStream;
	CString StreamName;
	CStreamInfo StreamInfo;

private:
	void SetParentStorage(CStorage& Storage);
public:
	CStorage();
	CStorage(CStorage& Storage);
	//       ,   SubStorage
	//     -     
	CStorage(CStorage& Storage, CString SubStorage);
	~CStorage();

public:
	CString FullPath();

	bool OpenCompound(CString& CompoundFileName);
	bool Open(CStringArray* StorageName);
	bool Open(CString& StorageName);
	bool CreateCompound(CString& CompoundFileName);
	bool Create(CStringArray* StorageName);
	bool Create(CString& StorageName);
	bool Delete(CString& StorageName);
	void Close(bool CloseAll = false);
	
	bool OpenStream(CString& StreamName);
	bool CreateStream(CString& StreamName);
	void CloseStream();

	bool StorageExist(CString& StorageName);
	bool StreamExist(CString& StreamName);
	long GetStreamSize(CString& StreamName);

	void Rewind();

	void GetCleanStream();
	bool CopyToFile(FILE* File, unsigned long bytes_to_copy);
	bool CopyToFile(CString& FileName, bool OnlyRestOfSream = false);
	bool CopyToFile(CString& StreamName, CString& FileName);
	bool Extract(CString& DestDir, bool WithContainerContents = true);
	bool CopyStringToFile(CString& String, CString& FileName);

	bool StreamFromFile(CString& StreamName, CString& FileName);
	bool StreamFromString(CString StreamName, CString& String);

	unsigned long AppendFile(IStream* pStream, FILE* File);
	unsigned long AppendFile(IStream* pStream, CString& FileName);
	void AddZeroByte();

	bool FromFile(CString& FileName);
	bool FromFile(FILE* File, LPCSTR FileName = NULL);
	bool StorageFromDir(CString& StorageName, CString& SrcDir);

	//     .    
	//  (  ,    ).   bytes_to_compare > 0, 
	//     .    -   
	//   .
	int Compare(FILE* File, unsigned long bytes_to_compare);
	int Compare(CString& FileName, unsigned long bytes_to_compare);
	int CompareWithString(CString& str2);
	//    (   )
	int FullCompare(CString& FileName);

	IStorage* GetStorage();

	CMMSObject* ParseStream(CString& StreamName, bool ParseWitnNoIDs);

	void AddToExtractedList(CString& FullFName, void* object);
	bool ObjectExtracted(void* object);
	void PruneDirectory(CString& Path);

private:
	void ReleaseMaps();
	void WriteSizeToStream(IStream* pStream);
	bool ExtractPictureGallery(CString& FileName);
	
	bool GalleryImported; // -    Gallery 3 
	bool ImportPictureGallery(CString& StreamName, CString& FileName);
};



LPCSTR GetStgErrorString(HRESULT err);

ULARGE_INTEGER GetStreamSize(IStream* pStream);

IStorage* OpenStorage(IStorage* pParentStorage, wchar_t* wStorName);
IStorage* OpenStorage(IStorage* pParentStorage, CString& StorName);

IStream* OpenStream(IStorage* pParentStorage, wchar_t* wStreamName);
IStream* OpenStream(IStorage* pParentStorage, CString& StreamName);

bool StringDifferFromFile(CString& String, CString& FileName);
bool CopyStringToFile(CString& String, CString& FileName);

#endif