#!/usr/bin/perl

#==============================================================================================================
#     .  ,    ""  
#   .        ,    .
#      human-readable , ..  gcomp  
#   2.0.10,   --no-parse-dialogs
#==============================================================================================================


$usage = <<EOF
:
   perl correct_dlg.pl []
  :
   -h        -  
   -miny <n> -  Y-  .       
               Y-  ,        (minY - minItemY)
   -d <dir>  - ,      (*.frm).      
                .
   -k        -    ,     *.new.frm
EOF
;

#default values
$min_y = 17;
$root_dir = ".";
$keep_old = 0;

#command line args processing
$argc = scalar @ARGV;
$i = 0;
while( $i < $argc )
{
	if( $ARGV[$i] eq "-miny" )
	{
		$i++;
		$min_y = $ARGV[$i];
	}
	elsif( $ARGV[$i] eq "-d" )
	{
		$i++;
		$root_dir = $ARGV[$i];
	}
	elsif( $ARGV[$i] eq "-k" )
	{
		$keep_old = 1;
	}
	else
	{
		die "$usage";
	}
	$i++;	  
}

#traverse through dirs and do work
use File::Find; #package    
find(\&CorrectDialog, $root_dir);

sub CorrectDialog
{
	my $name = $_; #File::Find   $_   
	return unless $name =~ m/^(.*)(\.frm)$/i; #      frm
	
	my $new_name = "$1.new.frm";
	my $line, $dlg_min_y, $y, $dlg_height;

	$dlg_min_y = $min_y + 10;
	open DLG, "< $name";
	foreach $line (<DLG>)
	{
		if( $line =~ m/^\s*:\s*(\d+).*$/ and !defined $dlg_height )
		{
			$dlg_height = $1;
		}
		elsif( $line =~ m/^\s*Y:\s*(\d+).*$/ )
		{
			$y = $1;
			$dlg_min_y = $y if $y < $dlg_min_y;
		}
	}
	close DLG;

	return if $dlg_min_y >= $min_y;
	$v_shift = $min_y - $dlg_min_y;

	print $File::Find::name, "\n   min. Y = ", $dlg_min_y, ",  = ", $v_shift, "\n";

	my $height;
	open DLG, "< $name";
	open DLG_NEW, "> $new_name";
	foreach $line (<DLG>)
	{
		$line =~ s/[\r\n]//g; #  \n  \r,    
		
		if( $line =~ m/^(\s*:\s*)(\d+)(.*)$/ )
		{
			if( $height == 0 )
			{
				$height = $2 + $v_shift;
			}
			else
			{
				$height = $2;
			}
			$line = sprintf "%s%i%s\n", $1, $height, $3;
		}
		elsif( $line =~ m/^(\s*Y:\s*)(\d+)(.*)$/ )
		{
			$line = sprintf "%s%i%s\n", $1, $2 + $v_shift, $3;
		}
		printf DLG_NEW "%s\n", $line;
	}
	close DLG;
	close DLG_NEW;

	if( not $keep_old )
	{
		if( !rename($new_name, $name) )
		{
			print "Can't move $new_name to $name: $!\n"
		}	
	}
}
