# vim:fileencoding=cp1251
#
# ExtractProc
# Author: Alexander S. Gordienko <alex-go@vstu.kirov.ru>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import sys, getopt, re, os, os.path, string

ProcRegExp = r'(?P<all>(?P<rem>^[ \t]*//\*+(?:\s*//.*)*\s*)?\n?[ \t]*' + \
             r'(?:|)\s+(?P<name>[0-9a-zA-Z--_]+)\s*' + \
             r'\([^\)]*\)\s*(?:)?\s*;?(?://.*)?\s*\r\n' + \
             r'(?:.*\r\n)*?' + \
             r'(?:|).*$)'

def ExtractOld(BasePath, fnModule, ExtractPath):
    if fnModule == '':
        if BasePath == '':
            BasePath = r'.\Src'
        fnModule = os.path.join(BasePath, r'.1s')

    if ExtractPath == '':
        ExtractPath = os.path.splitext(fnModule)[0]

    if BasePath == '':
        BasePath = os.path.split(ExtractPath)[0]

    if not os.path.exists(ExtractPath):
        os.mkdir(ExtractPath)

    Module = open(fnModule, 'rb').read()
    newModule = ''

    proc = re.compile(ProcRegExp, re.MULTILINE)

    if True in map(lambda x:string.find(Module, x)!=-1, ['', '', '', '', '', '']):
        res = proc.search(Module)

        while None != res:
            print unicode(string.split(ExtractPath, BasePath)[1] + '.' + res.group('name'), 'windows-1251')
            open(os.path.join(ExtractPath, res.group('name') + '.txt'), 'wb').write(res.group('all'))
            newModule = newModule + Module[:res.span()[0]] + '//### ' + res.group('name') + '.txt'
            Module = Module[res.span()[1]:]
            if True in map(lambda x:string.find(Module, x)!=-1, ['', '', '', '', '', '']):
                res = proc.search(Module)
            else:
                res = None
                
    newModule = newModule + Module
    open(os.path.join(ExtractPath, os.path.split(ExtractPath)[1] + '.1ss'), 'wb').write(newModule)

def Extract(BasePath, fnModule, ExtractPath):
    if fnModule == '':
        if BasePath == '':
            BasePath = r'.\Src'
        fnModule = os.path.join(BasePath, r'.1s')

    if ExtractPath == '':
        ExtractPath = os.path.splitext(fnModule)[0]

    if BasePath == '':
        BasePath = os.path.split(ExtractPath)[0]

    if not os.path.exists(ExtractPath):
        os.mkdir(ExtractPath)

    Module = string.split(open(fnModule, 'rb').read(), os.linesep)
    newModule = ''

    headRem     = re.compile(r'^\s*//\*+\s*$', re.I)
    bodyRem     = re.compile(r'(^\s*//.*$|^\s*$)', re.I)
    forvardProc = re.compile(r'^\s*(?:|)\s+(?P<name>[0-9a-zA-Z--_]+)\s*' + \
                             r'\([^\)]*\)\s*(?:)?\s*(?:)', re.I)
    headProc    = re.compile(r'^\s*(?:|)\s+(?P<name>[0-9a-zA-Z--_]+)', re.I)
    tailProc    = re.compile(r'^\s*(?:|).*$', re.I)
    
    State = 0
    LineNum = 0
    beginScope = 0
    endScope = 0
    procName = ''
    
    for line in Module:
        head = string.join(Module[LineNum:LineNum+10])
        if 0 == State:
            tmp = headProc.match(line)
            if (None == forvardProc.match(head)) and (None != tmp):
                State = 2
                procName = tmp.group('name')
                beginScope = LineNum            
            elif None != headRem.match(line):
                State = 1
                beginScope = LineNum            
        elif 1 == State:
            tmp = headProc.match(line)
            if (None == forvardProc.match(head)) and (None != tmp):
                State = 2
                procName = tmp.group('name')
            elif None == bodyRem.match(line):
                State = 0
        elif 2 == State:
            if None != tailProc.match(line):
                State = 0
                newModule = newModule + string.join(Module[endScope:beginScope], os.linesep) + \
                            os.linesep + '//### ' + procName + '.txt' + os.linesep
                endScope = LineNum + 1
                #print unicode(string.split(ExtractPath, BasePath)[1] + '.' + procName, 'windows-1251')
                print ExtractPath, procName
                open(os.path.join(ExtractPath, procName + '.txt'),
                     'wb').write(string.join(Module[beginScope:endScope], os.linesep))
        LineNum += 1            

    newModule = newModule + string.join(Module[endScope:], os.linesep)
    open(os.path.join(ExtractPath, os.path.split(ExtractPath)[1] + '.1ss'), 'wb').write(newModule)

def visit(arg, dir, names):
    for name in names:
        namePath = os.path.join(dir, name)
        if (os.path.exists(namePath)) and (os.path.splitext(namePath)[1] in ('.1s', '.1S')):
            Extract(arg, namePath, '')

def main():
    try:
        opts, args = getopt.getopt(sys.argv[1:],
                                   'hemp:f:b:',
                                   ['help', 'extract',
                                    'make', 'extract_path=',
                                    'file=', 'base_path='])
    except getopt.GetoptError:
        usage()
        sys.exit(2)

    global fnModule, ExtractPath

    Action = 0    
    BasePath = ''
    fnModule = ''
    ExtractPath = ''
    ProcessAll = 0
    
    for o, a in opts:
        if o in ('-h', '--help'):
            usage()
            sys.exit()
        elif o in ('-e', '--extract'):
            Action = 1
        elif o in ('-m', '--make'):
            Action = 2
        elif o in ('-p', '--extract_path'):
            ExtractPath = os.path.abspath(a)
        elif o in ('-f', '--file'):
            fnModule = os.path.abspath(a)
        elif o in ('-b', '--base_path'):
            BasePath = os.path.abspath(a)
            ProcessAll = 1
        else:
            usage()
            sys.exit(2)

    if Action == 1:
        if ProcessAll == 1:
            os.path.walk(BasePath, visit, BasePath)
        else:          
            Extract(BasePath, fnModule, ExtractPath)
    elif Action == 2:
        print u'   :-)'
    else:
        usage()
        sys.exit(2)

def usage():
    print u"""
: ExtractProc.py {-e|-m|-h} [-b <base_path> | [-f <file>] [-p <extract_path>]] 

:
    -h | --help         -  
    -e | --extract      -  /  
    -m | --make         -  /  
    -f | --file         -  
    -p | --extract_path -   
    -b | --base_path    -    gcomp 
                            (  *.1s)

:
    ExtractProc.py -e -f .\Src\.1s -p .\Src\
    ExtractProc.py -e -f .\Src\\\.1s
    ExtractProc.py -e -b .\Src
"""
if __name__ == '__main__':
    main()
