# vim:fileencoding=cp1251
#
# ExtractProc
# Author: Alexander S. Gordienko <alex-go@vstu.kirov.ru>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import sys, getopt, re, os, os.path

ProcRegExp = r'(?P<all>(?P<rem>^[ \t]*//\*+(?:\s*//.*)*\s*)?\n?[ \t]*' + \
            r'(?:|)\s+(?P<name>[0-9a-zA-Z--_]+)\s*' + \
            r'\([^\)]*\)\s*(?:)?\s*;?\s*\r\n' + \
            r'(?:.*\r\n)*?' + \
            r'(?:|).*$)'

def Extract():
   if not os.path.exists(ExtractPath):
       os.mkdir(ExtractPath)

   glob = open(fnModule, 'rb').read()
   newglob = ''

   proc = re.compile(ProcRegExp, re.MULTILINE)

   res = proc.search(glob)

   while None != res:
       print res.group('name')
       #print unicode(res.group('name'), 'windows-1251')
       open(os.path.join(ExtractPath, res.group('name') + '.txt'), 'wb').write(res.group('all'))
       newglob = newglob + glob[:res.span()[0]] + '//### ' + res.group('name') + '.txt'
       glob = glob[res.span()[1]:]
       res = proc.search(glob)

   open(os.path.join(ExtractPath, os.path.split(ExtractPath)[1] + '.1s'), 'wb').write(newglob)

def main():
   try:
       opts, args = getopt.getopt(sys.argv[1:],
                                  'hemp:f:',
                                  ['help', 'extract',
                                   'make', 'extract_path=', 'file='])
   except getopt.GetoptError:
       usage()
       sys.exit(2)

   global fnModule, ExtractPath

   Action = 0    
   Path = r'.\Src'
   fnModule = os.path.join(Path, r'.1s')
   ExtractPath = ''
   
   for o, a in opts:
       if o in ('-h', '--help'):
           usage()
           sys.exit()
       elif o in ('-e', '--extract'):
           Action = 1
       elif o in ('-m', '--make'):
           Action = 2
       elif o in ('-p', '--extract_path'):
           ExtractPath = os.path.abspath(a)
       elif o in ('-f', '--file'):
           fnModule = os.path.abspath(a)
       else:
           usage()
           sys.exit(2)

   if ExtractPath == '':
       ExtractPath = os.path.splitext(fnModule)[0]

   if Action == 1:
       Extract()
   elif Action == 2:
       print u'   :-)'
   else:
       usage()
       sys.exit(2)

def usage():
   print u"""
: ExtractProc.py <>

:
   -h | --help         -  
   -e | --extract      -  /  
   -m | --make         -  /  
   -f | --file         -  
   -p | --extract_path -   

:
   ExtractProc.py -e -f .\Src\.1s -p .\Src\
   ExtractProc.py -e -f .\Src\\\.1s
"""
if __name__ == '__main__':
   main()
