package CodeWorks;

#==============================================================================================================
#        .
#  ,     .
#      ,    .
# 
#==============================================================================================================
# -   mailto:adirks@ngs.ru
#
#     .  
#  ()     GNU Generic Public License.
#
#      , 
# - ,         
#-   .
#
#          
#http://www.gnu.org/licenses/gpl.txt   
#gnugpl.eng.txt
#
#       
#http://gnu.org.ru/gpl.html   
#gnugpl.rus.txt
#
#    GNU Generic Public License     .
#    -     (mailto:adirks@ngs.ru , mailto:fe@alterplast.ru)  
#Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA


our @ISA = qw(Exporter);
our @EXPORT = qw(ProcessModule);

use locale;
use strict "vars";

# ,       
our( 
	$first_proc,		#       
	$last_proc,			#       
	$last_proc_end,		#       
	$last_var,			#   
	$first_code,		#    (  /)
	$first_line_for_ins,# ,     
	$last_line_for_ins, # ,    
	$proc_start,		#   
	$proc_end,			#   
	$proc_body,			#   
	$line_count,		#   
	@lines				#  
);


my $proc_pattern = '^\s*(|Procedure||Function)\s+([\w\d]*)\s*\((.*)\)\s*(\w*).*$';
my $endproc_pattern = '^\s*(\s.*)*$';
my $var_pattern = '^\s*(|Var)\s+([^;]+);.*$';

sub ProcessModule($$)
{
    my $name = shift;
    my $proc = shift;
	my $in_proc = 0;
	my $proc_name = "";

	$first_proc = 0;
	$last_proc = 0;
	$last_proc_end = 0;
	$last_var = 0;
	$first_code = 0;
	$first_line_for_ins = 0;
	$last_line_for_ins = 0;
	$proc_start = 0;
	$proc_end = 0;
	$proc_body = "";
	@lines = ();
	my $i = 0;
	my $line;

	open MODULE, "<$name";
	foreach $line (<MODULE>)
	{
		$lines[$i] = $line;
		$proc_body .= $line if( $proc_start and not $proc_end );

		$line =~ s/[\r\n]//g; #  \n  \r,    

		if( $first_proc == 0 )
		{
			if( $line =~ m/$proc_pattern/i )
			{
				my $fwd = lc($4);
				if( $fwd ne "forward" and $fwd ne "" )
				{
					$proc_name = $2;
					$first_proc = $i;
					$last_proc = $i;
					$in_proc = 1;
				}
				
			}
			elsif( $line =~ m/$var_pattern/i )
			{
				$last_var = $i;
				$first_line_for_ins = $i + 1;
			}
			elsif( $line =~ m/^\s*$/ )
			{
				if( $first_line_for_ins == 0 )
				{
					$first_line_for_ins = $i + 1;
				}
			}
		}
		else
		{
			if( $line =~ m/$proc_pattern/i )
			{
				$proc_name = $2;
				$last_proc = $i;
				$in_proc = 1;
			}
			elsif( $line =~ m/$endproc_pattern/i )
			{
				if( lc($proc_name) eq lc($proc) )
				{
					$proc_end = $i;
				}
				$last_proc_end = $i;
				$last_line_for_ins = $i + 1;
				$first_code = 0;
				$in_proc = 0;
			}
			elsif( not $in_proc and $line =~ m/\S+/ )
			{
				$first_code = $i if not $first_code;
			}
		}

		if( $line =~ m/$proc_pattern/i and lc($2) eq lc($proc) )
		{
			$proc_start = $i;
		}

		$i++;
	}
	close MODULE;
	$line_count = $i;
}

1;