#!/usr/bin/perl

#==============================================================================================================
#       .
#
#==============================================================================================================
# -   mailto:adirks@ngs.ru
#
#     .  
#  ()     GNU Generic Public License.
#
#      , 
# - ,         
#-   .
#
#          
#http://www.gnu.org/licenses/gpl.txt   
#gnugpl.eng.txt
#
#       
#http://gnu.org.ru/gpl.html   
#gnugpl.rus.txt
#
#    GNU Generic Public License     .
#    -     (mailto:adirks@ngs.ru , mailto:fe@alterplast.ru)  
#Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

use locale;
use File::Find; #package    
use CodeWorks;

use strict "vars";
use vars qw/ $usage
	$root_dir $backups $proc
	$new_proc_body $check_for_code $added_code /;

$usage = <<EOF
:
   perl code_works.pl []
  :
   -h        -  
   -d <dir>  - ,     (*.1s).     
                .
   -b        -      (  .1s~)
EOF
;

#default values
$root_dir = ".";
$backups = 0;

#target procedure
$proc = "";
#check pattern
$check_for_code = "\(\)";
#code we want to insert in existing procedure
$added_code = "\t();";
#procedure body if it does not exist
$new_proc_body = <<EOF

//___________________________________________________________________
 $proc()
$added_code

EOF
; 

#command line processing
use Getopt::Long;
GetOptions(
	"dir|d=s" => \$root_dir,
	"backup|b" => \$backups
	) 
	or die wintodos($usage);


#traverse through dirs and do work
File::Find::find(\&ProcessMod, $root_dir);


sub ProcessMod()
{
	my $name = $_; #File::Find   $_   
	return unless $name =~ m/^(.*)(\.1s)$/i; #      1s
	#return unless $File::Find::dir =~ m//i;
	return unless $name =~ m/^()(\.1s)$/i; #    

	CodeWorks::ProcessModule($name, $proc);

	my $new_name = "$1.new.1s";

    if( not $CodeWorks::proc_start )
    {
    	print wintodos("$File::Find::dir - add proc\n");

    	my $i = $CodeWorks::last_line_for_ins;
    	$i = $CodeWorks::last_line_for_ins if $CodeWorks::last_line_for_ins;
    	$i = $CodeWorks::last_proc_end + 1 if $CodeWorks::last_proc_end;

    	rename $name, "$name~" if $backups;
		open NEW_MODULE, "> $name";
		print NEW_MODULE @CodeWorks::lines[0 .. $i-1];
		
		print NEW_MODULE "\n" unless( @CodeWorks::lines[$i-1] =~ m/^\s*$/ );
		print NEW_MODULE $new_proc_body;
		print NEW_MODULE "\n" unless( @CodeWorks::lines[$i] =~ m/^\s*$/ );

    	print NEW_MODULE @CodeWorks::lines[$i .. $CodeWorks::line_count-1];
    	close NEW_MODULE;
    }
    elsif( not $CodeWorks::proc_body =~ m/$check_for_code/m )
    {
    	print wintodos("$File::Find::dir - insert code\n");

    	my $i = $CodeWorks::proc_start + 1;

    	rename $name, "$name~" if $backups;
    	open NEW_MODULE, "> $name";
    	print NEW_MODULE @CodeWorks::lines[0 .. $i-1];
    	print NEW_MODULE $added_code, "\n";
    	print NEW_MODULE @CodeWorks::lines[$i .. $CodeWorks::line_count-1];
    	close NEW_MODULE;
    }
}


sub wintodos {
	my $win_chars = "\xA8\xB8\xB9\xC0\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xCA\xCB\xCC\xCD\xCE\xCF\xD0\xD1\xD2\xD3\xD4\xD5\xD6\xD7\xD8\xD9\xDA\xDB\xDC\xDD\xDE\xDF\xE0\xE1\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\xEA\xEB\xEC\xED\xEE\xEF\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\xFA\xFB\xFC\xFD\xFE\xFF";
	my $dos_chars = "\xF0\xF1\xFC\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8A\x8B\x8C\x8D\x8E\x8F\x90\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9A\x9B\x9C\x9D\x9E\x9F\xA0\xA1\xA2\xA3\xA4\xA5\xA6\xA7\xA8\xA9\xAA\xAB\xAC\xAD\xAE\xAF\xE0\xE1\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\xEA\xEB\xEC\xED\xEE\xEF";
	$_ = shift;
	return $_ if $^O eq "cygwin";
	eval("tr/$win_chars/$dos_chars/");
	return $_;
}