package CodeWorks;

#==============================================================================================================
#        .
# 
#==============================================================================================================
# -   mailto:adirks@ngs.ru
#
#     .  
#  ()     GNU Generic Public License.
#
#      , 
# - ,         
#-   .
#
#          
#http://www.gnu.org/licenses/gpl.txt   
#gnugpl.eng.txt
#
#       
#http://gnu.org.ru/gpl.html   
#gnugpl.rus.txt
#
#    GNU Generic Public License     .
#    -     (mailto:adirks@ngs.ru , mailto:fe@alterplast.ru)  
#Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA


our @ISA = qw(Exporter);
our @EXPORT = qw(ProcessModule);

use locale;
use strict "vars";

# ,       
our( 
	$first_proc,		#       
	$last_proc,			#       
	$last_proc_end,		#       
	$last_var,			#   
	$first_code,		#    (  /)
	$first_line_for_ins,# ,     
	$last_line_for_ins, # ,    
	$proc_start,		#   
	$proc_end,			#   
	$proc_body,			#   
	$line_count,		#   
	@lines				#  
);


my $proc_pattern = '^\s*(|Procedure||Function)\s+([\w\d]*)\s*\((.*)\)\s*(\w*).*$';
my $endproc_pattern = '^\s*(\s.*)*$';
my $var_pattern = '^\s*(|Var)\s+([^;]+);.*$';

sub LoadModule($)
{
    my $name = shift;
	open MODULE, "<$name";
	@lines = (<MODULE>);
	close MODULE;
	foreach (@lines)
	{
		$_ =~ s/[\r\n]//g; #  \n  \r,    
	}
}

	  
sub ProcessModule($)
{
    my $proc = shift;
	my $in_proc = 0;
	my $proc_name = "";

	$first_proc = -1;
	$last_proc = -1;
	$last_proc_end = -1;
	$last_var = -1;
	$first_code = -1;
	$first_line_for_ins = -1;
	$last_line_for_ins = -1;
	$proc_start = -1;
	$proc_end = -1;
	$proc_body = "";
	$line_count = @lines;
	my $i = 0;
	my $line;

	foreach $line (@lines)
	{
		if( $first_proc < 0 )
		{
			if( $line =~ m/$proc_pattern/i )
			{
				my $fwd = lc($4);
				if( $fwd ne "forward" and $fwd ne "" )
				{
					$proc_name = $2;
					$first_proc = $i;
					$last_proc = $i;
					$in_proc = 1;
				}
				
			}
			elsif( $line =~ m/$var_pattern/i )
			{
				$last_var = $i;
				$first_line_for_ins = $i + 1;
			}
			elsif( $line =~ m/^\s*$/ )
			{
				if( $first_line_for_ins < 0 )
				{
					$first_line_for_ins = $i + 1;
				}
			}
		}
		else
		{
			if( $line =~ m/$proc_pattern/i )
			{
				$proc_name = $2;
				$last_proc = $i;
				$in_proc = 1;
			}
			elsif( $line =~ m/$endproc_pattern/i )
			{
				if( lc($proc_name) eq lc($proc) )
				{
					$proc_end = $i;
				}
				$last_proc_end = $i;
				$last_line_for_ins = $i + 1;
				$first_code = -1;
				$in_proc = 0;
			}
			elsif( not $in_proc and $line =~ m/\S+/ )
			{
				$first_code = $i if not $first_code;
			}
		}

		if( $line =~ m/$proc_pattern/i and lc($2) eq lc($proc) )
		{
			$proc_start = $i;
		}

		$i++;
	}
	
	if( $proc_start >= 0 and $proc_end >= 0 )
	{
		$proc_body = join("\n", @lines[$proc_start .. $proc_end]);
	}
}

sub FindProc($)
{
    my $proc = lc(shift);

	$proc_start = -1;
	$proc_end = -1;
	$proc_body = "";
	$line_count = @lines;
	my $i = 0;
	my $line;

	while( $i < $line_count )
	{
		$line = @lines[$i];
		if( $proc_start < 0 and $line =~ m/$proc_pattern/i )
		{
			my $fwd = lc($4);
			if( $fwd ne "forward" and $fwd ne "" and lc($2) eq $proc )
			{
				$proc_start = $i;
			}
		}
		elsif( $proc_start >= 0 and $line =~ m/$endproc_pattern/i )
		{
			$proc_end = $i;
			break;
		}

		$i++;
	}

	if( $proc_start >= 0 and $proc_end >= 0 )
	{
		$proc_body = join @lines[$proc_start .. $proc_end], "\n";
		return 1;
	}
	return 0;
}	

#create procedure if it does't exist
sub CreateProc($$$)
{
	my $proc_name = shift;
	my $proc_text = shift;
	my $before_proc = shift;
	my $before_proc_start = -1;
	
	if( $before_proc )
	{
		FindProc($before_proc);
		$before_proc_start = $proc_start;
	}
		  
	ProcessModule($proc_name);
	$proc_start < 0 or return;

	my $i;
    $i = $last_line_for_ins;
    $i = $last_proc_end + 1 if $last_proc_end >= 0;
	$i = $before_proc_start if $before_proc_start >= 0;

	my @proc_text = split(/\n/, $proc_text, -1);
	my $n = @proc_text;
	splice(@lines, $i, 0, @proc_text);

	return 1;
}	

sub ProcStat() #returns ($last_var, $code_start)
{
	my $i;
	my $last_var = -1;

	for( $i = $proc_start + 1; $i < $proc_end; $i++ )
	{
		$last_var = $i if @lines[$i] =~ m/^\s*(Var|)\s+.*$/i;
	}
	
	my $code_start = $last_var + 1;
	$code_start = $proc_start + 1 if $last_var < 0;
	while( $code_start < $proc_end and @lines[$code_start] =~ m/^\s*$/ ) { $code_start++; } #skip blank lines

	return ($last_var, $code_start);
}
	  
#insert var declaration.
sub InsertVarDecl($$$)
{
	my $ObjName = shift; #object name for substitution. E.g.  ""
	my $proc_name = shift;
	my $var_name = shift;
	my $i;
	my $offset = "";
	
	ProcessModule($proc_name);

	if( $proc_name )
	{
		$proc_start >= 0 or return 0;
		for( $i = $proc_start + 1; $i < $proc_end; $i++ )
		{
			return 0 if @lines[$i] =~ m/^\s*(Var|)\s+($var_name|.*?[\s,]+$var_name)[\s,;].*$/i;
		}
		my ($last_proc_var, $code_start) = ProcStat();
		if( $last_proc_var >= 0 )
			{ $i = $last_proc_var + 1; }
		else
			{ $i = $proc_start + 1; }
		$offset = "\t";
	}
	else
	{
		for( $i = 0; $i <= $last_var; $i++ )
		{
			return 0 if @lines[$i] =~ m/[\s,]+$var_name[\s,;]+/;
		}
		$i = $last_var + 1;
	}	

	$var_name =~ s/<ObjectName>/$ObjName/g;
	splice(@lines, $i, 0, "$offset $var_name;");

	return 1;
}

#insert module code
sub InsertCode($$$)
{
	my $ObjName = shift; #object name for substitution. E.g.  ""
	my $proc_name = shift;
	my $code = shift;
	my ($last_proc_var, $code_start);
	my $proc_body;
	
	$code =~ s/<ObjectName>/$ObjName/g;
	$proc_name =~ s/<ObjectName>/$ObjName/g;
	
	ProcessModule($proc_name);
	
	if( $proc_name )
	{
		$proc_start >= 0 && $proc_end >= 0  or return 0;
		($last_proc_var, $code_start) = ProcStat();
		$code =~ s/\n/\n\t/gm; #    
		$code = "\t" . $code;
		$proc_body = join("\n", @lines[$proc_start .. $proc_end]);
	}
	else
	{
		$code_start = @lines - 1;
		while( @lines[$code_start] =~ m/^\s*$/ ) {$code_start--;}
		$code_start++;
		$proc_body = join("\n", @lines[$last_proc_end .. $line_count]);
	}	

	$proc_body =~ s/[\s\r\n]+//g;
	my $test_code = $code;
	$test_code =~ s/[\s\r\n]+//g;
	index($proc_body, $test_code) < 0 or return 0;

	my @code = split(/\n/, $code);
	splice(@lines, $code_start, 0, @code);

	return 1;
}

sub GetObjectName
{
	use File::Basename;
	my $fullname = shift;

	my $dir = File::Basename::dirname( $fullname );
	my $fname = File::Basename::basename( $fullname );

	my @parts = split /[\/\\]+/, $dir;
	my $i = @parts - 1;
	while( @parts[$i] =~ m/\./ and lc(@parts[$i]) ne "" ) { $i--; }

	my $ObjName = $parts[$i];
	my $type = $parts[$i-1];
	my $module_type = "";
	my ($dir_name, $dir_path, $dir_ext) = File::Basename::fileparse($dir);
	
	if( lc($fname) eq ".1s" )
		{ $module_type = ""; }
	elsif( lc($type) eq "" )
		{ $module_type = ""; }
	elsif( $dir =~ m|^.*?[\\/]$ObjName[\\/]+$|i )
		{ $module_type = ""; }
	elsif( lc($dir_ext) eq "fls" and lc($type) eq "" )
		{ $module_type = ""; }
	elsif( lc($type) eq "" )
		{ $module_type = ""; }
	elsif( lc($type) eq "" )
		{ $module_type = ""; }
	elsif( lc($type) eq "" )
		{ $module_type = ""; }
	elsif( lc($type) eq "" )
		{ $module_type = ""; }

	return ($type, $ObjName, $module_type);
}	

sub wintodos {
	my $win_chars = "\xA8\xB8\xB9\xC0\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xCA\xCB\xCC\xCD\xCE\xCF\xD0\xD1\xD2\xD3\xD4\xD5\xD6\xD7\xD8\xD9\xDA\xDB\xDC\xDD\xDE\xDF\xE0\xE1\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\xEA\xEB\xEC\xED\xEE\xEF\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\xFA\xFB\xFC\xFD\xFE\xFF";
	my $dos_chars = "\xF0\xF1\xFC\x80\x81\x82\x83\x84\x85\x86\x87\x88\x89\x8A\x8B\x8C\x8D\x8E\x8F\x90\x91\x92\x93\x94\x95\x96\x97\x98\x99\x9A\x9B\x9C\x9D\x9E\x9F\xA0\xA1\xA2\xA3\xA4\xA5\xA6\xA7\xA8\xA9\xAA\xAB\xAC\xAD\xAE\xAF\xE0\xE1\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\xEA\xEB\xEC\xED\xEE\xEF";
	$_ = shift;
	return $_ if $^O eq "cygwin";
	eval("tr/$win_chars/$dos_chars/");
	return $_;
}


1;
