
#include "Lexer.h"
#include "Strings.h"

#define BUFF_SIZE 4096  //   . .    .

CLexer::CLexer(CString& FileName)
{
	File = fopen(FileName, "rt");
	this->FileName = FileName;
	LineBuff = new char[BUFF_SIZE];
	ptr = NULL;
	nLine = 0;
}

CLexer::~CLexer()
{
	fclose(File);
	if( LineBuff != NULL ) delete[] LineBuff;
}

void CLexer::SkipSpaces(const char* spaces)
{
	if( ptr == NULL )
		return;
	ptr += strspn(ptr, spaces);
}

bool CLexer::GetToken(CString& Token, const char* delimiters, bool ProceedOnNextLine)
{
	while( ptr == NULL )
	{
		if( !ProceedOnNextLine )
		{
			Token = "";
			return false;
		}

		if( fgets(LineBuff, BUFF_SIZE, File) == NULL ) return false;
		nLine++;
		ptr = trim(LineBuff);
		if( *ptr == '\0' ) ptr = NULL;
	}
	
	if( *ptr == '{' || *ptr == '}' )
	{
		Token = *ptr;
		ptr++;
	}
	else
	{
		char* left = ptr;
		char* right = strpbrk(ptr, delimiters);

		if( right != NULL )
		{
			ptr = right + strspn(right, delimiters);
			*right = '\0';
			Token = left;
		}
		else
		{
			Token = ptr;
			ptr = NULL;
		}
	}

	if( ptr != NULL && *ptr == '\0' ) ptr = NULL;

	return true;
}

void CLexer::GetRest(CString& String)
{
	if( ptr == NULL )
		String = "";
	else
		String = ptr;
	ptr = NULL;
}

static CString lexer_error;
CString& CLexer::FilePosInfo()
{
	lexer_error.Format("%s: line %i", FileName, nLine);
	return lexer_error;
}