#include "MMS.h"
#include "NameTable.h"
#include "MMS_Filter.h"
#include "Storage.h"
#include "CommonFunctions.h"
#include "Ordering.h"

///////////////////////////////////////////////////////////////////////
///////////  class CMMSBuh methods  ///////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSBuh::ExtractForm(CString& Dir, CStorage& Storage, 
						  MMSObjectType StorType, MMSObjectType Type)
{
	CNameTableRecord* nt_rec_stor = NameTable.Find(StorType);
	if( Storage.Open(nt_rec_stor->PrepareStorageName(BuhID)) )
	{
		CNameTableRecord* nt_rec = NameTable.Find(Type);
		if( Storage.Open(nt_rec->PrepareStorageName(BuhID)) )
		{
			CString DestDir;

			DestDir = nt_rec->PrepareDirName( nt_rec_stor->PrepareDirName(Dir) );
			CreateDirectory(DestDir);

			ExtractWorkBook(DestDir, Storage);

			Storage.Close();
		}
		Storage.Close();
	}
}

void CMMSBuh::ImportForm(CStorage& Storage, CString& SrcDir, 
						 MMSObjectType StorType, MMSObjectType Type)
{
	CNameTableRecord* nt_rec_stor = NameTable.Find(StorType);
	if( !Storage.Create(nt_rec_stor->PrepareStorageName(ID)) ) return;

	CString FormDir = nt_rec_stor->PrepareDirName(SrcDir);
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage FormStor(Storage);
	FormStor.Create(nt_rec->PrepareStorageName(BuhID));
	if( !ImportWorkBook(FormStor, nt_rec->PrepareDirName(FormDir)) )
	{
		FormStor.Close();
		FormStor.Delete(nt_rec->PrepareStorageName(BuhID));
	}

	Storage.Close();
}

void CMMSBuh::ExtractListForm(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage, 
							  MMSObjectType Type, 
							  CMMSObject* ListForms)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString DestDir = nt_rec->PrepareDirName(Dir);
	CStorage ListStor(Storage, nt_rec->StorageName);
	CreateDirectory(DestDir);
	ExtractListForms(ListForms, DestDir, ListStor, nt_rec->StorageName+"_Number");

	ListForms->ExtractMetadata(Dir, Type, TypedTextStorage);
}

void CMMSBuh::ImportListForm(CStorage& Storage, CString& SrcDir, 
							 MMSObjectType Type, 
							 CMMSObject* ListForms)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CStorage ListStor(Storage);
	ListStor.Create(nt_rec->StorageName);
	ImportListForms(ListForms, ListStor, nt_rec->PrepareDirName(SrcDir), nt_rec->StorageName+"_Number");
}

////////////////////////////////////////////////////////
//Main decompilation method
void CMMSBuh::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	if( GetNProps() == 0 ) return;

	CNameTableRecord* nt_rec;
	CNameTableRecord* nt_rec_buh = NameTable.Find(MMS_Buh);

	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec_buh) )
	{
		CString BuhDir = nt_rec_buh->PrepareDirName(Dir);
		
		CreateDirectory(BuhDir);

		// 
		ExtractForm(BuhDir, Storage, NT_AccFormStor, NT_AccForm);
		// 
		ExtractForm(BuhDir, Storage, NT_OperFormStor, NT_OperForm);

		//  
		ExtractListForm(BuhDir, Storage, TypedTextStorage, NT_AccListForm, AccListForms);
		// 
		ExtractListForm(BuhDir, Storage, TypedTextStorage, NT_ProvListForm, ProvListForms);
		// 
		ExtractListForm(BuhDir, Storage, TypedTextStorage, NT_OperListForm, OperListForms);
		//  .       . , -  .
		UnknownListForms->ExtractMetadata(BuhDir, NT_UnknownListForm, TypedTextStorage);

		CString BuhParams;
		BuhParams.Format("\"%i\"", ID);

		int state = 0;
		for( int i = 0; i < GetNProps(); i++ )
		{
			CMMSObject* obj = (CMMSObject*)GetPropByNum(i);
			
			//  ,    
			if( (obj->Type == MMS_Property) || (obj->Type == MMS_Object) )
			{
				if( state == 0 )
				{
					if( BuhParams.GetLength() > 1 ) BuhParams += ",\r\n";
					BuhParams += obj->AsString();
				}
				continue;
			}
			else
			{
				state = 1; //,     
			}

			CMMSObjectWithProps* prop = (CMMSObjectWithProps*)obj;

			if( prop->Type == MMS_Plans )
			{
				((CMMSAccountPlans*)prop)->Decompile(BuhDir, Storage, TypedTextStorage);
				continue;
			}

			nt_rec = NameTable.Find(prop->Type);
			if( nt_rec == NULL ) continue;
			if( nt_rec->FileName.GetLength() == 0 ) continue;

			prop->ExtractMetadata(BuhDir, prop->Type, TypedTextStorage);
		}

		ExtractDescriptions(BuhDir+"\\", TypedTextStorage, false);

		Storage.CopyStringToFile(BuhParams, nt_rec_buh->PrepareFileName(Dir));
	}
	MMS_Filter.Up();
}

////////////////////////////////////////////////////////
//Main compilation method
void CMMSBuh::Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir)
{
	CNameTableRecord* nt_rec_buh = NameTable.Find(Type);
	CString BuhDir = nt_rec_buh->PrepareDirName(SrcDir);

	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec_buh) )
	{
		// 
		ImportForm(Storage, BuhDir, NT_AccFormStor, NT_AccForm);
		// 
		ImportForm(Storage, BuhDir, NT_OperFormStor, NT_OperForm);

		//  
		ImportListForm(Storage, BuhDir, NT_AccListForm, AccListForms);
		// 
		ImportListForm(Storage, BuhDir, NT_ProvListForm, ProvListForms);
		// 
		ImportListForm(Storage, BuhDir, NT_OperListForm, OperListForms);

		//
		for( int i = 0; i < GetNProps(); i++ )
		{
			CMMSAccountPlan* Plan = (CMMSAccountPlan*)GetPropByNum(i);
			Plan->Compile(Storage, TypedTextStorage, BuhDir);
		}

		ImportDescriptions(TypedTextStorage, BuhDir+"\\", false);
	}
	MMS_Filter.Up();
}


////////////////////////////////////////////////////////////
////     ////////////////////////////////////////
////////////////////////////////////////////////////////////
void CMMSAccountPlans::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString PlansDir = nt_rec->PrepareDirName(Dir, this);

	CObjectOrdering Order(2);
	for( int i = 0; i < GetNProps(); i++ )
	{
		CMMSAccountPlan* Plan = (CMMSAccountPlan*)GetPropByNum(i);
		Plan->Decompile(PlansDir, Storage, TypedTextStorage, Order);
	}

	ExtractDescriptions(PlansDir+"\\", TypedTextStorage, true);

	Order.WriteFile(Storage, PlansDir);
}

void CMMSAccountPlans::Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString PlansDir = nt_rec->PrepareDirName(SrcDir, this);

	for( int i = 0; i < GetNProps(); i++ )
	{
		CMMSAccountPlan* Plan = (CMMSAccountPlan*)GetPropByNum(i);
		Plan->Compile(Storage, TypedTextStorage, PlansDir);
	}

	ImportDescriptions(TypedTextStorage, PlansDir+"\\", true);
}

void CMMSAccountPlan::Decompile(CString& Dir, CStorage& Storage, CStorage& TypedTextStorage, CObjectOrdering& Order)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString PlanDir = nt_rec->PrepareDirName(CString(), this);

	Order.Add(ID, PlanDir, PlanDir);

	PlanDir = nt_rec->PrepareDirName(Dir, this);
	CreateDirectory(PlanDir);

	CNameTableRecord* nt_rec_mdp = NameTable.Find(NT_MetadataPart);
	CString FName = nt_rec_mdp->PrepareFileName(PlanDir, this);
	Storage.CopyStringToFile(HdrAsString(), FName);

	CObjectOrdering AccountsOrder(2);
	for( int i = 0; i < Accounts->GetNProps(); i++ )
	{
		CMMSAccount* Account = (CMMSAccount*)Accounts->GetPropByNum(i);
		Account->Decompile(PlanDir, Storage, AccountsOrder);
	}

	ExtractDescriptions(PlanDir+"\\", TypedTextStorage, true);

	AccountsOrder.WriteFile(Storage, PlanDir);
}

void CMMSAccountPlan::Compile(CStorage& Storage, CStorage& TypedTextStorage, CString& SrcDir)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString PlanDir = nt_rec->PrepareDirName(SrcDir, this);

	ImportDescriptions(TypedTextStorage, PlanDir+"\\", true);
}

void CMMSAccount::Decompile(CString& Dir, CStorage& Storage, CObjectOrdering& Order)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString FName = nt_rec->PrepareFileName(CString(), this);

	FName.Replace("%Code%", Code);

	Order.Add(ID, FName, FName);

	Storage.CopyStringToFile(AsString(-1), Dir+"\\"+FName);
}

