
#include "CommonFunctions.h"
#include "MMS_Filter.h"
#include "MMS.h"
#include "NameTable.h"


void CMMSFilter::Init(char* str)
{
	if( Filter != NULL ) delete Filter;

	if( str == NULL )
		Filter = NULL;
	else
	{
		CString Str;
		Str.Format("\\%s", str);
		Filter = SplitPath(Str);
	}
	Level = 0;
}

CMMSFilter::CMMSFilter()
{
	Filter = NULL;
	Level = 0;
}

CMMSFilter::~CMMSFilter()
{
	if( Filter != NULL ) delete Filter;
}

bool CMMSFilter::Test(CMMSObject* Object, CNameTableRecord* Record)
{
	if( Filter == NULL ) return true;
	if( Filter->GetSize() <= Level ) return true;

	CString& FilterString = Filter->GetAt(Level);

	if( FilterString.IsEmpty() || FilterString == '*' ) return true;
	if( Object != NULL && FilterString == Object->sID ) return true;
	if( Record != NULL && (
			FilterString == Record->Type1C ||
			FilterString == Record->sID ||
			FilterString == Record->Dir ||
			FilterString == Record->FileName) ) return true;

	return false;
}

bool CMMSFilter::Test(CString& Name)
{
	if( Filter == NULL ) return true;
	if( Filter->GetSize() <= Level ) return true;

	if( Name == Filter->GetAt(Level) )
		return true;
	else
		return false;
}