
#include "UI.h"
#include "CommonFunctions.h"
#include "NameTable.h"
#include "MMS_Filter.h"
#include "Storage.h"
#include "Container.h"
#include "Strings.h"


DWORD CUIUnits::YesNo2DWORD(CString& str)
{
	if( str.CollateNoCase("") == 0 ) return 1;
	return 0;
}

DWORD StrToID(CString& str)
{
	char *stopstring;
	return strtol(str, &stopstring, 16);
}

bool CUICommands::ReadFromFile(CString& FileName)
{
	CLexer Lexer(FileName);
	if( !Lexer.IsValid() )
	{
		Msg(0, "ERR: Can not open file '%s': %s", FileName, strerror(errno));
		throw NULL;
	}

	CUICommand* Command = NULL;
	int state = 1; //1 - ; 2 - ; 3 - ; 4   ; 5 -  '}' 
	CString token, value;

	Msg(2, "  '%s'", FileName);

	NCommands = 0;
	Commands.SetSize(128);

	//     (.. )
	//        ( ":")
	while( Lexer.GetToken(token, ":") )
	{
		Lexer.SkipSpaces();
		switch( state )
		{
		case 1: //  
			if( token == '{' )
				state = 2;
			else
			{
				Lexer.GetRest(value);
				if( token.CollateNoCase("") == 0 ) 
					StorageName = value;
				else if( token.CollateNoCase("") == 0 )
				{
					if( value.CollateNoCase("") == 0 )
						IsChild = false;
					else
						IsChild = true;
				}
				else if( token.CollateNoCase("") == 0 )
					InterfaceName = value;
				else if( token.CollateNoCase("") == 0 )
					ParentInterface = value;
				else if( token.CollateNoCase("") == 0 )
					Description = value;
				else if( token.CollateNoCase("") == 0 )
					NoOperMenuPresent = YesNo2DWORD(value);
				else if( token.CollateNoCase("") == 0 )
					IsDefault = YesNo2DWORD(value);
			}
			break;
		case 2: // 
			if( token == '}' )
			{
				state = 5;
			}
			else
			{
				Lexer.GetRest(value);
				NCommands++;
				if( Commands.GetSize() < NCommands ) Commands.SetSize(Commands.GetSize()*2);
				Command = &(Commands[NCommands-1]);
				if( IsChild )
				{
					//       2 (  state = 3  )
					Command->Command = token;
					Command->CmdParameter = value;
				}
				else
				{
					Command->ID = StrToID(token);
					state = 3;
				}
			}
			break;
		case 3: // 
			if( token == '}' ) //   
			{
				state = 2;
			}
			else if( token == '{' ) //   
			{
			}
			else
			{
				if( token.CollateNoCase("1") == 0 ) 
					Lexer.GetRest(Command->Param1);
				else if( token.CollateNoCase("Hint") == 0 )
					Lexer.GetRest(Command->Hint);
				else if( token.CollateNoCase("HotKey") == 0 )
				{
					Lexer.GetToken(token, ": \t", false);
					Lexer.GetRest(value);
					if( value.IsEmpty() )
					{
						Command->HotKey = StrToID(token);
					}
					else
					{
						Command->HotKeyModifier = StrToID(token);
						Command->HotKey = StrToID(value);
					}
				}
				else if( token.CollateNoCase("") == 0 )
					Lexer.GetRest(Command->Command);
				else if( token.CollateNoCase("") == 0 )
					Lexer.GetRest(Command->CmdParameter);
			}
			break;
		case 4: //   
			break;
		case 5: //    
			Msg(0, "WARN:  : %s", Lexer.FilePosInfo());
			break;
		default:
			Msg(0, "WARN:  : %s", Lexer.FilePosInfo());
			break;
		}
	}

	if( state == 5 )
		return true;
	else
		return false;
}

bool CUICommands::Write(CStorage& Storage, CString& SrcDir)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_UICommands);
	Storage.CreateStream(nt_rec->PrepareStorageName());
	IStream* pStream = Storage.pStream;

	pStream->Write(&ID, sizeof(ID), NULL);
	if( IsChild )
	{
		WriteSizedString(pStream, ParentInterface);
	}
	else
	{
		WriteSizedString(pStream, Description);
	}
	pStream->Write(&NoOperMenuPresent, sizeof(NoOperMenuPresent), NULL);
	pStream->Write(&IsDefault, sizeof(IsDefault), NULL);

	if( IsChild )
	{
		WriteSizedString(pStream, Description);
	}
	
	pStream->Write(&NCommands, sizeof(NCommands), NULL);

	for( DWORD i = 0; i < NCommands; i++ )
	{
		CUICommand& cmd = Commands[i];
		
		cmd.CmdParameter.Replace("~~", "\n");
		if( IsChild )
		{
			WriteSizedString(pStream, cmd.Command);
			WriteSizedString(pStream, cmd.CmdParameter);
		}
		else
		{
			pStream->Write(&cmd.ID, sizeof(cmd.ID), NULL);
			
			WriteSizedString(pStream, cmd.Param1);
			WriteSizedString(pStream, cmd.Hint);
			
			pStream->Write(&cmd.HotKeyModifier, sizeof(cmd.HotKeyModifier), NULL);
			pStream->Write(&cmd.HotKey, sizeof(cmd.HotKey), NULL);

			WriteSizedString(pStream, cmd.Command);
			WriteSizedString(pStream, cmd.CmdParameter);
		}
	}

	Msg(2, "CPY: %s", nt_rec->PrepareFileName(SrcDir));

	return true;
}

CUIMenu* CUIMenu::AddItem()
{
	NItems++;
	if( Items.GetSize() < NItems )
	{
		if( Items.GetSize() == 0 )
			Items.SetSize(32);
		else
			Items.SetSize(Items.GetSize()*2);
	}
	Items[NItems-1].Parent = this;
	return &(Items[NItems-1]);
}

bool CUIMenu::ReadFromFile(CLexer& Lexer, CUIMenu* Parent, int level)
{
	Level = level;
	NItems = 0;
	CUIMenu* Item;
	CString token, value;
	while( Lexer.GetToken(token, ": \t") )
	{
		if( token == '{' )
		{
		}
		else if( token == '}' )
		{
			return true;
		}
		else if( token.CollateNoCase("") == 0 )
		{
			Type = MainMenu;
			ID = 0x01;
		}
		else if( token.CollateNoCase("") == 0 )
		{
			Item = AddItem();
			Item->Type = MenuGroup;
			Item->ID = 0xFFFFFFFF;
			Lexer.GetRest(Item->Caption);
			Item->ReadFromFile(Lexer, Item, level + 1);
		}
		else if( token.CollateNoCase("") == 0 )
		{
			Item = AddItem();
			Item->Type = MenuItem;
			Lexer.GetToken(token);
			Item->ID = StrToID(token);
			Lexer.GetRest(Item->Caption);
			Item->Level = Level + 1;
		}
		else if( token.CollateNoCase("") == 0 )
		{
			Item = AddItem();
			Item->Type = MenuDividor;
			Item->ID = 0x00;
			Item->Level = Level + 1;
		}
	}
	return true;
}


bool CUIMenu::ReadFromFile(CString& FileName)
{
	CLexer Lexer(FileName);

	Msg(2, "  '%s'", FileName);

	ReadFromFile(Lexer, NULL, 0);
	return true;
}

bool CUIMenu::Write(CStorage& Storage, CString& SrcDir)
{
	if( Type == MainMenu )
	{
		CNameTableRecord* nt_rec = NameTable.Find(NT_UIMenu);
		Storage.CreateStream(nt_rec->PrepareStorageName());
		Msg(2, "CPY: %s", nt_rec->PrepareFileName(SrcDir));
	}
	IStream* pStream = Storage.pStream;

	pStream->Write(&ID, sizeof(ID), NULL);

	if( Type == MenuGroup || Type == MenuItem )
	{
		WriteSizedString(pStream, Caption);
	}

	if( Type == MainMenu || Type == MenuGroup )
	{
		pStream->Write(&NItems, sizeof(NItems), NULL);
	}

	for( int i = 0; i < NItems; i++ )
	{
		Items[i].Write(Storage, SrcDir);
	}

	return true;
}


bool CUIPanel::Write(CStorage& Storage)
{
	IStream* pStream = Storage.pStream;
	WriteSizedString(pStream, Caption);
	pStream->Write(&NButtons, sizeof(NButtons), NULL);
	pStream->Write(&Placement, sizeof(Placement), NULL);
	pStream->Write(&IsVisible, sizeof(IsVisible), NULL);
	pStream->Write(&OnNewLine, sizeof(OnNewLine), NULL);
	return true;
}

bool CUIPanels::ReadFromFile(CString& FileName)
{
	CLexer Lexer(FileName);
	CString token, value;
	CUIPanel Panel;
	CUIButton Button;
	int state = 0; //0 -  ; 1 -  ; 2 -    ; 3 -   ; 4 -    

	Msg(2, "  '%s'", FileName);

	while( Lexer.GetToken(token, ": \t") )
	{
		if( token == '{' ) 
			continue;
		if( token == '}' )
		{
			state = 0;
			continue;
		}

		Lexer.GetRest(value);
		switch( state )
		{
		case 0:
			if( token.CollateNoCase("") == 0 )
			{
				Panels.Add(Panel);
				Panels[NPanels].Caption = value;
				NPanels++;
				state = 1;
			}
			else if( token.CollateNoCase("") == 0 )
			{
				state = 2;
			}
			else if( token.CollateNoCase("") == 0 )
			{
				state = 3;
			}
			else if( token.CollateNoCase("") == 0 )
			{
				state = 4;
			}
			break;
		case 1:
			{
				CUIPanel& Panel = Panels[NPanels-1];
				if( token.CollateNoCase("") == 0 )
				{
					if( value.CollateNoCase("") == 0 ) Panel.Placement = 0xE81B;
					if( value.CollateNoCase("")  == 0 ) Panel.Placement = 0xE81C;
					if( value.CollateNoCase("") == 0 ) Panel.Placement = 0xE81D;
					if( value.CollateNoCase("")  == 0 ) Panel.Placement = 0xE81E;
				}
				else if( token.CollateNoCase("") == 0 )
					Panel.IsVisible = YesNo2DWORD(value);
				else if( token.CollateNoCase("") == 0 )
					Panel.OnNewLine = YesNo2DWORD(value);
				else if( token.CollateNoCase("") == 0 )
					Panel.NButtons = atol(value);
			}
			break;
		case 2:
			AllButtons.Add(Button);
			AllButtons[NButtons++].ID = StrToID(token);
			break;
		case 3:
			TextButtons.Add(Button);
			TextButtons[NTextButtons].ID = StrToID(token);
			TextButtons[NTextButtons].Caption = value;
			NTextButtons++;
			break;
		case 4:
			PictureButtons.Add(Button);
			PictureButtons[NPictureButtons++].ID = StrToID(token);
			break;
		}
	}

	return true;
}

bool CUIPanels::Write(CStorage& Storage, CString& Dir)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_UIPanels);
	Storage.CreateStream(nt_rec->PrepareStorageName());
	IStream* pStream = Storage.pStream;
	DWORD i;

	pStream->Write(&ID, sizeof(ID), NULL);
	pStream->Write(&NPanels, sizeof(NPanels), NULL);
	
	for( i = 0; i < NPanels; i++ )
	{
		Panels[i].Write(Storage);
	}

	for( i = 0; i < NButtons; i++ )
	{
		pStream->Write(&AllButtons[i].ID, sizeof(AllButtons[i].ID), NULL);
	}

	pStream->Write(&NTextButtons, sizeof(NTextButtons), NULL);
	for( i = 0; i < NTextButtons; i++ )
	{
		WriteSizedString(pStream, TextButtons[i].Caption);
		pStream->Write(&TextButtons[i].ID, sizeof(TextButtons[i].ID), NULL);
	}

	pStream->Write(&NPictureButtons, sizeof(NPictureButtons), NULL);
	for( i = 0; i < NPictureButtons; i++ )
	{
		pStream->Write(&PictureButtons[i].ID, sizeof(PictureButtons[i].ID), NULL);
	}

	CNameTableRecord* nt_rec_b = NameTable.Find(NT_UIPanelsBMP);
	Storage.AppendFile(pStream, nt_rec_b->PrepareFileName(Dir));

	Msg(2, "CPY: %s", nt_rec->PrepareFileName(Dir));
	Msg(2, "CPY: %s", nt_rec_b->PrepareFileName(Dir));

	return true;
}

void CUserInterfaces::ReadFromDir(CString& SrcDir, CUserInterface* Parent)
{
	CString DirName;
	struct _finddata_t find_data;
	long hFind;

	hFind = _findfirst(SrcDir+"\\*", &find_data);
	if( hFind != -1 )
	{
		do
		{
			if( IsIgnoredFile(find_data.name) ) continue;
			
			if( (find_data.attrib & _A_SUBDIR) != 0 )
			{
				DirName.Format("%s\\%s", SrcDir, find_data.name);
				CUserInterface* Interface = new CUserInterface;
				if( Interface->ReadFromDir(DirName, Parent) )
				{
					Add(Interface);
				}
				else
				{
					delete Interface;
				}
			}
		} while( _findnext(hFind, &find_data) == 0 );
		_findclose(hFind);
	}
}


bool CUserInterface::ReadFromDir(CString& SrcDir, CUserInterface* Parent)
{
	CNameTableRecord* nt_rec_c = NameTable.Find(NT_UICommands);
	CNameTableRecord* nt_rec_m = NameTable.Find(NT_UIMenu);
	CNameTableRecord* nt_rec_p = NameTable.Find(NT_UIPanels);
	CNameTableRecord* nt_rec_pb = NameTable.Find(NT_UIPanelsBMP);

	CString CommandsFName = nt_rec_c->PrepareFileName(SrcDir);
	CString MenuFName = nt_rec_m->PrepareFileName(SrcDir);
	CString PanelsFName = nt_rec_p->PrepareFileName(SrcDir);

	if( !FileExist(CommandsFName) ) return false;

	this->DirName = SrcDir;
	this->Parent = Parent;
	Commands.ReadFromFile(CommandsFName);
	Name = Commands.InterfaceName;

	if( FileExist(MenuFName) ) Menu.ReadFromFile(MenuFName);
	if( FileExist(PanelsFName) ) Panels.ReadFromFile(PanelsFName);

	Children.ReadFromDir(SrcDir, this);

	return true;
}

bool CUserInterface::Write(CStorage& Storage)
{
	Storage.Create(Commands.StorageName);
	Commands.Write(Storage, DirName);
	if( !Commands.IsChild )
	{
		Menu.Write(Storage, DirName);
		Panels.Write(Storage, DirName);
	}
	CContainer CC;
	CC.Create(Storage, false, CT_UserInterfaces);
	Storage.Close();

	for( int i = 0; i < Children.GetSize(); i++ )
	{
		Children[i]->Write(Storage);
	}

	return true;
}

void CUserInterface::MakeContainerContents(CString& CC)
{
	if( Commands.IsChild )
		CC += ",{\"SubUsersInterfaceType\",\"";
	else
		CC += ",{\"UsersInterfaceType\",\"";
	CC += Commands.StorageName;
	CC += "\",\"";
	CC += Name;
	CC += "\",\"\"}";

	for( int i = 0; i < Children.GetSize(); i++ )
	{
		Children[i]->MakeContainerContents(CC);
	}
}


bool CompileUI(CStorage& Storage, CString& SrcDir)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_UserInterface);
	CString UIDir = nt_rec->PrepareDirName(SrcDir);
	CStorage UIStorage(Storage);
	CUserInterfaces UserInterfaces;

	MMS_Filter.Down();
	bool ToExtract = MMS_Filter.Test(NULL, nt_rec);
	if( ToExtract )
	{
		UserInterfaces.ReadFromDir(UIDir);

		UIStorage.Create(nt_rec->PrepareStorageName());
		CString CC = "{\"Container.Contents\"";
		int i, sz = UserInterfaces.GetSize();
		for( i = 0; i < sz; i++ )
		{
			CUserInterface& Interface = *(UserInterfaces.GetAt(i));
			Interface.Write(UIStorage);
			Interface.MakeContainerContents(CC);
		}
		CC += "}\n";

		UIStorage.StreamFromString(CString("Container.Contents"), CC);
	}
	MMS_Filter.Up();
	return ToExtract;
}