# vim:fileencoding=cp1251
#
# ExtractProc
# Author: Alexander S. Gordienko <alex-go@vstu.kirov.ru>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import sys, getopt, re, os, os.path, string



#########################################################################
##############      Extract functions into files      ###################
#########################################################################
def Extract(Dir, ModuleName):
	global SrcDir, DestDir

	FullName = os.path.join(Dir, ModuleName)
	ModuleName = os.path.splitext(ModuleName)[0]

	dir_len = len(SrcDir) + 1
	relDir = Dir[dir_len:]
	ExtractPath = os.path.join(DestDir, relDir, ModuleName)
	relModulePath = os.path.join(relDir, ModuleName)

	if not os.path.exists(ExtractPath):
		os.makedirs(ExtractPath)

	Module = string.split(open(FullName, 'rb').read(), os.linesep)
	newModule = ''

	headRem     = re.compile(r'^\s*//\*+\s*$', re.I)
	bodyRem     = re.compile(r'(^\s*//.*$|^\s*$)', re.I)
	forvardProc = re.compile(r'^\s*(?:|)\s+(?P<name>[0-9a-zA-Z--_]+)\s*' + \
                            	r'\([^\)]*\)\s*(?:)?\s*(?:)', re.I)
	headProc    = re.compile(r'^\s*(?:|)\s+(?P<name>[0-9a-zA-Z--_]+)', re.I)
	tailProc    = re.compile(r'^\s*(?:|).*$', re.I)
    
	State = 0
	LineNum = 0
	beginScope = 0
	endScope = 0
	procName = ''
    
	for line in Module:
		head = string.join(Module[LineNum:LineNum+10])
		if 0 == State:
			tmp = headProc.match(line)
			if (None == forvardProc.match(head)) and (None != tmp):
				State = 2
				procName = tmp.group('name')
				beginScope = LineNum            
			elif None != headRem.match(line):
				State = 1
				beginScope = LineNum            
		elif 1 == State:
			tmp = headProc.match(line)
			if (None == forvardProc.match(head)) and (None != tmp):
				State = 2
				procName = tmp.group('name')
			elif None == bodyRem.match(line):
				State = 0
		elif 2 == State:
			if None != tailProc.match(line):
				State = 0
				newModule = newModule + string.join(Module[endScope:beginScope], os.linesep) + \
            				os.linesep + '//### ' + procName + '.txt' + os.linesep
				endScope = LineNum + 1

				print unicode(relModulePath + '.' + procName, 'windows-1251')
				open(os.path.join(ExtractPath, procName + '.txt'),
        				'wb').write(string.join(Module[beginScope:endScope], os.linesep))
		LineNum += 1            

	newModule = newModule + string.join(Module[endScope:], os.linesep)
	open(os.path.join(ExtractPath, ModuleName + '.1ss'), 'wb').write(newModule)

def visit(arg, dir, names):
	for name in names:
		if os.path.splitext(name)[1] in ('.1s', '.1S'):
			Extract(dir, name)


#########################################################################
############## Assemble separate functions into single module  ##########
#########################################################################
def Assemble(Dir, ModuleName):
	global SrcDir, DestDir

	dir_len = len(SrcDir) + 1
	relDir = Dir[dir_len:]

	FullModuleName = os.path.join(Dir, ModuleName)
	relName = os.path.join(relDir, ModuleName)
	ModuleName = os.path.splitext(ModuleName)[0]

	SkeletonDir = os.path.join(DestDir, relDir, ModuleName)
	SkeletonName = os.path.join(SkeletonDir, ModuleName + '.1ss')

	if not os.path.exists(SkeletonName):
		return

	print unicode(os.linesep + relName + ':', 'cp1251')

	ProcPlace = re.compile(r'^//### (?P<ProcFile>\S+)\s*$', re.I)

	Module = ''
	ToWrite = 0
	Skeleton = string.split(open(SkeletonName, 'rb').read(), os.linesep)
	for line in Skeleton:
		res = ProcPlace.match(line)
		if res != None:
			ProcFile = os.path.join(SkeletonDir, res.group('ProcFile'))
			Module = Module + open(ProcFile, 'rb').read() + os.linesep
			ToWrite = 1

			relName = res.group('ProcFile')
			print unicode('    .' + relName, 'cp1251')
		else:
			Module = Module + line + os.linesep

	if ToWrite:
		Module = string.rstrip(Module) + os.linesep #     
		open(FullModuleName, 'wb').write(Module)

#------------------------------------------------------------------------
def visit_assemble(arg, dir, names):
	for name in names:
		if os.path.splitext(name)[1] in ('.1s', '.1S'):
			Assemble(dir, name)

def main():
	global SrcDir, DestDir
	
	try:
		opts, args = getopt.getopt(sys.argv[1:],
                                	'hemp:f:b:',
                                	['help', 'extract',
                                	'make', 'extract_path=',
                                	'file=', 'base_path='])
	except getopt.GetoptError:
		usage()
		sys.exit(2)

	global fnModule, ExtractPath

	Action = 0    
	SrcDir = ''
	DestDir = ''
	fnModule = ''
	ProcessAll = 0
    
	for o, a in opts:
		if o in ('-h', '--help'):
			usage()
			sys.exit()
		elif o in ('-e', '--extract'):
			Action = 1
		elif o in ('-m', '--make'):
			Action = 2
		elif o in ('-p', '--extract_path'):
			DestDir = os.path.abspath(a)
		elif o in ('-f', '--file'):
			fnModule = os.path.abspath(a)
		elif o in ('-b', '--base_path'):
			SrcDir = os.path.abspath(a)
			ProcessAll = 1
		else:
			usage()
			sys.exit(2)

	if ProcessAll == 0:
		(SrcDir, fnModule) = os.path.split(fnModule)

	if SrcDir == '':
		SrcDir = r'.\Src'
	if DestDir == '':
		DestDir = SrcDir

	if Action == 1:
		if ProcessAll == 1:
			os.path.walk(SrcDir, visit, '')
		else:
			Extract(SrcDir, fnModule)
	elif Action == 2:
		if ProcessAll == 1:
			os.path.walk(SrcDir, visit_assemble, '')
		else:          
			Assemble(SrcDir, fnModule)
	else:
		usage()
		sys.exit(2)

def usage():
	print u"""
: ExtractProc.py {-e|-m|-h} [-b <base_path> | [-f <file>] [-p <extract_path>]] 

:
    -h | --help         -  
    -e | --extract      -  /  
    -m | --make         -  /  
    -f | --file         -  
    -p | --extract_path -   
    -b | --base_path    -    gcomp 
                            (  *.1s)

:
    ExtractProc.py -e -f .\Src\.1s -p .\Src\
    ExtractProc.py -e -f .\Src\\\.1s
    ExtractProc.py -e -b .\Src
"""

if __name__ == '__main__':
	main()
