
#include "Declarations.h"
#include "MMS.h"
#include "NameTable.h"

typedef struct tagTObjectNameRecord {
	char* Name;
	MMSObjectType Type;
	MMSObjectType Qualifier;
	bool HasProperties;
	tagTObjectNameRecord* Children;

} TObjectNameRecord;

#define OBJ_PROPERTY ((char*)0x01)


TObjectNameRecord ObjectWithDescr[] = {
	{"", NT_MetadataPart, MMS_Property, false, NULL},
	{"",   NT_UserHelp,     MMS_Property, false, NULL},
	{NULL}
};

TObjectNameRecord DialogForm[] = {
	{"",   NT_FormModule, MMS_Property, false, NULL},
	{"",   NT_DialogForm, MMS_Property, false, NULL},
	{"",  NT_MoxelSheet, NT_MoxelSheet,  true, NULL},
	{"", NT_UserHelp,   MMS_Property, false, NULL},
	{NULL}
};

TObjectNameRecord Reference[] = {
	{"", NT_UserHelp,   MMS_Property, false, NULL},
	{"",       MMS_Object,          MMS_Property, false, DialogForm},
	{"", NT_SubcontoFolder,   MMS_Property, false, DialogForm},
	{"", NT_SubcontoListForm, NT_SubcontoListForm,  true,  DialogForm},
	{OBJ_PROPERTY,  MMS_SbCntParams,     MMS_SbCntParams,  false, ObjectWithDescr}, //property
	{NULL}
};

TObjectNameRecord Names[] = {
	{"",  MMS_Consts,    MMS_Consts, false, ObjectWithDescr},
	{"", MMS_SbCnts,    MMS_SbCnt, true,  Reference},
	{"",    MMS_Registers, MMS_Register, false, ObjectWithDescr},
	{NULL}
};

TObjectNameRecord* FindRecord(TObjectNameRecord* record, bool HasProperties, const char* Name)
{
	if( record == NULL ) return NULL;

	TObjectNameRecord* first_record = record;

	while( record->Name != NULL )
	{
		if( record->Name != OBJ_PROPERTY && _stricoll(record->Name, Name) == 0 )
			return record;
		record++;
	}

	if( HasProperties )
	{
		record = first_record;
		while( record->Name != NULL )
		{
			if( record->Name == OBJ_PROPERTY ) return record;
			record++;
		}
	}

	return NULL;
}


bool GetToken(CString& Name, CString& Token)
{
	Token = Name.SpanExcluding("./\\");
	if( Token.IsEmpty() ) return false;
	Name = Name.Mid(Token.GetLength());
	int len = Name.SpanIncluding("./\\").GetLength();
	if( len > 0 ) Name = Name.Mid(len);
	return true;
}

bool NameToPath(CString Name, CString& Path)
{
	TObjectNameRecord *record = Names;
	bool HasProperties = false;
	CString Token;
	CMMSObject obj;
	CNameTableRecord* nt_rec;

	while( GetToken(Name, Token) )
	{
		record = FindRecord(record, HasProperties, Token);
		if( record == NULL ) return false;

		if( record->Qualifier != MMS_Property )
		{
			GetToken(Name, Token);
			obj.sID = Token;
		}

		nt_rec = NameTable.Find(record->Type);
		if( nt_rec != NULL )
		{
			if( !nt_rec->Dir.IsEmpty() && !nt_rec->FileName.IsEmpty() )
			{
				Path = nt_rec->PrepareFileName(Path, &obj);
			}
			else if( !nt_rec->Dir.IsEmpty() )
				Path = nt_rec->PrepareDirName(Path, &obj);
			else
				Path = nt_rec->PrepareFileName(Path, &obj);
		}

		if( record->Qualifier != MMS_Property && record->Qualifier != record->Type )
		{
			nt_rec = NameTable.Find(record->Qualifier);
			if( nt_rec != NULL )
			{
				if( !nt_rec->Dir.IsEmpty() && !nt_rec->FileName.IsEmpty() )
				{
					Path = nt_rec->PrepareFileName(Path, &obj);
				}
				else if( !nt_rec->Dir.IsEmpty() )
					Path = nt_rec->PrepareDirName(Path, &obj);
				else
					Path = nt_rec->PrepareFileName(Path, &obj);
			}
		}

		HasProperties = record->HasProperties;
		record = record->Children;
	}

	return true;
}
