
////////////////////////////////////////////////////////////////////
//////      Container.Contents   ///////////////////
////////////////////////////////////////////////////////////////////

#ifndef CONTAINER_H
#define CONTAINER_H

typedef struct
{
	LPCSTR Type;
	LPCSTR Descr;
} CContainerInfo;

typedef enum{CT_Normal, CT_UserInterfaces} CContainerType;

class CContainer
{
public:
	CString Content;

public:
	CContainer();

	CString& Create(CStorage& Storage, bool Recursive, CContainerType Type = CT_Normal);

private:
	void Add(LPCSTR Type, LPCSTR Name, LPCSTR Descr);
	void AddDir(LPSTR DirName);
	void AddDir(const wchar_t* wDirName);
	void AddFile(LPSTR FileName, CContainerType Type = CT_Normal);
	void AddFile(const wchar_t* wFileName, CContainerType Type = CT_Normal);

};

#endif